/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

// utility functions for both client and mapeditor
 
#ifndef _CLMUTILS_H_
#define _CLMUTILS_H_

#include "client.h"
#include "common/electron.h"
#include "common/lattice.h"



extern void severe(char const *fmt, ...);
extern void fatal(char const *fmt, ...);
extern void warning(char const *fmt, ...);
extern void response(char const *fmt, ...);
extern void message(char const *fmt, ...);
extern void print_lattice(BITMAP *onto, Lattice *l);
extern Electron * find_toplevel_vehicle(Electron *which);
extern char *cons_gets(char *caption,char *buffer, int max); // returns buffer
extern void my_generate_332_palette(PALETTE pal);
extern int list_inv(Electron *e); // lists the inventory of an electron,
                                  //returns -1 if it has no inventory
extern void print_electron(Electron *e);

extern Electron *find_with_id(Atom *in, unsigned int id);
extern Electron *find_with_type(Atom *in,unsigned int actor_type);
extern Electron *find_with_type(Electron *in,unsigned int actor_type, int recursive = FALSE);

Electron *find_ancestor(Electron *whose, unsigned int actor_id);

extern char const *random_name();

extern void print_sysinfo();

extern void print_to_stream(int stream, int color, char *string);

extern void cons_startline(int stream = -1);


extern void print_version();


extern int white;
extern int red;
extern int yellow;
extern int green;
extern int blue;
extern int lightblue;
extern int orange;
extern int cyan;

enum console_streams
{
   C_STREAM_STD,
   C_STREAM_WARN,
   C_STREAM_SEVERE,
   C_STREAM_SERVER,
   C_STREAM_LAST
};


#endif


