/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include "clmutils.h"
#include "renderer/renderer.h"
#include "common/version.h"

#define BUFSIZE 1024

Packet const *wait_packet(Plug *connection)
{
    Packet const *p;
    while(!(p = read_packet_static(connection)));
    if (p->err)
       fatal("Error in packet: %s", p->error);

    return p;
}


void message(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    #ifdef vsnprintf
     vsnprintf( buf, BUFSIZE, fmt, args );
    #else
     vsprintf( buf,  fmt, args );
    #endif
    va_end(args);

    ASSERT(screen);
    ASSERT(renderer);
    
//    renderer->cons_print(green, "\n");
    cons_startline();
    
    renderer->cons_print(green, buf);
    renderer->cons_print(green, "\n");
//    if (!playing)
//        renderer->draw_frame();



    fprintf(stderr,"message:%s\n",buf);
}

void response(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    #ifdef vsnprintf
     vsnprintf( buf, BUFSIZE, fmt, args );
    #else
     vsprintf( buf,  fmt, args );
    #endif
    va_end(args);
    
    fprintf(stderr,"response:%s\n",buf);

    if (screen && renderer)
    {
    
        cons_startline();
        renderer->cons_printf(orange,"%s\n", buf);
        
//!        if (!playing)
//           renderer->draw_frame();

    }
    else if (screen)
    {
       alert("System response", buf,NULL,"ok", NULL, 13,0);
    }
    else
    {
        allegro_message(" Warning:%s\nPress a key to continue.\n", buf);
        readkey();
    }


}


void warning(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    #ifdef vsnprintf
     vsnprintf( buf, BUFSIZE, fmt, args );
    #else
     vsprintf( buf,  fmt, args );
    #endif
    va_end(args);
    
    fprintf(stderr,"warning:%s\n",buf);
    if (screen && renderer)
    {
    
        cons_startline(C_STREAM_WARN);
//!        renderer->cons_printf(red,"%s\n", buf);
        print_to_stream(C_STREAM_WARN, red,buf);
        print_to_stream(C_STREAM_WARN, red,"\n");
        
//!        if (!playing)
//           renderer->draw_frame();

    }
    else if (screen)
    {
       alert("Warning :", buf,NULL,"ok", NULL, 13,0);
    }
    else
    {
        allegro_message(" Warning:%s\n", buf);
//        readkey();
    }
}

void severe(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    #ifdef vsnprintf
     vsnprintf( buf, BUFSIZE, fmt, args );
    #else
     vsprintf( buf,  fmt, args );
    #endif
    va_end(args);
    
    fprintf(stderr,"severe:%s\n",buf);
    if (screen && renderer)
    {

    
        renderer->cons_set_smooth_scroll(FALSE);
        renderer->cons_printf(makecol(255,100,255),"\n%s\n(press a key to continue)\n", buf);
        print_to_stream(C_STREAM_SEVERE, makecol(255,100,255),buf);
        print_to_stream(C_STREAM_SEVERE, makecol(255,100,255),"\n");
        renderer->draw_frame();
        readkey();
        
//        if (playing)
//            renderer->cons_set_smooth_scroll(TRUE);
    }
    else if (screen)
    {
         alert("Warning :", buf,NULL,"ok", NULL, 13,0);
    }
    else
    {
        allegro_message("Warning:%s\nPress a key to continue.", buf);
        readkey();
    }
}


void fatal(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    #ifdef vsnprintf
     vsnprintf( buf, BUFSIZE, fmt, args );
    #else
     vsprintf( buf,  fmt, args );
    #endif
    
    fprintf(stderr,"fatal:%s\n",buf);
    if (screen)
        set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Fatal: %s\n", buf);
    va_end(args);

    #ifdef DEBUGMODE
      abort();
    #else
      exit(1);
    #endif
}

void draw_map(Lattice *l, int fromx, int fromy, int tox, int toy)
{
    for (int i = fromx;i < tox; i++)
    {
        for (int j = fromy;j < toy; j++)
        {
            if (l->get(i, j))
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10,  makecol(255, 0, 0));
            }
            else
            {
                rectfill(screen, i * 10, j * 10, (i + 1) * 10, (j + 1) * 10, makecol(0, 255, 0));
            }
        }
    }
}


#define RECT_SIZE 10

void print_lattice(BITMAP *onto, Lattice *l)
{
    Atom *a;
    int nr_players;
    
    for (int y = 0; y < l->get_h(); y++)
    {
	for (int x = 0; x < l->get_w(); x++)
	{
	    a = l->get(x, y);
	    
	    if (a)
	    {
		// draw a rectangle

		rect(onto,
		     RECT_SIZE * x, RECT_SIZE * y,
		     RECT_SIZE * (x + 1), RECT_SIZE * (y + 1),
		     makecol(255, 255, 0));

		nr_players = a->get(LIST_PLAYER)->size();

		textprintf(onto, font,  
			   RECT_SIZE * x+2, RECT_SIZE * y+2,
			   makecol(255, 0, 0),
			   "%d",
			   nr_players);
	    }
	}
    }
}

/* finds the top level vehicle, or the Object itself if
   it's not in a vehicle
   used by the renderer to find out where to look/shoot at
 */
 
Electron * find_toplevel_vehicle(Electron *which)
{

  while(which->parent && which->parent->is_group(GROUP_VEHICLE))
      which = which->parent;

  return which;
}



char *cons_gets(char *caption,char *buffer, int max)
{
   ASSERT(renderer);
   int k = 0, a=0;
   int nr = 0;

   renderer->cons_set_smooth_scroll(FALSE);
   if (caption)
   {

      renderer->cons_printf(blue, "\n%s\n", caption);
      renderer->draw_frame();
   }
   while(((k = readkey()) >> 8)!= KEY_ENTER)
   {
      a = k & 0xFF;
      if ((k >>8) == KEY_BACKSPACE)
      {
         if (nr>0)
         {
            renderer->cons_backspace();
            nr--;
            renderer->draw_frame();
         }
      }
      else if (nr < (max - 1))
      {
         buffer[nr] = a;
         renderer->cons_printf(yellow,"%c", a);
         renderer->draw_frame();
         nr++;
      }
   
   }
   renderer->cons_set_smooth_scroll(TRUE);
   
   renderer->cons_printf(yellow,"\n", a);

   buffer[nr] = 0;

   return buffer;
}


/* generate_332_palette:
 *  Used when loading a truecolor image into an 8 bit bitmap, to generate
 *  a 3.3.2 RGB palette.
 */
void my_generate_332_palette(PALETTE pal)
{
   int c;

   for (c=0; c<256; c++) {
      pal[c].r = ((c>>5)&7) * 63/7;
      pal[c].g = ((c>>2)&7) * 63/7;
      pal[c].b = (c&3) * 63/3;
   }

   pal[0].r = 63;
   pal[0].g = 0;
   pal[0].b = 63;

   pal[227].r = pal[227].g = pal[227].b = 0;
}


void print_electron(Electron *e)
{
   message("%s - id=%d", e->type_name, e->actor_id);
}

int list_inv(Electron *e)
{
   ASSERT(renderer);
   ASSERT(e);
   Electron *i;
   List *inv = e->inv();

   if (!inv)
      return -1;
   

    for (inv->reset();(i = (Electron *)(inv->get()));inv->next())
        print_electron(i);


   return 0;
}

extern Electron *find_with_id(Atom *in, unsigned int id)
{
   List *l;
   Electron *e;
//   message("find with id");
   for (int i=0;i<LIST_LAST;i++)
   {
      l = in->get(i);

//      message("check List %d",i);
      for (l->reset();(e = (Electron *)(l->get()));l->next())
      {
//        message("check %s, %d",e->type_name,e->actor_id);
        if (e->actor_id == id)
        {
           return e;
        }
      }
   }

   return NULL;
}

Electron *find_with_type(Atom *in,unsigned int actor_type)
{
    Electron *ret;
    int list_type;

    if (actor_type < 0 || actor_type >= ACTOR_LAST)
    {
        warning("actor_type %d does not exist", actor_type);
        return NULL;
    }
    
    list_type = translate_actor_type[actor_type];
//    warning("finding (%d, %d), list_type = %d VEHICLE=%d", actor_type, id, list_type, LIST_VEHICLE);


    List *l = in->get(list_type);

    for (l->reset();
         (ret = (Electron *)(l->get()));
         l->next())
    {
//        warning(" checking %d", ret->actor_id);
        
        if (ret->actor_type == actor_type)
        {
//           warning("found it");
           return ret;
        }
    }
//    warning("not found it");
    return NULL;
}

Electron *find_with_type(Electron *in,unsigned int actor_type, int recursive = FALSE)
{
    Electron *ret;

    if (actor_type < 0 || actor_type >= ACTOR_LAST)
    {
        warning("actor_type %d does not exist", actor_type);
        return NULL;
    }
    



    List *l = in->inv();

    if (!l)
        return NULL;

    for (l->reset();
         (ret = (Electron *)(l->get()));
         l->next())
    {
//        warning(" checking %d", ret->actor_id);
        
        if (ret->actor_type == actor_type)
        {
//           warning("found it");
           return ret;
        }
        else if (recursive)
        {
            // if this electron isn't the one we're looking for, maybe it's
            // in it's inventory
            ret = find_with_type(ret, actor_type);

            if (ret)
               return ret;
        }
    }
//    warning("not found it");
    return NULL;
}

void print_sysinfo()
{
   char gfx_specs[180] = "";
   char gfx_specs2[180] = "";
   char gfx_specs3[180] = "";
//   char mouse_specs[80];
   char cpu_specs[180] = "";
   int c;

   #ifdef ALLEGRO_I386

      ssprintf(cpu_specs, 180, "CPU family: %d86", cpu_family);

      if (cpu_mmx)
	 sstrncat(cpu_specs, " / MMX", 180);

      if (cpu_3dnow)
	 sstrncat(cpu_specs, " / 3DNow!", 180);

   #else

      sstrncpy(cpu_specs, "Non-Intel CPU (cool, please tell us what you got this working on.)", 180);

   #endif


   ssprintf(gfx_specs, 180, "%dx%d , %ldk vram",
	   SCREEN_W, SCREEN_H, gfx_driver->vid_mem/1024);

   if (!gfx_driver->linear)
      ssprintf(gfx_specs+strlen(gfx_specs), 180 - strlen(gfx_specs),", %ldk banks, %ldk granularity",
	      gfx_driver->bank_size/1024, gfx_driver->bank_gran/1024);
   c = get_refresh_rate();
   if (c > 0)
      ssprintf(gfx_specs+strlen(gfx_specs), 180 - strlen(gfx_specs),", %d hz", c);

   switch (bitmap_color_depth(screen)) {

      case 8:
	 sstrncpy(gfx_specs2, "8 bit (256 color)",180);
	 break;

      case 15:
	 sstrncpy(gfx_specs2, "15 bit (32K HiColor)", 180);
	 break;

      case 16:
	 sstrncpy(gfx_specs2, "16 bit (64K HiColor)", 180);
	 break;

      case 24:
	 sstrncpy(gfx_specs2, "24 bit (16M TrueColor)", 180);
	 break;

      case 32:
	 sstrncpy(gfx_specs2, "32 bit (16M TrueColor)", 180);
	 break;

      default:
	 sstrncpy(gfx_specs2, "Unknown color depth!", 180);
	 break;
   }

   c = 0;



   show_mouse(screen);

   if (gfx_capabilities & GFX_HW_CURSOR) {
      if (c)
	 sstrncat(gfx_specs3, ", ", 180);
      sstrncat(gfx_specs3, "hardware mousecursor", 180);
      c++;
   }

   show_mouse(NULL);

   if (gfx_capabilities & ~(GFX_CAN_SCROLL | GFX_CAN_TRIPLE_BUFFER | GFX_HW_CURSOR)) {
      if (c)
	 sstrncat(gfx_specs3, ", ",180);
      sstrncat(gfx_specs3, "hardware acceleration", 180);
      c++;
   }

   if (!c)
      sstrncat(gfx_specs3, "showing pictures ;-)", 180);

   message("Video driver:");
   message(" Graphics driver: %s", gfx_driver->name);
   message(" Description: %s", gfx_driver->desc);
   message(" Specs: %s", gfx_specs);
   message(" Color depth: %s", gfx_specs2);
   message(" Capabilities: %s", gfx_specs3);
   message("");
   message("CPU:");
   message(" Specs: %s", cpu_specs);

}

void print_to_stream(int stream,int color, char *string)
{
   if (!renderer)
       return;
       
   int oldstream = renderer->cons_select_stream(stream);

   renderer->cons_print(color, string);

   
   renderer->cons_select_stream(oldstream);

}


void cons_startline(int stream)
{
   int oldstream = 0;
   
   if (stream >=0)
      oldstream = renderer->cons_select_stream(stream);

   ASSERT(renderer);
   
   if (renderer->cons_getcolumn())
       renderer->cons_print(renderer->cons_getcol(),"\n");

   if (stream >=0)
      renderer->cons_select_stream(oldstream);

}


void print_version()
{
   message("Version info:");
   message(" Game version : %s", GAME_VERSION_STRING);
   message(" Communication protocol version : %s", COMM_VERSION_STRING);
   message(" Release date : %s", RELEASE_DATE);
}


Electron *find_ancestor(Electron *whose, unsigned int actor_id)
{
   Electron *parent = whose->parent;


   while (parent)
   {
      if (parent->actor_id == actor_id)
          return parent;

      parent = parent->parent;
   }


   return NULL;
}


void common_assert(char const *file, int line)
{
      fatal("%s:%d: COMMON_ASSERT failed.\n",file, line);

}


char const *random_name()
{
  char *voornamen[] =
  {
    "John",
    "Karel",
    "Pieter",
    "Ian",
    "Mary",
    "Jane",
    "Petra",
    "Johanna"
  };

  char *achternamen[] =
  {
    "Kronttje",
    "Hamelson",
    "Kargelsof",
    "Kloepertijn",
    "van Bofferen",
    "Verstaf",
    "Smidth",
    "Vaen Haergelsteyn"
  };

  static char buffer[1024];
  char letter[3] = "A.";

  int r;


  r = rand() % (sizeof(voornamen)/sizeof(char *));

  sstrncpy(buffer, voornamen[r], 1024);
  sstrncat(buffer, " ", 180);

  r = rand() % 5;

  for (int i = 0; i < r; i++)
  {
    letter[0] = 65 + (rand() % 26);
    sstrncat(buffer, letter, 180);
  }

  sstrncat(buffer, " ", 180);

  r = rand() % (sizeof(achternamen)/sizeof(char *));

  sstrncat(buffer, achternamen[r], 180);


  return buffer;
}



int red,green,yellow,blue,lightblue, white , orange, cyan;

