/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#ifndef _CLIENT_H_
#define _CLIENT_H_

#include <allegro.h>
#include "net/plug.h"
#include "common/packet.h"
#include "common/utils.h"
#include "common/act_type.h"
#include "common/actors/system.h"
#include "common/lattice.h"
#include "common/actors/simple_room.h"
#include "common/version.h"
#include "common/vector.h"
#include "common/common.h"
#include "actors/cactors.h"
//#include <stdio.h>
//#include "signal.h"
#include "clutils.h"
#include "select.h"

/* globals*/
#define SERVERNAME_LEN 1024


extern char servername[];
extern int  port;
extern int selected_server;

extern int playing;
extern int colordepth;
extern int gfx_w, gfx_h, gfx_s_w;
extern int cmdline_startserver;

extern char * mapname;
extern int map_w, map_h;

extern unsigned int gtime;
extern unsigned int gtime10;
extern unsigned int tickcount;

extern int lighting_method,speedblur, nausea_level, filtering;

/* the player*/
extern Player *me;


extern List *garbagelist;
extern int collect_garbage;

extern Electron *toplevel_mover;// this is either the player itself, or his vehicle
extern unsigned int walk_frame; // frame until which the player is busy walking, and new
                       // walk commands should be ignored

extern int perspective_fact;
extern double fpscount, avfpscount, smoothfpscount;

extern char *cmd_gfxdata_name;
extern char *cmd_snddata_name;

extern int connection_valid;
extern int console_transparancy;

extern double cam_off_y, cam_off_x;
extern double requested_cam_off_x, requested_cam_off_y;

extern Player *dummy_player;


#define EPSILON 0.01  // doubles < EPSILON are considered to be 0



#define DEQUAL( a, b)  (((a) - (b) < EPSILON) && ((a) - (b) > -EPSILON))



extern double camheight;
extern double requested_camheight;

extern char * const default_prompt;

extern Selection *selection;

extern int block_arrow_keys;

extern int gfx_card;


extern int bugserver;


extern char *mapeditor_mapname;

extern int show_cursor;
extern int cursor_x, cursor_y;


#endif
