/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include <string.h>
#include <stdlib.h>
#include "choose.h"
#include "comm.h"
#include "cmdline.h"
#include "stser.h"

#define SERVERPORT_BUF_LEN 10
static char serverport_buf[SERVERPORT_BUF_LEN] = "5000";

int number_hosts = 0;
int ports[MAX_REMEMBERED_HOSTS];
char *hostnames[MAX_REMEMBERED_HOSTS];
int selected_server = 0;


static char *listbox_getter(int index, int *size)
{
    static char buffer[1024];
    if (index < 0)
    {
        *size = number_hosts;
        return NULL;
    }
    ssprintf(buffer, 1024, "%s : %d", hostnames[index], ports[index]);
    return buffer;
}

int d_serverlist_proc(int msg, DIALOG *d, int c);
int d_stser_proc(int msg, DIALOG *d, int c);
int d_updcons_proc(int msg, DIALOG *d, int c);

#define CDLG_SERVERNAME 2
#define CDLG_SERVERPORT 3
#define CDLG_SERVERLIST 4
#define CDLG_CONNECT         5
#define CDLG_EXIT     6
#define CDLG_STSER      9
static DIALOG choose_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)    (d2)  (dp)              (dp2) (dp3) */
   { d_box_proc,        0,    0,    300, 220,  255,  0,    0,    0,       0,        0,    NULL,             NULL, NULL  },
   { d_box_proc,        3,    3,    294, 214,  255,  0,    0,    0,       0,        0,    NULL,             NULL, NULL  },
   { d_edit_proc,      80,   10,   200,  48,   255,  0,    0,    0,    1024,        0,    servername,       NULL, NULL  },
   { d_edit_proc,      80,   25,   200,  48,   255,  0,    0,    0,     100,        0,    serverport_buf,   NULL, NULL  },
   { d_serverlist_proc,10,   40,   280,  100,  255,  0,    0,    0,       0,        0,    (void *)listbox_getter,   NULL, NULL  },
   { d_button_proc,    10,   190,  100,  15,   255,  0,    0,    D_EXIT,  0,        0,    const_cast<char *>("Connect"),             NULL, NULL  },
   { d_button_proc,    190,  190,  100,  15,   255,  0,    0,    D_EXIT,  0,        0,    const_cast<char *>("Exit program"),         NULL, NULL  },
   { d_text_proc,      10,   10,   54,  10,   255,   0,    0,    0,       0,        0,    const_cast<char *>("Server:"),         NULL, NULL  },
   { d_text_proc,      10,   25,   54,  10,   255,   0,    0,    0,       0,        0,    const_cast<char *>("Port:"),         NULL, NULL  },
   { d_stser_proc,     10,  160, 280,  15,   255,   0,    0,    0,       0,        0,     const_cast<char *>("Start server"),         NULL, NULL  },
   { d_updcons_proc,    0,    0,   0,  0,   0,   0,    0,    0,       0,        0,   0,         NULL, NULL  },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,        0,    NULL,             NULL, NULL  }
};

int addtolist(char *servername, int port)
{
   // check if it's already in the List
   for (int i=0;i<number_hosts;i++)
   {
      if (!strcmp(servername, hostnames[i]) && port == ports[i])
         return i;
   }

   if (number_hosts < MAX_REMEMBERED_HOSTS)
   {
      hostnames[number_hosts] = sstrdup(servername);
      ports[number_hosts] = port;
      number_hosts++;
   }
   return number_hosts - 1;
}

int d_serverlist_proc(int msg, DIALOG *d, int c)
{
   int ret = d_list_proc(msg,d,c);

   if (msg == MSG_CLICK || msg == MSG_KEY || msg == MSG_CHAR || msg == MSG_WHEEL)
   {
      if (number_hosts)
      {
         ssprintf(servername, SERVERNAME_LEN,"%s", hostnames[d->d1]);
         ssprintf(serverport_buf, SERVERPORT_BUF_LEN,"%d",ports[d->d1]);
      }
      choose_dlg[CDLG_SERVERNAME].flags |= D_DIRTY;
      choose_dlg[CDLG_SERVERPORT].flags |= D_DIRTY;

      if (strcmp(servername, "localhost"))
      {
          if (!( choose_dlg[CDLG_STSER].flags & D_HIDDEN))
             ret = D_REDRAW;
             
          choose_dlg[CDLG_STSER].flags |= D_HIDDEN;
      }
      else
      {
          choose_dlg[CDLG_STSER].flags |= D_DIRTY;
          choose_dlg[CDLG_STSER].flags &= ~D_HIDDEN;
      }
   }

   return ret;
}


int d_updcons_proc(int msg, DIALOG *d, int c)
{
   if (msg != MSG_DRAW && msg != MSG_IDLE)
       return d_box_proc(msg,d,c); // just used a s a suitable 'NO-OP Object'

   if (msg == MSG_IDLE)
   {
      if(ser_stdin_stdout())
         return D_REDRAW;
   }

   return D_O_K;
}


int d_stser_proc(int msg, DIALOG *d, int c)
{
   int ret = d_button_proc(msg,d,c);

   if (msg == MSG_CLICK || msg == MSG_KEY)
   {
      SEND_MESSAGE(d,MSG_DRAW, c);
      while(mouse_b);
      d->flags &= ~D_SELECTED;
      startserver(servername, port);

      return D_REDRAW;
   }

   return ret;
}


int choose_host()
{
    int ret;

    do
    {
         set_dialog_color(choose_dlg, makecol(0,0,150), makecol(255,200,0));
         centre_dialog(choose_dlg);
         choose_dlg[CDLG_SERVERLIST].d1 = selected_server;

         if (strcmp(servername, "localhost"))
         {
             choose_dlg[CDLG_STSER].flags |= D_HIDDEN;
         }
         else
         {
             if (cmdline_startserver && !server_runs())
             {
                 startserver(servername, port);

                 rest(500);
             }
         }
         
         if (!nochoose)
         {
            SEND_MESSAGE(choose_dlg+CDLG_SERVERLIST,MSG_KEY , 0);
            show_mouse(screen);
            ret = popup_dialog(choose_dlg, CDLG_CONNECT);
            show_mouse(NULL);
     
            port = atoi(serverport_buf);
     
     
            if (ret == CDLG_EXIT || ret == -1)
            {
               stopserver();
               return FALSE;
            }

         }
         selected_server = addtolist(servername, port);
         
         nochoose = FALSE;

    } while (setup_connection(servername, port) != COMM_GOT_CONNECTION);
    

    return TRUE;
}





