/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       ctank.cc
 *
 *       client version of the Tank
 */

#include "client/client.h"
#include "ctank.h"
#include "client/extradat.h"
#include "client/srender/srend.h"


CTank::CTank()
{
   engine = NULL;
   set(-1);
}

void CTank::set(int _actor_id)
{
   
   Tank::set(_actor_id);
   state = STATE_STANDING;



   if (!engine)
   {
      engine  = srenderer->get_voice(this);

      ASSERT(engine);
      
      engine->set_sample(Sound_renderer::SAMP_ENGINE);
      engine->set_volume(30);
      engine->set_speed(.7);
      engine->start();

   }
   
}

void CTank::clear()
{
   engine->stop();
   if (engine)
      srenderer->free_voice(engine);



   engine = NULL;

   Tank::clear();
}

int CTank::get_state()
{
   return state;
}


void CTank::change_state(int argument = -1)
{
   argument = 0; // suppres compiler complaining about unused params


   ASSERT(extra_data);
   
   Display_data *d = (Display_data *)extra_data;

   if (!(d->is_active))
   {
//      warning("set_state standing");
      if (state == STATE_DRIVING)
      {
          engine->set_volume(30, 100);
          engine->set_speed(.7, 100);
      }
      state = STATE_STANDING;

   }
   else
   {
//      warning("set_state walking");
      if (state == STATE_STANDING)
      {
          engine->set_volume(128, 100);
          engine->set_speed(1, 100);
      }


      state = STATE_DRIVING;

   }

}


