/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        splayer.cc
 *
 *        server version of Player
 */

#include "client/client.h"
#include "client/extradat.h"
#include "client/srender/srend.h"
#include "cplayer.h"


CPlayer::CPlayer()
{
   footsteps = NULL;
   set(-1);
}

void CPlayer::set(int _actor_id)
{
   Player::set(_actor_id);
   state = STATE_STANDING;

   if (!footsteps)
   {
      footsteps = srenderer->get_voice(this);

      ASSERT(footsteps);
      
      footsteps->set_sample(Sound_renderer::SAMP_FOOTSTEP);

      footsteps->set_volume(128);
   }
}

int CPlayer::get_state()
{
   return state;
}


void CPlayer::change_state(int argument = -1)
{
   argument = 0; // suppres compiler complaining about unused params

   ASSERT(extra_data);
   
   Display_data *d = (Display_data *)extra_data;

   if (DEQUAL(d->xe,d->xc) && DEQUAL(d->ye,d->yc))
   {
//      warning("set_state standing");
      if (state == STATE_WALKING)
         footsteps->stop(5);

      state = STATE_STANDING;
   }
   else
   {
//      warning("set_state walking");
      if (state == STATE_STANDING)
         footsteps->start();

      state = STATE_WALKING;
   }

}

void CPlayer::clear()
{
   if (footsteps)
      srenderer->free_voice(footsteps);

   footsteps = NULL;

   Player::clear();
}

