/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */
#include "client/client.h"

// given an actor type and an actor id, create the appropriate electron
Electron *get_electron_from_type(int type, int id)
{
    Electron *e = 0;
    
    switch(type)
    {
        case ACTOR_SYSTEM:
            e = new_actor<CSystem>(0);   // system constructor doesn't get an actor_id
            break;
        case ACTOR_SIMPLE_ROOM:
            e = new_actor<CSimple_room>(id);
            break;
        case ACTOR_PLAYER:
            e = new_actor<CPlayer>(id);
            break;
        case ACTOR_LIGHTCYCLE:
            e = new_actor<CLightcycle>(id);
            break;
        case ACTOR_KEY:
            e = new_actor<CKey>(id);
            break;
        case ACTOR_CYCLEWALL:
            e = new_actor<CCyclewall>(id);
            break;
        case ACTOR_TANK:
            e = new_actor<CTank>(id);
            break;
        case ACTOR_GRENADE:
            e = new_actor<CGrenade>(id);
            break;
        case ACTOR_EXPLOSION:
            e = new_actor<CExplosion>(id);
            break;
        case ACTOR_LAUNCHER:
            e = new_actor<Clauncher>(id);
            break;
        case ACTOR_BLUE_BALL:
            e = new_actor<Cblue_ball>(id);
            break;
        case ACTOR_YELLOW_BALL:
            e = new_actor<Cyellow_ball>(id);
            break;
        case ACTOR_RED_BALL:
            e = new_actor<Cred_ball>(id);
            break;
        case ACTOR_HOVER:
            e = new_actor<Chover>(id);
            break;
        case ACTOR_LASERBEAM:
            e = new_actor<Claserbeam>(id);
            break;
        case ACTOR_MINE:
            e = new_actor<Cmine>(id);
            break;
        case ACTOR_DOOR:
            e = new_actor<Cdoor>(id);
            break;
        case ACTOR_WATER:
            e = new_actor<Cwater>(id);
            break;
        case ACTOR_DOORKEY:
            e = new_actor<Cdoorkey>(id);
            break;
        case ACTOR_AMBULANCE:
            e = new_actor<Cambulance>(id);
            break;
        case ACTOR_MEDICAL_PAD:
            e = new_actor<Cmedical_pad>(id);
            break;
        case ACTOR_AMMO_PAD:
            e = new_actor<Cammo_pad>(id);
            break;
        case ACTOR_REPAIR_PAD:
            e = new_actor<Crepair_pad>(id);
            break;
        case ACTOR_FIETSENMAKER:
            e = new_actor<Cfietsenmaker>(id);
            break;
        case ACTOR_WEAPONSMITH:
            e = new_actor<Cweaponsmith>(id);
            break;
        case ACTOR_VOTE_ROOM:
            e = new_actor<Cvote_room>(id);
            break;
        case ACTOR_VOTEMACHINE:
            e = new_actor<Cvotemachine>(id);
            break;
        case ACTOR_WEAPONMACHINE:
            e = new_actor<Cweaponmachine>(id);
            break;
        case ACTOR_SAFE_ROOM:
            e = new_actor<Csafe_room>(id);
            break;
// END_OF_CASE
        default:
            warning("Illegal or unknown actor type %d", type);
            break;
    }
    return e;
}

