/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        splayer.cc
 *
 *        server version of Player
 */

#include "client/client.h"
#include "client/extradat.h"
#include "cambulance.h"
#include "client/srender/srend.h"


Cambulance::Cambulance()
{
   siren = NULL;
   set(-1);
}

void Cambulance::set(int _actor_id)
{
   
   Ambulance::set(_actor_id);
   state = STATE_STANDING;



   if (!siren)
   {
      siren  = srenderer->get_voice(this);

      ASSERT(siren);
      
      siren->set_sample(Sound_renderer::SAMP_BELL);

   }
   
}

void Cambulance::clear()
{
   if (siren)
      srenderer->free_voice(siren);
      
   siren = NULL;

   Ambulance::clear();
}

int Cambulance::get_state()
{
   return state;
}


void Cambulance::change_state(int argument = -1)
{
   argument = 0; // suppres compiler complaining about unused params

   ASSERT(extra_data);
   
   Display_data *d = (Display_data *)extra_data;

   if (!(d->is_active))
   {
//      warning("set_state standing");
      if (state == STATE_DRIVING)
      {
         siren->set_volume(0, 50);
         siren->stop(50);
      }
      state = STATE_STANDING;

   }
   else
   {
//      warning("set_state walking");
      if (state == STATE_STANDING)
      {
          siren->start();
          siren->set_volume(255, 100);
      }


      state = STATE_DRIVING;

   }

}

