/*
main.c

Copyright 1999,2004 Denis EGEA

 This file is part of Babal.

    Babal is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Babal; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#define NUM_FRAMES 35

#include <stdio.h>
#include <string.h>

#include <allegro.h>
#include <aldumb.h>

#include "3d_lib.h"
#include "landsc.h"
#include "babal.h"
#include "res.h"
#include "config.h"


//#define DEBUG
BITMAP* v_screen;
BITMAP* temp;
BITMAP* fond;
DATAFILE *game_data;
COMPILED_SPRITE *ball_sprite[NUM_FRAMES];
AL_DUH_PLAYER *duh_player;


float frame;

enum j_states{not_jumping,jumping_up,falling};

int jump_state=not_jumping;
int ball_y=0;
float y_speed=jump_high;
float jump_pos=-10;
extern char* map;
extern int level_size;

volatile int num_of_frames;
volatile int frame_rate;

volatile int tick=0;

RGB c;

void count_frames(void)
	{
	 frame_rate=num_of_frames;
	 num_of_frames=0;
	}

inline void inc_tick()
	{
	 tick++;
	}


char *int2str(int i)
	{
     char *s=(char *)malloc(33);
     itoa(i,s,10);
     return s;
	}

void progress(int pos)
	{
	static int n=0;
	n++;
	textout_centre(screen,font,"Please wait",X/2,Y/2-15,255);
	rect(screen,X/2-130,Y/2-5,X/2+130,Y/2+5,255);
	rectfill(screen,X/2-130,Y/2-5,X/2-130+n,Y/2+5,255);
	}

void init_palette()
    {
    color_map=(COLOR_MAP*)malloc(sizeof(COLOR_MAP));
	create_light_table(color_map,(RGB*) game_data[game_pal].dat,0,0,0,&progress);
    fond=(BITMAP *)game_data[bgd].dat;
    }

void stretch_ball()
	{
	int n;
	BITMAP *temp;
   	int w,h;

	for (n=0;n<NUM_FRAMES;n++)
	 	{
		 w=((BITMAP *)(game_data[n].dat))->w;
         h=((BITMAP *)(game_data[n].dat))->h;
		 temp=create_bitmap(w,h);
		 clear(temp);

		 #ifdef SVGA
		 draw_sprite(temp,(BITMAP *)game_data[n].dat,0,0);
		 #else
         stretch_blit(game_data[n].dat,temp,0,0,w,h,w/4,h/2,w/2,h/2);
         #endif
		 ball_sprite[n]=get_compiled_sprite(temp,FALSE);
		 destroy_bitmap(temp);
		}
	 }

void load_level(char* lev_file)  // charge une image en temps que niveau
	{
	BITMAP* temp;
	PALETTE bidon;
	int x,y;
	long n=0;

	temp=load_bitmap(lev_file,bidon);
	if (!temp)
		{
	    set_gfx_mode(GFX_TEXT,640,480,0,0);
	    allegro_message("%s is not a valid level file\n",lev_file);
	    exit(0);
	    }

    map=(char *)malloc(8*temp->h);

	for (y=0;y<temp->h;y++)
		for (x=0;x<8;x++)
			{
			*(map+n)=(char)(temp->line[y])[x];
			n++;
			}
	level_size=temp->h;
	destroy_bitmap(temp);
    }

void move_ball()
	{
	int n;
    for (n=0;n<=tick;n++)
		{
		 tick--;
		 zpos=zpos + ftofix(speed);

		 if (!jump_state)
           lspeed-=(0.2*lspeed);
         else
           lspeed-=(0.1*lspeed);

		 xpos+=ftofix(lspeed);

		 frame+=4*speed;
 	     if (frame<0)
		 	frame=NUM_FRAMES-1;
	     if (frame>NUM_FRAMES-1)
			 frame=0.0;
		 switch(jump_state)
		  {
		   case jumping_up:
				y_speed-=0.3;
				if (y_speed<=0)
	  				jump_state=falling;
				ball_y+=(int)y_speed;
				break;

           case falling:
                y_speed+=0.3;
				ball_y-=(int)y_speed;
				
                if (ball_y<=0)
				  {
				   y_speed=jump_high;
 				   jump_state=not_jumping;
				  }
				break;

          }
		   }
	}

void general_fade_out(int zik)
	{
    PALETTE temp;
    int c;
    int n;
    float volume=1.0;
    
    get_palette(temp);
    for (n=0;n<64;n++)
    	{
        for (c=0;c<256;c++)
           {
            if (temp[c].r>0) temp[c].r--;
        	if (temp[c].g>0) temp[c].g--;
        	if (temp[c].b>0) temp[c].b--;
           }
     set_palette(temp);
     volume-=(0.015);
       if (zik) al_duh_set_volume(duh_player, volume);
        al_poll_duh(duh_player);
        }
}  
    
 
 void wongame()
    {
         
    int x,y;
     int i;
     BITMAP* checker_screen=create_bitmap(X,Y);
     map=&thanks_for_playing[0][0];
     zpos=ftofix(150);
     
     set_palette((RGB *)game_data[win_pal].dat);
     
     init_win();
     al_stop_duh(duh_player);
     duh_player=al_start_duh((DUH *)game_data[end].dat,2,0,1,8192,22050);
     
     
     
     while ((!key[KEY_ESC]) && fixtof(zpos)>-40.0)
       {
       al_poll_duh(duh_player);
       render_win(checker_screen);  
       blit((BITMAP *)game_data[win].dat,checker_screen,0,0,98,0,446,152);
       blit(checker_screen,screen,0,0,0,0,X,Y);
       }  

textout_centre(screen,font,"Thank you for playing Babal!",320,300,180);


for (i=0;i<100;i++)
{
    rest(10);
    al_poll_duh(duh_player);
}
textout_centre(screen,font,"A Game By Denis Egea",320,350,180);
for (i=0;i<100;i++)
{
    rest(10);
    al_poll_duh(duh_player);
}

textout_centre(screen,font,"Press esc to exit",320,400,180);
while(!key[KEY_ESC])
{
 al_poll_duh(duh_player);
}
    general_fade_out(1);
    
    
}
   
int main(int argc,char *argv[])
	{
	int zik;
    int won=0;
        
    int n;
    char *lev_f_name=(char *)malloc(20);


	frame=0;

	allegro_init();
    atexit(&dumb_exit);
    dumb_register_dat_xm(DUMB_DAT_XM);
    dumb_resampling_quality=DUMB_RQ_LINEAR;
    
    install_keyboard();
    install_timer();

    // ligne de commande
	zik=1;
	for (n=0;n<argc;n++)
		if (!stricmp(argv[n],"-nozik")) zik=0;
	for (n=0;n<argc;n++)
		if (!strncmp(argv[n],"-l",2))
		    {
		     strcpy(lev_f_name,argv[n]+2);
		     load_level(lev_f_name);
		    }
		else
		    {
		    map=&original_landscape[0][0];
            level_size=1033;
		    }


 	set_color_depth(8);
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,X,Y,0,0))
          {
		   set_gfx_mode(GFX_TEXT,640,480,0,0);
		   allegro_message(allegro_error);
           exit(1);
           }


   if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0)
    {
     zik=0;
    }
	
 
    install_int(count_frames,1000);
	install_int_ex(inc_tick,BPS_TO_TIMER(70));


    if (!(game_data = load_datafile("babal.dat")))
	  	{
         allegro_message("Fatal error : can't load babal.dat");
         readkey();
         exit(0);
		}
    v_screen=create_bitmap(X,Y);

    clear(screen);
    set_palette((RGB *)game_data[title_pal].dat);
 
  	if (zik) 
    {
     duh_player=al_start_duh((DUH *)game_data[jingle].dat,2,0,1,4096,22050);
     }
    blit((BITMAP *)game_data[title].dat,screen,0,0,0,0,640,480);

    text_mode(-1);
	textout_centre(screen,font,"A game by Denis Egea",X/2,Y/2+200,97);
    textout_centre(screen,font,"From the original game by U-foot",X/2,Y/2+220,97);
    
while(keypressed()==FALSE)
{
   al_poll_duh(duh_player);
}
                  
    
    general_fade_out(zik);
    al_stop_duh(duh_player);
  
	clear(v_screen);

    init_palette();
    init_world(level_size);
  
    if (zik) 
    {
    duh_player=al_start_duh((DUH *)game_data[level1].dat,2,0,1,8192,22050);
     }

    stretch_ball();
	clear(screen);
    set_palette((RGB *)game_data[game_pal].dat);
    c=(RGB){0,0,0};
    set_color(0,&c);
    blit(fond,v_screen,0,0,0,BACK_OFFSET,X,Y-BACK_OFFSET);
    text_mode(0);

    //zpos=itofix(2050); // that's to test if the end of level detection works
	while(!key[KEY_ESC])
	  {
        
       al_poll_duh(duh_player);
       
       if ( (key[KEY_SPACE]) && (jump_state==not_jumping))
		 {
		  jump_state=jumping_up;
		  jump_pos=zpos;
		 }

       update_world();
       blit(fond,v_screen,0,0,0,BACK_OFFSET,X,Y);
       move_ball();
       process_input();
       render(v_screen);
       draw_map(v_screen);
       #ifdef DEBUG
       textprintf(v_screen,font,1,1,255,"fps: %3i frame : %2.0f %i %i %i %i",frame_rate,frame,xmap,ymap,tick, sizeof(map));
       #endif
       draw_compiled_sprite(v_screen,ball_sprite[(int)frame+babal000], HALF_X-41, Y-90-ball_y);
       test_col(v_screen,duh_player);
       blit(v_screen,screen,0,0,0,0,X,Y);
       num_of_frames++;
       vsync();
       if (ymap>level_size-2)
       {  won=1;
          break;
       }
}
	temp=create_bitmap(1024,512); // w et h doivent etre des puissances de 2 pour glassbrk
    clear(temp);
    blit(v_screen,temp,0,0,0,0,X,Y);

    if (won!=0)
    {
    screen_fall(v_screen,zik,duh_player);   
    wongame();
    }
    else
    {
    glassbrk(v_screen,temp,(BITMAP*)game_data[game_over].dat,zik, duh_player);
    }
    al_stop_duh(duh_player);
    
	
    destroy_bitmap(v_screen);
    destroy_bitmap(temp);
    set_gfx_mode(GFX_TEXT,640,480,0,0);
   	exit(0);
   }
   END_OF_MAIN();
