#include <stdio.h>
#include <conio.h>
#define alleg_mouse_unused
#define alleg_joystick_unused
#define alleg_flic_unused
#define alleg_gui_unused

#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>
#include <sys/farptr.h>
#include <sys/segments.h>

#include <allegro.h>


typedef struct VESA_INFO 
{ 
   unsigned char  VESASignature[4]     __attribute__ ((packed));
   unsigned short VESAVersion          __attribute__ ((packed));
   unsigned long  OEMStringPtr         __attribute__ ((packed));
   unsigned char  Capabilities[4]      __attribute__ ((packed));
   unsigned long  VideoModePtr         __attribute__ ((packed)); 
   unsigned short TotalMemory          __attribute__ ((packed)); 
   unsigned short OemSoftwareRev       __attribute__ ((packed)); 
   unsigned long  OemVendorNamePtr     __attribute__ ((packed)); 
   unsigned long  OemProductNamePtr    __attribute__ ((packed)); 
   unsigned long  OemProductRevPtr     __attribute__ ((packed)); 
   unsigned char  Reserved[222]        __attribute__ ((packed)); 
   unsigned char  OemData[256]         __attribute__ ((packed)); 
} VESA_INFO;

#define MASK_LINEAR(addr)     (addr & 0x000FFFFF)
#define RM_TO_LINEAR(addr)    (((addr & 0xFFFF0000) >> 12) + (addr & 0xFFFF))
#define RM_OFFSET(addr)       (addr & 0xF)
#define RM_SEGMENT(addr)      ((addr >> 4) & 0xFFFF)

VESA_INFO vesa_info;
char oem_string[256];
char oemvendor_string[256];
char oemproductname_string[256];
char oemproductrev_string[256];

unsigned short mode[1024];
int modes;

void get_string(char *s, unsigned long addr)
{
   if (addr) {
      addr = RM_TO_LINEAR(addr);
      while (_farnspeekb(addr) != 0)
	 *(s++) = _farnspeekb(addr++);
      *s = 0;
   }
   else
      strcpy(s, "(null)");
}


int get_vesa_info()
{
   __dpmi_regs r;
   unsigned long mode_ptr;
   int c;

   for (c=0; c<(int)sizeof(VESA_INFO); c++)
      _farpokeb(_dos_ds, MASK_LINEAR(__tb)+c, 0);

   dosmemput("VBE2", 4, MASK_LINEAR(__tb));

   r.x.ax = 0x4F00;
   r.x.di = RM_OFFSET(__tb);
   r.x.es = RM_SEGMENT(__tb);
   __dpmi_int(0x10, &r);
   if (r.h.ah) {
      fprintf(stderr, "Int 0x10, ax=0x4F00 failed! ax=0x%02X\n", r.x.ax);
      return -1;
   }

   dosmemget(MASK_LINEAR(__tb), sizeof(VESA_INFO), &vesa_info);

   if (strncmp(vesa_info.VESASignature, "VESA", 4) != 0) {
      fprintf(stderr, "Bad VESA signature! (%4.4s)\n", vesa_info.VESASignature);
      return -1;
   }

   _farsetsel(_dos_ds);

   modes = 0;
   mode_ptr = RM_TO_LINEAR(vesa_info.VideoModePtr);
   mode[modes] = _farnspeekw(mode_ptr);

   while (mode[modes] != 0xFFFF) {
      modes++;
      mode_ptr += 2;
      mode[modes] = _farnspeekw(mode_ptr);
   }

   get_string(oem_string, vesa_info.OEMStringPtr);
   get_string(oemvendor_string, vesa_info.OemVendorNamePtr);
   get_string(oemproductname_string, vesa_info.OemProductNamePtr);
   get_string(oemproductrev_string, vesa_info.OemProductRevPtr);

   printf("\nVesa information :\n");

   printf("\tVESA Version:\t\t%d.%d\n", vesa_info.VESAVersion>>8, vesa_info.VESAVersion&0xFF);
   printf("\tOEM String :\t\t%s\n", oem_string);
   printf("\tTotal Memory:\t\t%dK\n", vesa_info.TotalMemory*64);
   printf("\tOem Software Revision:\t%d.%d\n", vesa_info.OemSoftwareRev>>8, vesa_info.OemSoftwareRev&0xFF);
   printf("\tOem Vendor Name:\t%s\n", oemvendor_string);
   printf("\tOem Product Name:\t%s\n", oemproductname_string);
   printf("\tOem Product Revision:\t%s\n", oemproductrev_string);

      printf("\n");


   return 0;
}


void disp_cfg()
  {


  set_gfx_mode(GFX_TEXT,640,480,0,0);
  clrscr();
  textattr((4<<4)+14);
  cprintf("                            Babal pre-version 0.1                              ");
  textattr(7);
  printf("This program uses %s.\n",allegro_id);
  check_cpu();
  printf("\nComputer information :\n");
  printf("\tRunning on %s ",cpu_vendor);

  if (cpu_cpuid)
     {
     switch (cpu_family)
            {
            case 3:
                 switch (cpu_model)
                        {
                        case 0:
                             printf("386 DX");
                             break;
                        case 2:
                             printf("386 SX");
                             break;
                        case 4:
                             printf("386 SL");
                             break;
                        case 15:
                             printf("unknown 386");
                             break;
                        }
                        break;
            case 4:
                 switch (cpu_model)
                       {
                       case 0:
                       case 1:
                            printf ("486 DX");
                            break;
                       case 2:
                            printf("486 SX w/ 487 or 486 DX");
                            break;
                       case 3:
                            printf("486 SX");
                            break;
                       case 4:
                            printf("486 SL");
                            break;
                       case 5:
                            printf("486 SX2");
                            break;
                       case 7:
                            printf("486 DX2 write-back enhanced");
                            break;
                       case 8:
                            printf("486 DX4 or DX4 overdrive");
                            break;
                       case 14:
                            printf("Cyrix 486");
                            break;
                       case 15:
                            printf("Unknown 486");
                            break;
                       }
                 break;
                 case 5:
                 switch (cpu_model)
                       {
                       case 1:
                            printf("Pentium (510\66, 567\66)");
                            break;
                       case 2:
                            printf("Pentium (P54C)");
                            break;
                       case 3:
                            printf("Pentium Overdrive");
                            break;
                       case 5:
                            printf("Pentium Overdrive for I486 DX4");
                            break;
                       case 14:
                            printf("Cyrix 586");
                            break;
                       case 15:
                            printf("Unknown 586");
                            break;
                       }
                       if (cpu_mmx)
                          printf(" MMX");
                       break;
                 case 6:
                       if (cpu_mmx)
                          printf("Pentium II");
                       else
                          printf("Pentium Pro");
                default:
                        printf("Better than PII");
                        break;
           }
      }
else
      printf("Unknown Cpu");

printf(", under ");
switch (os_type)
       {
       case OSTYPE_UNKNOWN:
            printf("MSDOS (or unknown)");
            break;
       case OSTYPE_WIN3:
            printf("Windows 3.1 (or earlier)");
            break;
       case OSTYPE_WIN95:
            printf("Windows 95");
            break;
       case OSTYPE_WINNT:
            printf ("Windows NT");
            break;
       case OSTYPE_OS2:
            printf("OS/2");
            break;
       case OSTYPE_WARP:
            printf("OS/2 Warp 3");
            break;
       case OSTYPE_DOSEMU:
            printf("Linux DOSEMU");
            break;
       case OSTYPE_OPENDOS:
            printf("Caldera OpenDOS");
            break;
       default:
            printf("an unknown OS !!!");
            break;
       }
printf("\n");
get_vesa_info();

install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
printf("Sound card information :\n");
printf("\t%s\n",digi_driver->desc);
printf("\n");
remove_sound();
}
