/*
3dlib.c

Copyright 1999,2004 Denis EGEA

 This file is part of Babal.

    Babal is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Babal; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

#include <allegro.h>
#include <aldumb.h>

#include "main.h"
#include "res.h"
#include "babal.h"

//#define DEBUG


#ifdef DEBUG
FILE* debug;
int collision_test=0;
#endif

void draw_map(BITMAP *bmp);

typedef struct RECT {
   int x, y, w, h;
} RECT;

RECT floor_rect[8*14];

int rect_count=0;

int level_size;

int xmap,ymap;
	 
const int render_mode=POLYTYPE_ATEX_LIT;
MATRIX camera,roller;


float speed=0;
float lspeed=0;
int viewport_w=X;
int viewport_h=Y;
fixed fov;
fixed aspect;
fixed xpos;
fixed ypos;
fixed zpos;
fixed heading;
fixed pitch;
fixed roll;

 	  
int x, y, w, h;
fixed xfront, yfront, zfront;
fixed xup, yup, zup;

char *map;

enum light_map_types{linear,exponential};
int light_type=linear;// attention !!!! "Exponential" ne fonctionne pas !!!!


void draw_square(BITMAP *bmp, MATRIX *camera, int x, int z,BITMAP* texture_map, int light_distance)
	{
     V3D v[4];

     int c=0;
     z=(int)(z-0.01);


    v[0].x = itofix(x-8);
   	v[0].y = 0;
   	v[0].z = itofix(z);
   	v[0].u = 0;
   	v[0].v = 0;

    v[1].x = itofix(x-6);
    v[1].y = 0;
   	v[1].z = itofix(z);
   	v[1].u = itofix(texture_map->w);
   	v[1].v = 0;

   	v[2].x = itofix(x-6);
   	v[2].y = 0;
   	v[2].z = itofix(z+2);
   	v[2].u = itofix(texture_map->w);
   	v[2].v = itofix(texture_map->h);

   	v[3].x = itofix(x-8);
   	v[3].y = 0;
   	v[3].z = itofix(z+2);
   	v[3].u = 0;
   	v[3].v = itofix(texture_map->h);


   	for (c=0; c<4; c++)
      		{
             apply_matrix(camera, v[c].x, v[c].y, v[c].z, &v[c].x, &v[c].y, &v[c].z);
            /*
            #ifdef DEBUG
              
            if ((fixtof(v[c].z)>50) || (fixtof(v[c].z)<0.1))
              {
              fprintf(debug,"* Vtx qui merde : %i z=%2.1f xmap=%i ymap=%i\n",rect_count,fixtof(v[c].z),x>>1,z>>1);
              }
           else
              {
             	fprintf(debug,"Vtx normal : %i z=%2.1f xmap=%i ymap=%i\n",rect_count,fixtof(v[c].z),x>>1,z>>1);
              }
           #endif
           */

           persp_project(v[c].x, v[c].y, v[c].z, &v[c].x, &v[c].y);
           switch (light_type)
             {
             case linear:
              v[c].c =light_distance - fixtoi(v[c].z <<3);
              break;
              case exponential:     // Attention, il merde !!!!
              v[c].c = (int)(sqrt(65536-(fixtof(v[c].z <<3)*fixtof(v[c].z <<3))));
              break;
              }
            }

        quad3d(bmp, render_mode, texture_map, &v[0], &v[1], &v[2], &v[3]);

        floor_rect[rect_count].x=MIN(fixtoi(v[0].x),fixtoi(v[3].x));
        floor_rect[rect_count].y=fixtoi(v[3].y)-1;
        floor_rect[rect_count].w=(MAX(fixtoi(v[2].x),fixtoi(v[1].x))-floor_rect[rect_count].x);
        floor_rect[rect_count].h=(fixtoi(v[0].y)-fixtoi(v[3].y))+3;
       

        rect_count++;

        }

void init_world(int levelSize)
	{
     #ifdef DEBUG
     debug=fopen("3d_debug.txt","w");
     #endif
     level_size=levelSize;
     fov=itofix(48);
     aspect=itofix(1);
	 xpos=itofix(1);
     ypos=itofix(-2);
     zpos=itofix(0);
     heading=ftofix(0);
     pitch=itofix(0);
     roll=itofix(0);


     xfront = ftofix(sin(heading) * cos(pitch));
     yfront = ftofix(sin(pitch));
     zfront = ftofix(cos(heading) * cos(pitch));

   	 get_vector_rotation_matrix(&roller, xfront, yfront, zfront, roll);
	 apply_matrix(&roller, itofix(0), itofix(-1), itofix(0), &xup, &yup, &zup);


	 set_projection_viewport(0, 0, X, Y);
   }



void init_win()
{
     fov=itofix(48);
     aspect=itofix(1);
	 xpos=itofix(1);
     ypos=itofix(-20);
     heading=itofix(0);
     pitch=ftofix(25);
     roll=itofix(0);

     xfront = fixmul(fixsin(heading),fixcos(pitch));
     yfront = fixsin(pitch);
     zfront = fixmul(fixcos(heading),fixcos(pitch));

   	 get_vector_rotation_matrix(&roller, xfront, yfront, zfront, roll);
	 apply_matrix(&roller, itofix(0), itofix(-1), itofix(0), &xup, &yup, &zup);
     xmap=(int)(fixtof(xpos)+8)>>1;
	 

	 set_projection_viewport(0, 0, X, Y);
      
      
 }
 

void render_win(BITMAP * v_screen)
{      
     
     
     zpos-=ftofix(0.02);
     
     ymap=2+((int)(fixtof(zpos)+1.14)>>1);
     
     clear(v_screen);
  
     get_camera_matrix(&camera,
		       xpos, ypos, zpos,
		       xfront, yfront, zfront,
		       xup, yup, zup,
		       fov,
		       aspect);
      
    rect_count=0;

    for (y=ymap-1;y<ymap+25;y++)
		{
		 for (x=0; x<8; x++)
                if ((*(map+(y<<3)+x)) && y>0 && y <level_size)
                  draw_square(v_screen, &camera, x<<1, y<<1,(BITMAP *)game_data[texture].dat,400);
        }
        }





void update_world()
	{
     xmap=(int)(fixtof(xpos)+8)>>1;
	 ymap=2+((int)(fixtof(zpos)+1.14)>>1);
     get_camera_matrix(&camera,
		       xpos, ypos, zpos,
		       xfront, yfront, zfront,
		       xup, yup, zup,
		       fov,
		       aspect);
	}



void clear_world(BITMAP* bmp)
	{
     int n;

     for (n=0;n<=rect_count;n++)
        {
        blit((BITMAP *)game_data[bgd].dat,bmp,floor_rect[n].x,floor_rect[n].y-BACK_OFFSET,floor_rect[n].x,floor_rect[n].y,floor_rect[n].w,floor_rect[n].h);
        }
     }





void render(BITMAP *bmp)
	{
     #ifdef DEBUG
     fprintf(debug,"--- Position : %f -----\n",fixtof(zpos));
     #endif

     rect_count=0;


    for (y=ymap-1;y<ymap+15;y++)
		{
		 for (x=0; x<8; x++)
                if ((*(map+(y<<3)+x)) && y>0 && y <level_size)
                  draw_square(bmp, &camera, x<<1, y<<1,(BITMAP *)game_data[texture].dat,285);
        }


   #ifdef DEBUG
    fprintf(debug,"--- vtx count : %i -----\n",rect_count);
    #endif

    }
void plouf(BITMAP* bmp, AL_DUH_PLAYER* dp)
	{
	  int xmap,ymap;
	  fixed x_end,z_end;
	  int x,y;
      x=0;
      blit(fond,bmp,X/2-41,Y-90-ball_y-BACK_OFFSET,X/2-41,Y-90-ball_y,((BITMAP *)game_data[babal000].dat)->w,((BITMAP *)game_data[babal000].dat)->h);
      clear_keybuf();
	  lspeed=0;
	  speed=0;

	  xmap=fixtoi((xpos+itofix(7))>>1);	     //Definit les coord. de la balle

	 
	//dans le plan du niveau
	//  else				                  // depuis le dernier saut
        ymap=2+((int)(fixtoi(zpos))>>1);

      ymap-=25;     // fait reculer la balle

      for (y=ymap;y>0;y--)
          for (x=0;x<8;x++)
              if (*(map+(y<<3)+x)!=0)
           		    goto found;

      found:
      y--;
      
      x_end=itofix((x<<1)-7);
	  z_end=itofix(1+((y-2)<<1));
        /*
        rectfill(screen,0,0,640,10,0);
        textprintf(screen,font,0,0,255,"%i %i %i %f %f %f %f",*(map+(y<<3)+x),x,y,fixtof(x_end),fixtof(z_end),fixtof(xpos),fixtof(zpos));
        rest (2000);
        */
      if (fixtoi(z_end)<0)
			{
		   	z_end=0;
			x_end=itofix(1);
			}

         do
		   	{
			 xpos+=ftofix(0.05*SGN(fixtof(x_end-xpos)));
             update_world();
             clear_world(bmp);
             render(bmp);
             draw_map(bmp);
             al_poll_duh(dp);
             blit(bmp,screen,0,0,0,0,X,Y);
             }
        while(fabs(fixtof(x_end-xpos))>0.1);

		 do
		   	{
             zpos+=ftofix(0.5*SGN(fixtof(z_end-zpos)));
             update_world();
             clear_world(bmp);
             render(bmp);
                 draw_map(bmp);

             blit(bmp,screen,0,0,0,0,X,Y);
                  al_poll_duh(dp);

         }
		 while(fabs(fixtof(z_end-zpos))>0.5);
         /*
         rectfill(screen,0,0,640,10,0);
         textprintf(screen,font,0,0,255,"%i",*(map+(y<<3)+x));
         rest (1000);
         */
         xpos=x_end;
         zpos=z_end;
           
         }

int test_col(BITMAP* bmp,AL_DUH_PLAYER* dp)
	{
    int col;
    #ifdef DEBUG
    //if (!collision_test)
    //  return 0;
    #endif

	 col=(*(map+(ymap<<3)+xmap));
   	 #ifdef DEBUG
     textprintf(bmp,font,140,10,255,"Current line: %i%i%i%i%i%i%i%i",*(map+(ymap<<3)),*(map+(ymap<<3)+1),*(map+(ymap<<3)+2),*(map+(ymap<<3)+3),*(map+(ymap<<3)+4),*(map+(ymap<<3)+5),*(map+(ymap<<3)+6),*(map+(ymap<<3)+7));
     textprintf(bmp,font,1,10,255,"Collision: %i",col);
     #endif
     if (!col && (jump_state==0))
        {
       plouf(bmp,dp);
  	      }
    
       return col;
	 }

void draw_map(BITMAP *bmp)
	{

	 int n,m;

	 for(y=MAP_BOTOM,n=-4<<MAP_ZOOM_FACTOR_SHIFT;y>=MAP_TOP;y--,n++)
		for(x=MAP_LEFT,m=0;x<MAP_RIGHT;x++,m++)
			{
           	 if (*(map+((ymap+(n>>MAP_ZOOM_FACTOR_SHIFT))<<3)+(m>>MAP_ZOOM_FACTOR_SHIFT)))
			   bmp->line[y][x]=color_map->data[125][fond->line[y+BACK_OFFSET][x]];
             else
               bmp->line[y][x]=color_map->data[200][fond->line[y+BACK_OFFSET][x]];
            }
	 hline(bmp,MAP_LEFT,MAP_BOTOM-(4<<MAP_ZOOM_FACTOR_SHIFT),MAP_RIGHT,0);
	 hline(bmp,MAP_LEFT,MAP_BOTOM-(5<<MAP_ZOOM_FACTOR_SHIFT),MAP_RIGHT,0);
	 rect(bmp,MAP_LEFT,MAP_TOP,MAP_RIGHT,MAP_BOTOM,0);
	}

void process_input()
	{
	 static int keydelay;
	 if (keydelay && keypressed())
	       {
 		 keydelay--;
		 return;
           }
	 if (keypressed())
	   keydelay=3;
       #ifdef DEBUG
       if (key[KEY_TAB])
         collision_test=1-collision_test;
       #endif
         if (jump_state==0)
	   	{
        if (key[KEY_L])
          light_type=1-light_type;
		
        if (key[KEY_LEFT])
		 	lspeed -= 0.1;
	   	if (key[KEY_RIGHT])
	  	 	lspeed += 0.1;
       	if (key[KEY_UP])
		 	speed += 0.01;
	   	if (key[KEY_DOWN])
		 	speed -= 0.01;
        }
       else
        	{
       	if (key[KEY_LEFT])
		 	lspeed -= 0.1;
	   	if (key[KEY_RIGHT])
	  	 	lspeed += 0.1;
       	}
   }

int screen_fall(BITMAP *v_screen,int zik,AL_DUH_PLAYER* duh_player)
    {
    int n=0;
    int count;
    MATRIX temp1,temp2,temp3,temp4,transform;
    BITMAP* v_scr=create_bitmap(v_screen->w,v_screen->h);
    V3D in_points[4];
    V3D out_points[4];
    BITMAP* textmap=create_bitmap(512*v_screen->w/320,256*v_screen->w/320);
    PALETTE temp;
    int c;

    get_palette(temp);

    blit(v_screen,textmap,0,0,0,0,v_screen->w,v_screen->h);

        in_points[0].x=ftofix(-9.5);
        in_points[0].y=ftofix(9.5);
        in_points[0].z=ftofix(-9.5);
        in_points[0].u=itofix(v_screen->w);
        in_points[0].v=0;

        in_points[1].x=ftofix(9.5);
        in_points[1].y=ftofix(9.5);
        in_points[1].z=ftofix(-9.5);
        in_points[1].u=0;
        in_points[1].v=0;

        in_points[2].x=ftofix(9.5);
        in_points[2].y=ftofix(-9.5);
        in_points[2].z=ftofix(-9.5);
        in_points[2].u=0;
        in_points[2].v=itofix(v_screen->h);

        in_points[3].x=ftofix(-9.5);
        in_points[3].y=ftofix(-9.5);
        in_points[3].z=ftofix(-9.5);
        in_points[3].u=itofix(v_screen->w);
        in_points[3].v=itofix(v_screen->h);

        for (n=0;n<4;n++)
                {
                  out_points[n].c=in_points[n].c;
                  out_points[n].u=in_points[n].u;
                  out_points[n].v=in_points[n].v;
                 }

      get_translation_matrix(&temp1,0,ftofix(9.5),ftofix(9.5));
      get_rotation_matrix(&temp2,itofix(1),0,0);
      matrix_mul(&temp1,&temp2,&temp3);
      get_translation_matrix(&temp4,0,ftofix(-9.5),ftofix(-9.5));
      matrix_mul(&temp3,&temp4,&transform);


      for (count=0;count<80;count++)
      {

       for (c=0;c<256;c++)
           {
            if (temp[c].r>0) temp[c].r--;
        	if (temp[c].g>0) temp[c].g--;
        	if (temp[c].b>0) temp[c].b--;
           }
        set_palette(temp);
        


       for (n=0;n<4;n++)
                {
                persp_project(in_points[n].x,in_points[n].y,in_points[n].z,&out_points[n].x,&out_points[n].y);
                apply_matrix(&transform, in_points[n].x, in_points[n].y, in_points[n].z, &in_points[n].x, &in_points[n].y, &in_points[n].z);
                }

        clear(v_scr);
        quad3d(v_scr,POLYTYPE_ATEX,textmap,&out_points[0],&out_points[1],&out_points[2],&out_points[3]);
        vsync();
        al_poll_duh(duh_player);
        blit(v_scr,screen,0,0,0,0,v_screen->w,v_screen->h);
        }
       return 0;
       }

#define GRID_SIZE 8

void glassbrk(BITMAP *v_screen,BITMAP *foreground,BITMAP* background,int zik, AL_DUH_PLAYER* duh_player)
    {
    int x=0;
    int y=0;
    int n=0;
    int c=0;
    int count=0;
    float volume=1.0;
    
    PALETTE temp;
    V3D in_points[1600];
    V3D out_points[1600];

    n=0;
    for (y=0;y<19;y++)
         for (x=0;x<19;x++)
                {
                  if (zik) { 
                 al_poll_duh(duh_player);}
                 
                in_points[n].x=ftofix(x-9.5);
                in_points[n].y=ftofix(y-9.5);
                in_points[n].z=ftofix(-9.5);
                in_points[n].u=ftofix((19-x)*(640.0/19.0));
                in_points[n].v=ftofix((19-y)*(480.0/19.0));

                in_points[n+1].x=ftofix(x-8.5);
                in_points[n+1].y=ftofix(y-9.5);
                in_points[n+1].z=ftofix(-9.5);
                in_points[n+1].u=ftofix((18-x)*(640.0/19.0));
                in_points[n+1].v=ftofix((19-y)*(480.0/19.0));

                in_points[n+2].x=ftofix(x-8.5);
                in_points[n+2].y=ftofix(y-8.5);
                in_points[n+2].z=ftofix(-9.5);
                in_points[n+2].u=ftofix((18-x)*(640.0/19.0));
                in_points[n+2].v=ftofix((18-y)*(480.0/19.0));

                in_points[n+3].x=ftofix(x-9.5);
                in_points[n+3].y=ftofix(y-8.5);
                in_points[n+3].z=ftofix(-9.5);
                in_points[n+3].u=ftofix((19-x)*(640.0/19.0));
                in_points[n+3].v=ftofix((18-y)*(480.0/19.0));

                n+=4;
                }

       for (n=0;n<1600;n++)
                {
                 if (zik) { 
                 al_poll_duh(duh_player);}
                 out_points[n].c=in_points[n].c;
                  out_points[n].u=in_points[n].u;
                  out_points[n].v=in_points[n].v;
                 }
       while(in_points[0].z<ftofix(-0.5))
            {
            if (zik) { 
                 al_poll_duh(duh_player);}
            for (n=0;n<1600;n+=4)
                {
                in_points[n].x=fmul(in_points[n].x,ftofix(1.01));
                in_points[n].y=fmul(in_points[n].y,ftofix(1.01))+ftofix(-0.1);

                in_points[n+1].x=in_points[n].x+(1<<16);
                in_points[n+1].y=in_points[n].y;

                in_points[n+2].x=in_points[n].x+(1<<16);
                in_points[n+2].y=in_points[n].y+(1<<16);

                in_points[n+3].x=in_points[n].x;
                in_points[n+3].y=in_points[n].y+(1<<16);
                }
            for (n=0;n<1600;n++)
                {
                in_points[n].z+=ftofix(.05);
                persp_project(in_points[n].x,in_points[n].y,in_points[n].z,&out_points[n].x,&out_points[n].y);
                }

            blit (background,v_screen,0,0,0,0,background->w,background->h);
              for (c=0,n=0;n<19*19;n++,c+=4)
                 quad3d(v_screen,POLYTYPE_ATEX,foreground,&out_points[c],&out_points[c+1],&out_points[c+2],&out_points[c+3]);


             blit(v_screen,screen,0,0,0,0,640,480);

             }
     get_palette(temp);
     for (count=0;count<80;count++)
      	{
if (zik) { 
                 al_poll_duh(duh_player);}
       for (c=0;c<256;c++)
           {
            if (temp[c].r>0) temp[c].r--;
        	if (temp[c].g>0) temp[c].g--;
        	if (temp[c].b>0) temp[c].b--;
           }
        set_palette(temp);
       if (zik) { 
          volume-=(0.015);
          al_duh_set_volume(duh_player, volume);
          al_poll_duh(duh_player);}
        }
          }
