
#include <allegro.h>
#include <string>
#include <iostream>
#include <fstream>
extern "C" {
#include "gif.h"
};

using namespace std;

void BlindReplace(BITMAP *b, int tokill, int topaint) {
	for (int x = 0; x < b->w; x++) {
		for (int y = 0; y < b->h; y++) {
			if (getpixel(b, x, y) == tokill) {
				putpixel(b, x, y, topaint);
			}
		}
	}
}

int main(int argc,char **argv) {
	if (argc <= 2) {
		cout << "Please pass in a gif file name and desired new file extension";
		return 1;
	}
	
	allegro_init();
	set_color_depth(16);
	
	bool transp = false;
	if (argc > 2) {
		if (argv[3][0] == 't') {
			cout << "Transp command detected: Replacing the 0,0 pixel color with magic pink" << endl;
			transp = true;
		}
	}
	
	char buffer[256];
	string file = argv[1];
	
	cout << "loading gif" << endl;
	BITMAP *anim = load_gif(argv[1], 0);
	if (!anim) {
		cout << "Could not load gif: " << argv[1];
		return 1;
	}
	
	update_animation(); // call this once to kill un-needed callback updates; we won't be bothering with the built-in timer code.
	
	int numFrames = get_frame_count(anim);
	if (numFrames<0) {
		cout << "Gif contains no frames (??) or there was some error in loading.";
		return 1;
	}
	else cout << "Gif contains " << numFrames << " frames." << endl;
	
	ofstream frames( (file + "INFO.txt").c_str() );
	if (frames.is_open()) {
		frames << numFrames << endl;
		
		int * frameLengths = new int[4];
		get_frame_data(anim, frameLengths);
		for (int i=0; i<numFrames; i++) {
			cout << "Length of frame " << i << ": " << frameLengths[i] << endl;
			frames << frameLengths[i] << endl;
		}
		delete [] frameLengths;
	}
	else {
		cout << "Non-fatal error: Could not open " << file << "INFO.txt for writing frame duration data." << endl;
	}
	
	cout << "Writing frames as seperate images" << endl;
	
	BITMAP *temp;
	for (int i=0; i<numFrames; i++) {
		temp = get_frame(anim, i);
		if (temp == 0) {
			cout << "Frame " << i << " not found; skipping..." << endl;
			continue;
		}
		if (transp) {
			int color = getpixel(temp, 0, 0);
			BlindReplace(temp, color, makecol(255,0,255));
		}
		
		string newFile = file + itoa(i, buffer, 10);
		newFile += string(".") + argv[2];
		cout << "Saving " << newFile << endl;
		if (save_bmp(newFile.c_str(), temp, 0)) {
			cout << "\tFailing to save!" << endl;
		}
		
		destroy_bitmap(temp);
		temp = 0;
	}
	
	destroy_bitmap(anim);
	anim = 0;
}
END_OF_MAIN()
