
#ifndef __gif_h
#define __gif_h

#include <allegro.h>

#include <math.h>
#ifndef M_PI
#define M_PI		3.14159265358979323846
#endif

#ifdef __cplusplus
extern "C" {
#endif

	// These (tabbed) functions added by zaphos.
	int get_frame_count(BITMAP *bmp);
	int get_frame_data(BITMAP *bmp, int*);
	BITMAP *get_frame(BITMAP *bmp, int framenum);
	
BITMAP *load_gif(const char *filename, RGB *pal);
BITMAP *load_video_gif(const char *filename, RGB *pal);
BITMAP *load_system_gif(const char *filename, RGB *pal);

int animation_completed(BITMAP *bmp);
void reset_animation(BITMAP *bmp);

void update_animation();
	


void __destroy_bitmap(BITMAP *bmp);
BITMAP *__load_bitmap(const char *filename, RGB *pal);

#define destroy_bitmap(bmp) __destroy_bitmap(bmp)
#define load_bitmap(bmp, pal) __load_bitmap(bmp, pal)

#ifdef __cplusplus
}
#endif

#endif
