#include "CommonHeaders.h"

extern void Draw_Mask(BITMAP *buff);
extern void Draw_Tablet(BITMAP *buff, struct Piece a, int Matrix[9][15]);
extern void Draw_Next_Tab(BITMAP *buff,struct Piece a);
extern void Draw_Score(BITMAP *buff, int Level);
extern void Set_Colors();
extern void Init_Buffers();
extern void Clear_Mem();

void Init_Basics();
int Insert_Piece();
void Set_Piece();
extern int Prepare_Next();
void Idle();
void Clear_Matrix();
void Prepare_Play();
int Line_Check(); //Restituisce il numero di linee cancellate
int Clean_Matrix(); //effetto "gravit"

int game_end_flag = 0;
int Again = 0;
int iInput=0;
int Score=0;
int Next_Piece;

DATAFILE *Sounds, *Gfx, *G_Data;

int Game_Matrix[9][15]; //La "mappa" 9 di X, 15 di Y

DUH *dTetris;
AL_DUH_PLAYER *dTris;

SAMPLE *sClear_Line;

volatile int speed_counter = 0;
volatile int M_Down = 0;
volatile int Rotate = 0;

struct Piece Active_Piece, Next_One;
struct Game_Rules GML;

void increment_speed_counter()
      {
         speed_counter++;
      }
END_OF_FUNCTION(increment_speed_counter)

void permit_move_down()
      {
         M_Down=1;
      }
END_OF_FUNCTION(permit_move_down)

void permit_rotation()
      {
         if(!(Rotate>4))
            Rotate++;
      }
END_OF_FUNCTION(permit_rotation)


int main(int argc, char *argv[])
{
BITMAP *bmp;
static int tInput, Left, Right;
static int delay;
  tInput = Left = Right  = 0;
  freopen("Debug.txt","w", stdout);
  printf("\nDebugging file for CTRIS");
  
  Init_Basics();
  
  clear_bitmap(screen);
  dTetris = dumb_load_xm("tetris.xm");
  if (!dTetris) {
      allegro_message("Error loading xm file Tetris.xm\n");
      return 1;
   }
  bmp = load_bmp("cTris_Splash_s.bmp", NULL);
  if(bmp==NULL)
    textout_centre_ex(screen,font, "Bitmap cTris_Splash_s.bmp not found",
    screen->w/2, screen->h/2, makecol(255,255,255), -1);
  else 
    blit(bmp, screen, 0,0, 0, 0, 640, 480);

  rest(2000);
  Choose_Game(&GML);
  Score = 10 * (GML.Curr_Lvl-1);

  dTris = al_start_duh(dTetris, 2, 0, GML.Volume, 5096, 48000);
    if(!GML.Music)
        al_pause_duh(dTris);
  Draw_Mask(screen);
  Draw_Score(screen, GML.Curr_Lvl);
  while(!game_end_flag)
  {
  while (speed_counter > 0 && !game_end_flag) 
    {     
  Active_Piece.Y_Offset+=GML.Speed;
  tInput++;
  Get_Input(&Active_Piece, &GML);
  if(GML.Music)
    al_poll_duh(dTris);
  vsync();
  Draw_Tablet(screen, Active_Piece, Game_Matrix);
  if(tInput>=1){
        switch (iInput) {
        case 1: 
            if(Right)break; //La richiesta viene processata
            Move_Right(&Active_Piece); //solo se  scaduto il timeout==> Right==0
            Right=5;
            break;
        case 2: 
            if(Left)break;
            Move_Left(&Active_Piece);
            Left=5;
            break;
        case 3: 
            if(Rotate>4)
                {
                Rotate_P(&Active_Piece);
                Rotate=0;
                }
            break;
        case 4: 
            if(M_Down)
                {
                Move_Down(&Active_Piece);
                M_Down=0;
                }
            break;
        case 5:
            Game_Over();
            Next_Piece=rand()%7;
            Insert_Piece();
            Clear_Matrix();
            Choose_Game(&GML);
            Score = 10 * (GML.Curr_Lvl-1);
            if(GML.Music)
                dTris = al_start_duh(dTetris, 2, 0, GML.Volume, 5096, 48000);
            Draw_Mask(screen);
            Draw_Score(screen, GML.Curr_Lvl);
            break;        
        }
        if(Right)Right--;
        if(Left)Left--;
        iInput=0;
        tInput=0;
        }
  if(Active_Piece.Y_Offset>=0){
    Active_Piece.Y_Offset=-BOX;
    int t=Check();
    if(t){
        if(GML.Sound)
          play_sample(Sounds[sBLOCK_STOP].dat, 255, 255, 1000, 0);
        Prepare_Next();
        if(Insert_Piece())
            {
            Game_Over();
            Next_Piece=rand()%7;
            Insert_Piece();
            Clear_Matrix();
            Choose_Game(&GML);
            Score = 10 * (GML.Curr_Lvl-1);
            dTris = al_start_duh(dTetris, 2, 0, GML.Volume, 5096, 48000);
            if(!GML.Music)
                al_pause_duh(dTris);
            Draw_Mask(screen);
            Draw_Score(screen, GML.Curr_Lvl);
            }
        if (Score>=10*GML.Curr_Lvl)
            {
            if(GML.Lvl_Increase && GML.Curr_Lvl<MAX_LVL)
                {
                GML.Curr_Lvl+=1;
                GML.Speed+=0.15;
                }
            }
        }
    Active_Piece.Pos[1]++;
    Draw_Score(screen, GML.Curr_Lvl);
    Draw_Next_Tab(screen, Next_One);
    }
 
  speed_counter--;
  }
}
  Clear_Mem();
  al_stop_duh(dTris);
  unload_duh(dTetris);
  //unload_datafile(Sounds);
  //unload_datafile(Gfx);
  unload_datafile(G_Data);
  exit(0);//Ho dovuto mettere exit(0) perch altrimenti qualche volta si impallava
  return 0;
}
END_OF_MAIN()


void Init_Basics()
{
  allegro_init();
  install_keyboard();
  install_timer();
  install_mouse();
  install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
  atexit(&dumb_exit);
  dumb_register_stdfiles();
  
  set_color_depth(32);
  set_gfx_mode(GFX_AUTODETECT, 640, 480,0,0);
  
  srand( (unsigned)time( NULL ) );
  
  /*Codice necessario per regolare i fps*/
  LOCK_VARIABLE(speed_counter);
  LOCK_FUNCTION(increment_speed_counter);
  install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
  
  LOCK_VARIABLE(M_Down);
  LOCK_FUNCTION(permit_move_down);
  install_int_ex(permit_move_down, BPS_TO_TIMER(16));
  
  LOCK_VARIABLE(Rotate);
  LOCK_FUNCTION(permit_rotation);
  install_int_ex(permit_rotation, BPS_TO_TIMER(18));
  
  set_color_conversion(COLORCONV_NONE);
  G_Data=load_datafile("Ctris_DATA.dat");
  /*
  Sounds=load_datafile("Ctris_Sound.dat");
  Gfx=load_datafile("Ctris_Gfx.dat");*/
  Sounds=(DATAFILE*)G_Data[SOUNDS].dat;
  Gfx=(DATAFILE*)G_Data[GFXS].dat;
  set_color_conversion(COLORCONV_TOTAL);
  
  if(G_Data==NULL)
    {
    allegro_message("Ctris_Sound.dat not found");
    exit(1);
    }
  if(Gfx==NULL)
    {
    allegro_message("Ctris_Gfx.dat not found");
    exit(1);
    }

  Set_Colors();
  Init_Buffers();
  Next_Piece=rand()%7;
  Insert_Piece();
  Clear_Matrix();
}

int Insert_Piece()
{
    Active_Piece.Piece=Next_Piece;
    Set_Piece(&Active_Piece);
    Draw_Tablet(screen, Active_Piece, Game_Matrix);
    Next_Piece=rand()%7;
    Next_One.Piece=Next_Piece;
    Set_Piece(&Next_One);
    Next_One.Pos[1]=1;
    Next_One.Pos[0]=1;
    return Check();
}

void Set_Piece(struct Piece *aPiece)
{   
    aPiece->Rotate=0;
    aPiece->Y_Offset=0;
    aPiece->color=makecol(rand()%155,rand()%155,rand()%155);
    aPiece->Pos[0]=2;
    aPiece->Pos[1]=0;
    if(aPiece->Piece==0)Set_Square(aPiece);
    else if(aPiece->Piece==1){
        Set_I_O(aPiece);
        aPiece->Rotate=1;
        }
    else if(aPiece->Piece==2)Set_Z(aPiece);
    else if(aPiece->Piece==3)Set_5(aPiece);
    else if(aPiece->Piece==4)Set_L(aPiece);
    else if(aPiece->Piece==5)Set_3(aPiece);
    else Set_nL(aPiece);
}


int Check()
{//La routine che controlla se il pezzo si deve fermare
struct Piece t;
t=Active_Piece;
int x,y,q;
for(y=0; y<4; y++)
    for(x=0; x<4; x++)
        if(t.Boxes[y][x] && Game_Matrix[t.Pos[0]+x][t.Pos[1]+y+1])
            return 1;
            
int Limit=0;      
if(Active_Piece.Pos[1]>=11)// questi sono i casi a scacchiera vuota
    {
    for(y=0; y<4; y++)
        for(x=0; x<4; x++)
            if(t.Boxes[y][x])
                Limit=y;
    if(Limit+t.Pos[1]==14)
        return 1;
    }
return 0;
}

int Prepare_Next()
{
int x,y;
for(y=0; y<4; y++)
    for(x=0; x<4; x++)
        if(Active_Piece.Boxes[y][x])
            Game_Matrix[Active_Piece.Pos[0]+x][Active_Piece.Pos[1]+y]=1;

int L=0;
L+=Line_Check();

Clean_Matrix(); //Fa l'effetto gravit
Clean_Matrix();//Ho fatto questa schifezza perch non
Clean_Matrix();//riuscivo a gestire meglio questa
Clean_Matrix();//funzione
Clean_Matrix();
Clean_Matrix();
Clean_Matrix();
Clean_Matrix();
Clean_Matrix();

Score+=L*L;
return L;
}


void Clear_Matrix()
{
int x,y;
for(x=0;x<9;x++)
    for(y=0;y<15;y++)
        Game_Matrix[x][y]=0;
}

void Rotate_P(struct Piece *a)
{
struct Piece Temp=*a;
    int r=a->Rotate;
    int Which=a->Piece;
    if(Which==0) return; // Un quadrato non pu ruotare
    if(Which==1)    
        if(r==0)  {
            Set_I_O(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_I_O(a);
            a->Rotate=1; }
        else {
            Set_I(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_I(a);
            a->Rotate=0;}
    if(Which==2)    
        if(r==0)  {
            Set_Z_O(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_Z_O(a);
            a->Rotate=1; }
        else {
            Set_Z(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_Z(a);
            a->Rotate=0;}
    if(Which==3)    
        if(r==0)  {
            Set_5_O(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_5_O(a);
            a->Rotate=1; }
        else {
            Set_5(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_5(a);
            a->Rotate=0;}
    if(Which==4)    
        if(r==0)  {
            Set_L_2(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_L_2(a);
            a->Rotate=1; }
        else if(r==1){
            Set_L_3(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_L_3(a);
            a->Rotate=2;}
        else if(r==2){
            Set_L_4(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_L_4(a);
            a->Rotate=3;}
        else if(r==3){
            Set_L(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_L(a);
            a->Rotate=0;}
    if(Which==5)    
        if(r==0)  {
            Set_3_2(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_3_2(a);
            a->Rotate=1; }
        else if(r==1){
            Set_3_3(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_3_3(a);
            a->Rotate=2;}
        else if(r==2){
            Set_3_4(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_3_4(a);
            a->Rotate=3;}
        else {
            Set_3(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_3(a);
            a->Rotate=0;}
    if(Which==6)    
        if(r==0)  {
            Set_nL_2(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_nL_2(a);
            a->Rotate=1; }
        else if(r==1){
            Set_nL_3(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_nL_3(a);
            a->Rotate=2;}
        else if(r==2){
            Set_nL_4(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_nL_4(a);
            a->Rotate=3;}
        else if(r==3){
            Set_nL(&Temp);
            if(Rotation_Check(Temp))
                return;
            Set_nL(a);
            a->Rotate=0;}
}

void Game_Over()
{
int K;
char cScore[6];
sprintf(cScore,"%6d",Score);
al_stop_duh(dTris);
K=alert("Game-Over", "Score:", cScore, "Again", "Quit", KEY_ENTER, KEY_ESC);
if(K==2)
    {
    Clear_Mem();
    exit(0);
    }
return;
}

int Line_Check()
{
int x,y;
int Lines=0;
int Line;
int List[10];
for(y=0; y<15; y++)//Controlla quali linee sono complete
    {
    Line=0;
    for(x=0; x<9; x++)
        if(Game_Matrix[x][y])Line++;
    if(Line==9)
        {
        List[Lines]=y;
        Lines++;
        }
    }
//svuota le linee complete

/*if(Lines)
  for(x=0; x<Lines; x++)
    Implode_Line(List[x], Game_Matrix);*/
 
     
for(y=0; y<Lines; y++)
    {
    if(GML.Sound)play_sample(Sounds[sLINE_CLEAR].dat, GML.Volume*150, 255, 1000, 0);
    De_Implode_Line(List[y], Game_Matrix, GML, dTris); 
    for(x=0; x<9; x++)
        Game_Matrix[x][List[y]]=0;
    }
  
      
Lines*Lines;
return Lines;      
}

int Clean_Matrix()
{
int x,y;
int Line;

for(y=1; y<15; y++)//Controlla quali linee sono complete
    { //partendo dalla 1a
    Line=0;
    for(x=0; x<9; x++)
        if(!Game_Matrix[x][y])Line++;
    if(Line==9)
        {
        for(x=0; x<9; x++)
            {
            Game_Matrix[x][y]=Game_Matrix[x][y-1];
            Game_Matrix[x][y-1]=0;
            }
        }
    }    
return 0;    
}






