#include "CommonHeaders.h"

extern DATAFILE *Gfx;
int color,Black,Red,Grey;
//definisco un p di colori di uso frequente
BITMAP *Next_Tab, *Tablet, *BG, *bMMenu, *bNormal[2], *bCostum[2];

void Draw_Matrix(int Matrix[9][15]);

void Draw_Mask(BITMAP *buff)
{
//clear_to_color(buff, makecol(0,190,235));
draw_sprite(buff, BG, 0, 0);
rect(buff, BOX*12-11, BOX*5-11, BOX*21-9, BOX*20-9, Black); 
rect(buff, BOX*2+12, BOX*4+7, BOX*8+14, BOX*10+9, Black);
}

void Draw_Score(BITMAP *buff, int Level)
{
char a[4];
char b[4];
sprintf(a,"%4d",Score);
rectfill(buff, BOX*27, BOX*5+10, BOX*30+BOX/2, BOX*9, makecol(255,255,255));
textout_centre_ex(buff, Gfx[fSCORE].dat, a, BOX*29, BOX*6-10, Black, makecol(255,255,255));
sprintf(b,"  0%d",Level);
textout_centre_ex(buff, Gfx[fSCORE].dat, b, BOX*29, BOX*8-10, Black, makecol(255,255,255));
}

void Set_Colors()
{
color=makecol(190,190,190);
Black=makecol(0,0,0);
Red=makecol(255,0,0);
Grey=makecol(90,90,90);
}

void Init_Buffers()
{
BITMAP *temp;
Tablet=create_bitmap(BOX*9+1, BOX*15+1);
Next_Tab=create_bitmap(BOX*6+1, BOX*6+1);

temp=create_bitmap(320,240);
BG=create_bitmap(640,480);
bMMenu=create_bitmap(640,480);

set_palette(*(PALETTE *)Gfx[BG_PAL].dat);
blit(Gfx[bBG].dat, temp, 0, 0, 0, 0, 320, 240);
stretch_blit(temp, BG, 0, 0, 320, 240, 0, 0, 640, 480);

set_palette(*(PALETTE *)Gfx[pTITLE].dat);
blit(Gfx[bMENU].dat, temp, 0, 0, 0, 0, 320, 240);
stretch_blit(temp, bMMenu, 0, 0, 320, 240, 0, 0, 640, 480);

destroy_bitmap(temp);

int x;
for(x=0; x<2; x++)
    {
    bNormal[x]=create_bitmap(218,50);
    bCostum[x]=create_bitmap(218,50);
    }
set_palette(*(PALETTE *)Gfx[pNORMAL1].dat);   
blit(Gfx[bNORMAL1].dat, bNormal[0], 0, 0, 0, 0, 218, 50);
set_palette(*(PALETTE *)Gfx[pNORMAL2].dat); 
blit(Gfx[bNORMAL2].dat, bNormal[1], 0, 0, 0, 0, 218, 50);
set_palette(*(PALETTE *)Gfx[pCOSTUM1].dat); 
blit(Gfx[bCOSTUM1].dat, bCostum[0], 0, 0, 0, 0, 218, 50);
set_palette(*(PALETTE *)Gfx[pCOSTUM2].dat);
blit(Gfx[bCOSTUM2].dat, bCostum[1], 0, 0, 0, 0, 218, 50);
}


void Draw_Box(BITMAP *Table, struct Piece a)
{
int z,r,q;
int x=a.Pos[0];
int y=a.Pos[1];
int fill=a.color;

for(z=0; z<4; z++)
    for(r=0; r<4; r++)
        if(a.Boxes[z][r])
            {
            rectfill(Table, (x+r)*BOX, (y+z)*BOX+a.Y_Offset, 
                (x+r+1)*BOX, (y+z+1)*BOX+a.Y_Offset, fill);
            rect(Table, (x+r)*BOX, (y+z)*BOX+a.Y_Offset, 
                (x+r+1)*BOX, (y+z+1)*BOX+a.Y_Offset, Grey);
            rect(Table, (x+r)*BOX+1, (y+z)*BOX+a.Y_Offset+1, 
                (x+r+1)*BOX-1, (y+z+1)*BOX+a.Y_Offset-1, Black);
            for(q=0; q<25; q++)
                {
                hline(Table, (x+r)*BOX+1+(((float)BOX/25)*q), (y+z)*BOX+a.Y_Offset+1, 
                (x+1+r)*BOX-2, makecol((25-q)*10,(25-q)*10,(25-q)*10));
                vline(Table, (x+r)*BOX+1, (y+z)*BOX+1+a.Y_Offset+(((float)BOX/25)*q),  
                (y+1+z)*BOX-2+a.Y_Offset, makecol((25-q)*10,(25-q)*10,(25-q)*10));
                }         
            }
}

void Draw_Tablet(BITMAP *buff,struct Piece a, int Matrix[9][15])
{
clear_to_color(Tablet, color);
Draw_Box(Tablet,a);
Draw_Matrix(Matrix);
draw_sprite(buff, Tablet, BOX*12-10, BOX*5-10); 
}


void Draw_Next_Tab(BITMAP *buff,struct Piece a)
{
clear_to_color(Next_Tab, color);
Draw_Box(Next_Tab,a);
draw_sprite(buff, Next_Tab, BOX*2+13, BOX*4+8); 
}

void Clear_Mem()
{
destroy_bitmap(Tablet);
destroy_bitmap(Next_Tab);
destroy_bitmap(BG);
}

void Draw_Matrix(int Matrix[9][15])
{
int x,y,q;
for(x=0; x<9; x++)
    for(y=0; y<15; y++)
        if(Matrix[x][y])
           {
           rectfill(Tablet, x*BOX, y*BOX, (x+1)*BOX, (y+1)*BOX, Red);
           rect(Tablet, x*BOX, y*BOX, (x+1)*BOX, (y+1)*BOX, Grey);
           rect(Tablet, x*BOX+1, y*BOX+1,(x+1)*BOX-1, (y+1)*BOX-1, Black);
           for(q=0; q<25; q++)
                {
                hline(Tablet, x*BOX+1+(((float)BOX/25)*q), y*BOX+1,(x+1)*BOX-2, makecol((25-q)*10,(25-q)*10,(25-q)*10));
                vline(Tablet, x*BOX+1, y*BOX+1+(((float)BOX/25)*q),(y+1)*BOX-2, makecol((25-q)*10,(25-q)*10,(25-q)*10));
                }    
           }
}

/*void Implode_Line(int z, int Matrix[9][15])
{
int t;
clear_to_color(Tablet, color);
Draw_Matrix(Matrix);
draw_sprite(screen, Tablet, BOX*12-10, BOX*5-10); 
int w=BOX*12-10;
int h=BOX*5-10+z*BOX;
int w1=w+9*BOX;
int h1=h+(z+1)*BOX;
int x;
for(t=0; t<30; t++)
    {
    vsync();
    for(x=0; x<9; x++)
        {
        int cx=w+x*BOX+BOX/2; //centre X
        int cy=h+BOX/2;       //centre Y
        stretch_sprite(screen, Explosion, cx-5-t/2, cy-5-t/2, 5+t, 5+t);
        }
    }
}*/

void De_Implode_Line(int z, int Matrix[9][15], struct Game_Rules GML, AL_DUH_PLAYER *dTris)
{
int t;
clear_to_color(Tablet, color);
Draw_Matrix(Matrix);
draw_sprite(screen, Tablet, BOX*12-10, BOX*5-10); 
int w=BOX*12-10;
int h=BOX*5-10+z*BOX;
int w1=w+9*BOX;
int h1=h+(z+1)*BOX;

for(t=0; t<BOX; t++)
    {
    if(GML.Music)al_poll_duh(dTris);
    vsync();
    hline(screen, w, h+t, w1, makecol(rand()%255, rand()%255, rand()%255));
    }
for(t=0; t<BOX; t++)
    {
    if(GML.Music)al_poll_duh(dTris);
    vsync();
    hline(screen, w, h+t, w1, color);
    }
for(t=0; t<20; t++)
    {
    if(GML.Music)al_poll_duh(dTris);
    rest(5);
    }
}







