#include "CommonHeaders.h"

char gSelect[]   = "Choose the type of game";
char gNormal[]   = "Normal Tetris";
char gCostum[]   = "Costum Tetris";
char gSound[]    = "Sound (On/Off)";
char gMusic[]    = "Music (On/Off)";
char gLvl_incr[] = "Level increases?";
char gVolum[]    = "Volume:";
char gLevel[]    = "Starting Level (1-9):";

int Rules;

extern BITMAP *bNormal[2], *bCostum[2], *bMMenu;
extern DATAFILE *Sounds;

int d_nTetris(int msg, DIALOG *d, int c);
int d_On_Off(int msg, DIALOG *d, int c);

DIALOG Game_Choose[] =
{
//(dialog proc)      (x)   (y)   (w)   (h)   (fg) (bg) key) (flags)   (d1)  (d2)  (dp)
{d_shadow_box_proc,  200,  170,  240,  130,   0,    0,  0,      0,     0,     0,  NULL},
{d_bitmap_proc,       0,     0,  640,  480,   0,    0,  0,      0,     0,     0,  NULL},
{d_nTetris,          220,  150,  218,  50,   0,    0,  0,      0,     0,     0,  NULL},
{d_nTetris,          220,  280,  218,  50,   0,    0,  0,      0,     1,     0,  NULL},
{NULL}
};

DIALOG Costum_Options[] =
{
//(dialog proc)      (x)   (y)   (w)   (h)   (fg)  (bg) key) (flags) (d1)  (d2)  (dp)
{ d_clear_proc,        0,   0,    0,    0,    0,    0,   0,    0,      0,    0, NULL },
{ d_shadow_box_proc, 100, 100,  200,   300,   0,    0,   0,    0,      0,    0, NULL},
{ d_text_proc,       115, 115,  200,    10,   0,    0,   0,    0,      0,    0, gSound},
{ d_text_proc,       115, 150,  200,    10,   0,    0,   0,    0,      0,    0, gMusic},
{ d_text_proc,       115, 185,  200,    10,   0,    0,   0,    0,      0,    0, gLvl_incr},
{ d_text_proc,       115, 220,  200,    10,   0,    0,   0,    0,      0,    0, gVolum},
{ d_text_proc,       115, 280,  200,    10,   0,    0,   0,    0,      0,    0, gLevel},
{ d_On_Off,          255, 105,   20,    20,   0,    0,   0,    0,      1,    0, NULL},
{ d_On_Off,          255, 140,   20,    20,   0,    0,   0,    0,      1,    0, NULL},
{ d_On_Off,          255, 180,   20,    20,   0,    0,   0,    0,      1,    0, NULL},
{ d_slider_proc,     115, 240,  100,    10,   0,    0,   0,    0,    300,  100, NULL, NULL},
{ d_slider_proc,     115, 300,  100,    10,   0,    0,   0,    0,      8,    0, NULL, NULL},
{ d_button_proc,     108, 330,  185,    30,   0,    0,   0,  D_EXIT,   0,    0, "Ok!"},
{ d_yield_proc,        0,   0,    0,    0,    0,    0,   0,    0,      0,    0, NULL},
{ NULL,                0,   0,    0,    0,    0,    0,   0,    0,      0,    0,    NULL,  NULL, NULL  }
};

void Choose_Game(struct Game_Rules *GML)
{
Rules=0;
int x;

clear_to_color(screen,makecol(0,0,0));

for(x=0; Game_Choose[x].proc!=NULL; x++)
    {
    Game_Choose[x].fg=makecol(0,0,0);
    Game_Choose[x].bg=makecol(50,50,250);
    }
Game_Choose[1].dp=bMMenu;
Game_Choose[0].bg=makecol(150,150,150);

for(x=0; Costum_Options[x].proc!=NULL; x++)
    {
    Costum_Options[x].fg=makecol(0,0,0);
    Costum_Options[x].bg=makecol(50,50,250);
    }
for(x=2; x<=6; x++)
    Costum_Options[x].bg=-1;
Costum_Options[1].bg=makecol(150,150,150);

do_dialog(Game_Choose, -1);

if(!Rules)//gioco stanard
    {
    GML->Sound=1;
    GML->Music=1;
    GML->Volume=1.0;
    GML->Lvl_Increase=1;
    GML->Curr_Lvl=1;
    }
else
    {
    do_dialog(Costum_Options, -1);
    GML->Sound=Costum_Options[7].d1;
    GML->Music=Costum_Options[8].d1;
    GML->Lvl_Increase=Costum_Options[9].d1;
    GML->Volume=(Costum_Options[10].d2) / 100.0;
    GML->Curr_Lvl=Costum_Options[11].d2 + 1; 
    }
GML->Speed=0.15 + (0.15 * GML->Curr_Lvl);
}


int d_nTetris(int msg, DIALOG *d, int c)
{
int x=d->x, y=d->y;
int wx=x+d->w, wy=y+d->h;
int fg, bg;
switch(msg)
    {
    case MSG_DRAW:
        if (d->flags & D_SELECTED)
            if(!d->d1) draw_sprite(screen, bNormal[1], d->x, d->y);
            else draw_sprite(screen, bCostum[1], d->x, d->y);
        else {
            if(!d->d1) draw_sprite(screen, bNormal[0], d->x, d->y);
            else draw_sprite(screen, bCostum[0], d->x, d->y);
            }        
        break;
    case MSG_GOTMOUSE:
        play_sample(Sounds[sMENU_SELECT].dat, 200, 255, 1000, 0);
        d->flags = D_SELECTED;
        return D_REDRAWME;
    case MSG_LOSTMOUSE:
        d->flags = 0;
        return D_REDRAWME;
    case MSG_CLICK:
        Rules=d->d1;
	    return D_CLOSE;
    default:
        d_button_proc(msg, d, c);   
     }     

return D_O_K;
}

int d_On_Off(int msg, DIALOG *d, int c)
{
int x=d->x, y=d->y;
int wx=x+d->w, wy=y+d->h;
int fg=d->fg, bg=d->bg;
switch(msg)
    {
    case MSG_DRAW:
        rectfill(screen, x, y, wx, wy, bg);
        rect(screen, x, y, wx, wy, fg);
        if (d->d1)
            {
            circlefill(screen, x+d->w/2, y+d->h/2, d->w/3+1, fg);
            //circle(screen, x+d->w/2, y+d->h/2, d->w/3+1, fg);
            }
        break;
    case MSG_CLICK:
        if(d->d1)
            d->d1=0;
        else
            d->d1=1;
        return D_REDRAWME;    
    default:
        d_button_proc(msg, d, c);   
     }     

return D_O_K;
}
