#ifndef KEE_SNOOKERS_KEEVECTOR2D_H
#define KEE_SNOOKERS_KEEVECTOR2D_H

#include <cmath>
using namespace std;

class keeVector
{
	public:
		double x, y;

		keeVector() : x(0), y(0) {}
		keeVector(double a, double b) : x(a), y(b) {}
		keeVector(const keeVector& copied) : x(copied.x), y(copied.y) {}
		keeVector(keeVector a, keeVector b)
		{
			x = b.x - a.x;
			y = b.y - a.y;
		}
		
		//------------------------------------------------------------------------

		double magnitude() { return sqrt(x*x + y*y); }

		//------------------------------------------------------------------------

		keeVector normal(keeVector p2)
		{
			return keeVector(p2.y - this->y, this->x - p2.x);
		}

		//------------------------------------------------------------------------

		void normalize()
		{
			double length = magnitude();
			if(length != 0)
			{
				x /= length;
				y /= length;
			}
		}
		
		//------------------------------------------------------------------------

		keeVector operator = (const keeVector &other)
		{
			if(&other != this)
			{
				x = other.x;
				y = other.y;
			}
			return *this;
		}

		//------------------------------------------------------------------------

		keeVector operator + (const keeVector &other)
		{
			keeVector tmp;
			tmp.x = x + other.x;
			tmp.y = y + other.y;
			return tmp;
		}

		//------------------------------------------------------------------------

		keeVector operator - (const keeVector &other) {
			keeVector tmp;
			tmp.x = x - other.x;
			tmp.y = y - other.y;
			return tmp;
		}

		//------------------------------------------------------------------------

		keeVector operator * (const double &scalar) {
			keeVector tmp;
			tmp.x = x * scalar;
			tmp.y = y * scalar;
			return tmp;
		}

		//------------------------------------------------------------------------

		keeVector operator / (const double &scalar) {
			keeVector tmp;
			tmp.x = x / scalar;
			tmp.y = y / scalar;
			return tmp;
		}
  		
		//------------------------------------------------------------------------

		keeVector operator += (const keeVector &other)
		{
			x += other.x;
			y += other.y;
			return *this;
		}

		//------------------------------------------------------------------------

		keeVector operator -= (const keeVector &other)
		{
			x -= other.x;
			y -= other.y;
			return *this;
		}

		//------------------------------------------------------------------------

		keeVector operator *= (const double &scalar)
		{
			x *= scalar;
			y *= scalar;
			return *this;
		}

		//------------------------------------------------------------------------

		keeVector operator /= (const double &scalar)
		{
			x /= scalar;
			y /= scalar;
			return *this;
		}
	
		//------------------------------------------------------------------------

		// Non-standard function.  It's for convenience more than anything.
		// I don't know if this has any mathematical name, but I find it helpful.
		keeVector operator * (const keeVector &other) {
			return keeVector(x * other.x, y * other.y);
		}

		//------------------------------------------------------------------------

		// Non-standard function.  It's for convenience more than anything.
		// I don't know if this has any mathematical name, but I find it helpful.
		keeVector operator / (const keeVector &other) {
			return keeVector(x / other.x, y / other.y);
		}

		//------------------------------------------------------------------------

		// Non-standard function.  It's for convenience more than anything.
		// I don't know if this has any mathematical name, but I find it helpful.
		keeVector operator *= (const keeVector &other)
		{
			x *= other.x;
			y *= other.y;

			return *this;
		}

		//------------------------------------------------------------------------

		// Non-standard function.  It's for convenience more than anything.
		// I don't know if this has any mathematical name, but I find it helpful.
		keeVector operator /= (const keeVector &other)
		{
			x /= other.x;
			y /= other.y;

			return *this;
		}

		//------------------------------------------------------------------------

		bool operator == (const keeVector &other)
		{
			if(&other != this)
			{
				if(other.x != x)
					return false;
				if(other.y != y)
					return false;
			}
			return true;
		}

		//------------------------------------------------------------------------

		bool operator != (const keeVector &other)
		{
			if(*this == other)
				return false;
			return true;
		}

		//------------------------------------------------------------------------

		double dot(keeVector other)
		{
			return (this->x * other.x) + (this->y * other.y);
		}

		//------------------------------------------------------------------------

		double distanceTo(keeVector other)
		{
			other -= *this;
			return other.magnitude();
		}
};

#endif
