#ifndef KEE_SNOOKER_GEOMETRY_H
#define KEE_SNOOKER_GEOMETRY_H

#include "keeVector2d.h"

class Point
{
public:
	// Used to slighty speed up collision detection, I think.
	// Using this also seems to make the balls somewhat squishy.
	//keeVector oldPosition; 

	keeVector position;	// Position of ball's center.
	keeVector velocity;	// Ball's velocity.
	
	double mass;	// Ball's mass.
	int size;			// Ball's radius.

	// Default constructor.  
	Point()
		: mass(1), size(12)	// Default mass of 1, radius of 12.
	{}

	// Constructor.
	Point(keeVector position, keeVector velocity, int size, double mass)
	{
		this->position = position;
		this->velocity = velocity;

		this->size = size;
		this->mass = mass;
	}

};

class Joint
{
public:
	keeVector p1, p2;	// End points of line segment.

	// Default constructor.
	Joint()
	{}

	// Constructor.
	Joint(keeVector p1, keeVector p2)
	{
		this->p1 = p1;
		this->p2 = p2;
	}

};

#endif
