#include "prototypes.h"
#include "globals.h"

int main(void)
{
	allegro_init();			// Initialize allegro.
	install_keyboard();	// Enable keyboard.
	install_mouse();		// Enable mouse.
	install_timer();		// Needed for show_mouse();

	// Create a 800x600 non-fullscreen window.
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);

	set_window_title("Kee-Yip Chan's Snooker Clone");

	text_mode(-1);	// Text will be drawn on transparent background.

	BITMAP* buffer = create_bitmap(SCREEN_W, SCREEN_H);	// Create a bitmap for double buffering.

	// Initialize data.
		// Create joints aka lines.
														 // position.							velocity.
			g_joints.push_back(Joint( keeVector(55, 400),		keeVector(740, 500) )); // Arbitrary line.
			g_joints.push_back(Joint( keeVector(85, 150),		keeVector(100, 500) )); // Arbitrary line.

			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.
			g_joints.push_back(Joint( keeVector(300, 210),	keeVector(0, 0) ));	// Arm of rotating wheel.

			g_joints.push_back(Joint( keeVector(10, 10),		keeVector(790, 10) ));	// Ceiling.
			g_joints.push_back(Joint( keeVector(10, 10),		keeVector(10, 590) ));	// Left wall.
			g_joints.push_back(Joint( keeVector(10, 590),		keeVector(390, 550) ));	// Floor.
			g_joints.push_back(Joint( keeVector(390, 550),	keeVector(790, 590) ));	// Floor.
			g_joints.push_back(Joint( keeVector(790, 10),		keeVector(790, 590) ));	// Right wall.
		//~
	
		// Create points aka balls.
														// position.						velocity.					size.		mass.
			g_points.push_back(Point(keeVector(100, 300),	keeVector(0, 0),	16,			10));	// Player.
			g_points.push_back(Point(keeVector(50, 40),		keeVector(0, 0),	12,			5));	// medium ball.
			g_points.push_back(Point(keeVector(80, 40),		keeVector(0, 0),	12,			5));	// medium ball.
			g_points.push_back(Point(keeVector(110, 40),	keeVector(0, 0),	6,			1));	// small ball.
		//~
	//~

	// Main loop, exit when ESC is pressed.
	while(!key[KEY_ESC])
	{
		// Check input.
			if(key[KEY_UP])
			{
				g_accControl.y = -0.07;	// Jet pack. Accelerate upwards.
			}
			if(key[KEY_LEFT])
			{
				g_accControl.x = -0.07;	// Walk left. Accelerate to the left.
			}
			if(key[KEY_RIGHT])
			{
				g_accControl.x = 0.07;	// Walk right. Accelerate to the right.
			}

			static bool leftMousePressed = false, rightMousePressed = false;
			if(mouse_b & 1)
			// Left mouse button pressed.
			{
				if(!leftMousePressed)
				{
					leftMousePressed = true;
						// Create a new ball.
					g_points.push_back(Point(keeVector(mouse_x, mouse_y),	keeVector(0, 0), 12, 5));
				}
			}
			if(!(mouse_b & 1))
			// Ensures that it doesn't repeat the mouse press, otherwise streams of
			// new balls would gush out.
				leftMousePressed = false;
			if(mouse_b & 2)
			// Right mouse button pressed.
			{
				if(!rightMousePressed)
				{
					rightMousePressed = true;
						// Create a new ball.
					g_points.push_back(Point(keeVector(mouse_x, mouse_y),	keeVector(0, 0), 6, 1));
				}
			}
			if(!(mouse_b & 2))
			// Ensures that it doesn't repeat the mouse press, otherwise streams of
			// new balls would gush out.
				rightMousePressed = false;
		//~

		// Logic.
			doPhysics();
		//~

		// Rendering.
			// Erase the buffer so we can use it again, otherwise old images will linger.
			// White color for clarity.
			clear_to_color(buffer, makecol(255, 255, 255));	

			// Draw points.
			for(unsigned i = 0; i < g_points.size(); i++)
			{
/*
				// Debug.  Draw bounding box.  I suspect the collision detection to be bounding box,
				// but then when I see the actual rendering it really looks like circle-circle detection.
				// I'm probably wrong, but seeing the boxes may be helpful anyway.
				rect(
					buffer,																				// Draw to buffer.
					g_points[i].position.x - g_points[i].size,		// Top left. Point's position - size.
						g_points[i].position.y - g_points[i].size,
					g_points[i].position.x + g_points[i].size,		// Bottom right. Point's position + size.
						g_points[i].position.y + g_points[i].size,
					makecol(255, 0, 255)													// Hot pink color.
				);
*/


				// Draw a solid ball.
				circlefill(
					buffer,																									// Draw to buffer.
					g_points[i].position.x, g_points[i].position.y,					// Point's position aka ball's center.
					g_points[i].size,																				// Radius.
					(i == 0) ? makecol(255, 0, 0) : makecol(0, 0, 255)			// Red if player, otherwise blue.
				);


				// Draw an outlined ball.
				circle(
					buffer,																							// Draw to buffer.
					g_points[i].position.x, g_points[i].position.y,			// Point's position aka ball's center.
					g_points[i].size,																		// Radius.
					makecol(0, 0, 0)	// Red if player, otherwise blue.
				);

			}


			// Draw joints.
			for(unsigned i = 0; i < g_joints.size(); i++)
			{
				line(
					buffer,															// Draw to buffer.
					g_joints[i].p1.x, g_joints[i].p1.y,	// Point 1.
					g_joints[i].p2.x, g_joints[i].p2.y,	// Point 2.
					makecol(0, 0, 0)										// Black color.
				);
			}

			// Print instructions.
			textout(buffer, font, "Left Mouse Button - new big ball      Right Mouse Button - new small ball",
				125, 1, makecol(0, 0, 0));

			textout(buffer, font, "Arrow Keys - move red ball",
				300, 592, makecol(0, 0, 0));

			show_mouse(buffer);	// Draw the mouse cursor.

			draw_sprite(screen, buffer, 0, 0);	// Draw the buffer onto the screen.
		//~

	}

	return 0;

}END_OF_MAIN();
