class menu_item:public text
{
public:
    void update();
    menu_item() {};
    menu_item(string what) {the_string = what;};;
    ~menu_item() { };
};

void menu_item::update()
{
    fade_value = fade_value - 0.015;
    if(fade_value < 0.2)
    {
        fade_value = 0.2;
    }    
}      

class menu
{
public:
    menu() {the_font = new better_font(); current_selected = 0; menu_max = 0;};
    ~menu() {delete the_font;};
    void draw();
    int update(int key);
    int update();
    void add_text(string what) {the_list.push_back((menu_item)what);menu_max++;};
private:
    better_font *the_font;
    list<menu_item> the_list;
    list<menu_item>::iterator current_location;
    int current_selected;
    int menu_max;
};    

void menu::draw()
{
    current_location = the_list.begin();
    int current_num = 0;
    int c;
    string temp;
    glPushMatrix();
    glDisable(GL_DEPTH_TEST);
    glLoadIdentity();
    glEnable(GL_BLEND);
    
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    //allegro_gl_use_alpha_channel(true);
    while(current_location != the_list.end())
    {
        c = makecol(255, 255, 255);
        #ifdef BLOCKGUY_USE_NORMAL_ALLEGROGL
        if(current_num == current_selected)
        {
            temp = (string)"> " + current_location->the_string + (string)" <";
        }
        else
        {
            temp = current_location->the_string;
        }
        #else
        temp = current_location->the_string;
        #endif
        the_font->display(temp,  -(((float)(temp.length() - 1)/1.34)), (float)menu_max * 2.5/2 - (current_num * 2.5), (float)-60,current_location->fade_value, c);
        current_location++;
        current_num++;
    } 
    glColor3f(1.0, 1.0, 1.0);     
   // allegro_gl_use_alpha_channel(false);
    glDisable(GL_BLEND);
    glEnable(GL_DEPTH_TEST);
    glPopMatrix();  
}    

int menu::update(int key_pressed)
{
    if(key_pressed == 1)
    {
        current_selected++;
        if(current_selected == menu_max)
        {
            current_selected = 0;
        }    
    }
    if(key_pressed == 0)
    {
        if(current_selected == 0)
        {
            current_selected = menu_max;
        }
        current_selected--;    
    } 
    if(key_pressed == 4)
    {
        return current_selected + 1;
    }
    if(key_pressed == 5)
    {
        return -1;
    }  
    return 0;
}    

int menu::update()
{
    current_location = the_list.begin();
    int temp_num = 0;
    while(current_location != the_list.end())
    {
        current_location->update();
        if(temp_num == current_selected)
        {
            current_location->fade_value = 1.0;
        }    
        temp_num++;
        current_location++;
    }     
    return 0;
}    


