#include <allegro.h>
#include <alleggl.h>
#include <iostream>
#include <sstream>
#include <fstream>
#include <GL/glu.h>
using namespace std;

bool something_is_really_wrong = false;

ofstream log_file("log.txt");

#include "cubehead.h"
class level2;

level2 *current_map;

//this makes blockguy use allegro_gl_printf instead of the custom function allegro_gl_printf_ex2
//it does remove the alpha of text but, doesn't change the game
#define BLOCKGUY_USE_NORMAL_ALLEGROGL

#include "font.h"
#include "init.h"
#include "level2.h"
#include "classes.h"
#include "text.h"
#include "menu.h"
#include "buttons.h"

int logic_timer_var = 0;
int input_timer_var = 0;
int logic_loops = 0;
int frames = 0;
float fps = 0;



void input_timer_func()
{
    input_timer_var++;
}  


void logic_timer_func()
{
    logic_timer_var++;
}    

int main() 
{
	log_file << "Program Started" << endl;
    game_state init("config.cfg");
    log_file << "Init ran" << endl;
    if(something_is_really_wrong)
    {
        allegro_message("Init error");
        return -1;
    }    
    log_file << "Something_is_really_wrong was false" << endl << "Installing timers" << endl;
    glAlphaFunc(GL_GREATER, 0.5);
    LOCK_VARIABLE(logic_timer_var);
    LOCK_FUNCTION(logic_timer_func);
    install_int_ex(logic_timer_func, BPS_TO_TIMER(60));
    LOCK_VARIABLE(input_timer_var);
    LOCK_FUNCTION(input_timer_func);
    install_int_ex(input_timer_func, BPS_TO_TIMER(20));
    int current_map_number = 1;
    log_file << "Timers installed" << endl;
    
    text_system notify;

    ostringstream *map_notify = new ostringstream;   
    ostringstream *map_name = NULL;
    
    
    int old_rc_count = 0;
    current_map = NULL;
    player *current_player = NULL;
    bool has_won;
    log_file << "Making menu" << endl;
    menu the_menu;
    the_menu.add_text("Play");
    the_menu.add_text("Help");
    the_menu.add_text("Quit");
    int menu_value;  
    has_won = false;
    bool exit_game = false;
    bool back_to_menu = false;
    logic_timer_var = 0;
    input_timer_var = 0; 
    float curr_x = 0;
    float curr_y = 0;
    float temp_x = 0;
    float temp_y = 0;
    log_file << "Making controller" << endl;
    input_system cntrl;
    cntrl.add_button(KEY_UP);
    cntrl.add_button(KEY_DOWN);
    cntrl.add_button(KEY_LEFT);
    cntrl.add_button(KEY_RIGHT);
    cntrl.add_button(KEY_ENTER);
    cntrl.add_button(KEY_ESC);
    cntrl.add_button(KEY_F);
    log_file << "Running menu" << endl;
    while(!exit_game)
    {
        notify.clear();
        notify.add_text("Version 0.80 BETA");
        notify.add_text("BlockGuy!");
        menu_value = 0;
        while(menu_value == 0)
        {
            cntrl.poll();
            if(input_timer_var > 0)
            {
                menu_value = the_menu.update(cntrl.check_for_button());
                input_timer_var--;
            }

            if(logic_timer_var > 0)
            {
                the_menu.update();
                notify.update();
                cntrl.update();
                logic_timer_var--;
            }
            else
            {
                glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
                the_menu.draw();
                notify.draw();
                allegro_gl_flip();
                rest(0);
            }  
        }              
        if((menu_value == 3)||(menu_value == -1))
        {
            exit_game = true;
            back_to_menu = true;
        }    
        else if(menu_value == 2)
        {
            exit_game = false;
            back_to_menu = true;
            notify.clear();
            /*BlockGuy is a clone of the
            old ti-83 game blockdude.
            to play use the arrow keys
            left and right go left and
            right, up makes the guy
            climb onto the next highest
            block, down will pickup or
            drop a block. Try to get to
            the door! have fun.
            
            Press enter...
            */
            notify.add_text("Press enter...");
            notify.add_text(" ");
            notify.add_text(" ");
            notify.add_text("door! have fun.");
            notify.add_text("or drop a block. Try to get to the");
            notify.add_text("next highest block, down will pickup");
            notify.add_text("right, up makes the guy climb onto the ");
            notify.add_text("arrow keys left and right go left and");
            notify.add_text("ti-83 game blockdude. to play use the ");
            notify.add_text("    BlockGuy is a clone of the old");
            //                                                     |<- screen limit for text
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
            notify.draw();
            allegro_gl_flip();
            logic_timer_var = 0;
            cntrl.poll();
            cntrl.update();
            menu_value = 0;
            while((menu_value != 4)&&(menu_value != 5))
            {
                if(logic_timer_var > 0)
                {
                    cntrl.update();
                }    
                rest(0);
                cntrl.poll();
                menu_value = cntrl.check_for_button();
            }
            menu_value = 0;
            logic_timer_var = 0;
            input_timer_var = 0;
        }    
        else
        {
            menu_value = 0;
            back_to_menu = false;
        }  
        notify.clear();  
        notify.add_text("Welcome to Blockguy, have fun!!"); 
        logic_timer_var = 0;
        input_timer_var = 0;        
        log_file << "Starting game" << endl;        //finish the logging
        while((current_map_number != 12)&&(!back_to_menu))
        {
	    log_file << "Clearing old level values" << endl;
            if(current_map)
            {
	    	log_file << "Clearing map" << endl;
                delete current_map;
            }    
	    if(map_name)
	    {
	    	log_file << "Clearing Map name" << endl;
            	delete map_name;
	    }
	    if(current_player)
	    {
	    	log_file << "Clearing Player" << endl;
            	delete current_player;
	    }
            log_file << "Loading level" << current_map_number << endl;
            current_player = new player("textures/guy.bmp");
            map_name = new ostringstream;
            *map_name << "level" << current_map_number << ".map";
    
    
            current_map = new level2((char *)map_name->str().c_str());
            log_file << "Level Loaded" << endl;
    
            current_player->set_to_start();
            current_map->map_to_real(current_player->get_x(), current_player->get_y(), &curr_x, &curr_y);
            has_won = false;
    
            while(!back_to_menu&&!has_won)
            {
        
            	//input start
            	cntrl.poll();  
            	if(input_timer_var > 0)
            	{
                	switch(cntrl.check_for_button())
                	{
                        case 2:
                    	    current_player->move_left();  	    
                    	    break;
                   	    case 3:
                            current_player->move_right();    
                            break;
                        case 0:
                            current_player->move_up();
                            break;
                        case 1:
                            current_player->do_block();
                            break;
                        case 6:
                            delete map_notify;
                       	    map_notify = new ostringstream;
                       	    *map_notify << "FPS: " << fps;
                            notify.add_text(map_notify->str());
                            break;
                        case 5:
                            back_to_menu = true;
                            break;
                    }    
                    current_player->do_gravity();
                    input_timer_var--;
                }    
       
                //input end
                if(logic_timer_var > 0)
                {
                    if(current_player->check_win())
                    {
                        has_won = true;
                    }    
                    notify.update();
                    cntrl.update();
                    current_map->map_to_real(current_player->get_x(), current_player->get_y(), &temp_x, &temp_y);
                    curr_x = curr_x - ((curr_x - temp_x)/40);
                    curr_y = curr_y - ((curr_y - temp_y)/40);
                    logic_timer_var--;
                    logic_loops++;
                }  
                else
                {
                    //draw start
                    glLoadIdentity();
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
                    //current_map->focus_on_map(current_player->get_x(), current_player->get_y(), 20);
                    glTranslatef(curr_x, curr_y, -20);
                    
                	current_map->draw();
                    current_player->draw();
                    notify.draw();
                    
                	allegro_gl_flip();
                	frames++;
                	//draw end 
                	if(logic_loops >= 60)
                	{
                	    fps = 60 * (frames/logic_loops);
                	    logic_loops = 0;
                	    frames = 0;
                	}    
                	rest(0);
       	          }   	
     	
        
           	}  
           	if(has_won)
           	{
		    if(map_notify)
		    {
                        delete map_notify;
			map_notify = NULL;
		    }
           	    map_notify = new ostringstream;
           	    current_map_number++;
           	    *map_notify << "You are on level " << current_map_number << "!";
           	    notify.add_text(map_notify->str());
           	    notify.add_text("You beat the level!");
           	}
            else
            {
                back_to_menu = true;
            }        
        }   
    }    	
    	log_file << "Closeing crap now!" << endl;
	delete map_notify;
	map_notify = NULL;
	delete current_map;
	current_map = NULL;
	delete current_player;
	current_player = NULL;
	log_file << "Deconstuction done" << endl;
	return 0;
}
END_OF_MAIN();
