class level2              //class for a '2d' classic (ie blocks, and one texture per level) level
{
public:
    void draw();
    void map_to_real(float x, float y, float *mx, float *my);
    void focus_on_map(float x, float y, float zoom);
    int check_cord(int x, int y);
    void set_cord(int x, int y, int to);
    int check_win(int x, int y);
    int getstart_y() {return start_y;};
    int getstart_x() {return start_x;};
    level2(char *file);
    ~level2();
private:
    int load(char *file);
    int load_texture(char *file);
    int load_texture2(char *file);
    int load_door_tex();
    int *map;
    int width;
    int height;
    int win_x;
    int win_y;
    int start_x;
    int start_y;
    GLuint texture;
    GLuint texture2;
    GLuint door_texture;
    cube the_cube;
    cube the_cube2;
};

level2::~level2()
{   
    log_file << "Level2 deconstuctor" << endl;
    glDeleteTextures(1, &texture);
    glDeleteTextures(1, &texture2);
    glDeleteTextures(1, &door_texture);
}    

int level2::load_door_tex()
{
    BITMAP *temp = load_bitmap("textures/door.bmp", NULL);
    door_texture = allegro_gl_make_masked_texture(temp);
    if(!texture)
    {
        allegro_message("texture error");
    }    
}    

int level2::check_win(int x, int y)
{
    if((win_x == x)&&(win_y == y))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}            

void level2::set_cord(int x, int y, int to)
{
    *(map + (y * width) + x) = to;
}    

int level2::check_cord(int x, int y)
{
    return *(map + (y * width) + x);
}    

void level2::focus_on_map(float x, float y, float zoom)        //Sets the center of the screen to that position, zoom away
{
    map_to_real(x, y, &x, &y);
    glTranslatef(x, y, -zoom);
}    

void level2::map_to_real(float x, float y, float *mx, float *my)
{
    *mx = x * 2;
    *my = y * 2;
}    


void level2::draw()
{
    int curr_x = 0;
    int curr_y = 0;
    while(curr_y < height)
    {
        while(curr_x < width)
        {
            if(*(map + (curr_y * width) + curr_x) == 1)
            {
                the_cube.set_location(curr_x * 2, curr_y * 2, 0);             //2 == the width and height of the cubes
                the_cube.draw();
            }  
            if(*(map + (curr_y * width) + curr_x) == 2)
            {
                the_cube2.set_location(curr_x * 2, curr_y * 2, 0);             //2 == the width and height of the cubes
                the_cube2.draw();
            }      
            curr_x++;
        }
        curr_x = 0;
        curr_y++;
    }
    float x2, y2;
    current_map->map_to_real(win_x, win_y, &x2, &y2);
    glPushMatrix();
    glTranslatef(-x2, -y2, 0);
    //if rotation is needed addd it here
   	glEnable(GL_ALPHA_TEST); //masked drawing
    glBindTexture(GL_TEXTURE_2D, door_texture);
    glBegin(GL_QUADS);
		// Front Face
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  0.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  0.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  0.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  0.0f);	// Top Left Of The Texture and Quad
	glEnd();
	glDisable(GL_ALPHA_TEST);
	glPopMatrix();
    
}            


level2::level2(char *file)
{
    int ret = load(file);
    if(ret)
    {
        allegro_message("Uh Oh! the map file was no good, Error:%i", ret);
    }
    the_cube.set_texture(texture);
}        
    
    
int level2::load_texture(char *file)
{
    BITMAP *temp = load_bitmap(file, NULL);
    if(!temp)
    {
        return 1;
    }
    texture = allegro_gl_make_texture(temp);
    if(!texture)
    {
        return 2;
    }
    return 0;
}  

int level2::load_texture2(char *file)
{
    BITMAP *temp = load_bitmap(file, NULL);
    if(!temp)
    {
        return 1;
    }
    texture2 = allegro_gl_make_texture(temp);
    if(!texture2)
    {
        return 2;
    }
    return 0;
}       

int level2::load(char *file)
{
    char *temp;
    set_config_file(file);
    temp = (char *)get_config_string(NULL, "texture", "");
    if(temp == "")
    {
        return 1;
    }
    if(load_texture(temp))
    {
        return 2;
    }
    temp = (char*)get_config_string(NULL, "texture2", "");
    if(temp == "")
    {
        return 1;
    }
    if(load_texture2(temp))
    {
        return 2;
    }    
    load_door_tex();
    the_cube.set_texture(texture);
    the_cube2.set_texture(texture2);
    start_x = get_config_int(NULL, "start_x", 0);
    start_y = get_config_int(NULL, "start_y", 0);
    win_x = get_config_int(NULL, "win_x", 0);
    win_y = get_config_int(NULL, "win_y", 0);
    width = get_config_int(NULL, "width", 0);
    if(width == 0)
    {
        return 3;
    }
    height = get_config_int(NULL, "height", 0);
    if(height == 0)
    {
        return 4;
    }
    temp = (char *)get_config_string(NULL, "data", "");
    if(temp == "")
    {
        return 5;
    }
    
    int c = 0;
    
    map = new int[width * height];
    
    while(c < width * height)
    {
        if(*(temp + c) == 0)
        {
            return 6;
        }
        else
        {
            if(*(temp + c) == 48)        //char 48 is "0"
            {
                *(map + c) = 0;
            }
            else if(*(temp + c) == 49)            //char 49 is "1"
            {
                *(map + c) = 1;
            }
            else if(*(temp + c) == 50)
            {
                *(map + c) = 2;
            }    
            else
            {
                return 7;
            }
        }
        c++;
    }
    return 0;
}                        
        
    
        
    
    
    
