class game_state
{
public:
    int get_screen_width() {return screen_width;};
    int get_screen_height() {return screen_height;};
    int get_screen_bpp() {return screen_bpp;};
    int get_screen_fullscreen() {return screen_fullscreen;};
    
    void set_screen_width(int to) {screen_width = to;};
    void set_screen_height(int to) {screen_height = to;};
    void set_screen_bpp(int to) {screen_bpp = to;};
    void set_screen_fullscreen(int to) {screen_fullscreen = to;};
    
    int get_debug_mode() {return debug_mode;};
    
    void set_debug_mode(int to) {debug_mode = to;};
    
    int get_depth_buffer_depth() {return depth_buffer_depth;};
    float get_far_clip() {return far_clip;};
    float get_near_clip() {return near_clip;};
    int get_mipmapping() {return use_mipmapping;};
    
    void set_depth_buffer_depth(int to) {depth_buffer_depth = to;};
    void set_far_clip(float to) {far_clip = to;};
    void set_near_clip(float to) {near_clip = to;};
    void set_mipmapping(int to) {use_mipmapping = to;};
    
    int load_from_file(const char *file);
    
    
    
    game_state(const char *file);
    game_state();
    
    
private:
    int screen_width;
    int screen_height;
    int screen_bpp;
    int screen_fullscreen;
    int use_mipmapping;
    
    int debug_mode;
    
    int depth_buffer_depth;
    float far_clip;
    float near_clip;

};

game_state::game_state()
{
    game_state("config.ini");
}    

game_state::game_state(const char *file)
{
	//install allgro and alleggl
	allegro_init();
	install_allegro_gl();
	log_file << "Allegro and AllegroGL installed!" << endl;
	//install all the needed devices
	install_keyboard();
	install_mouse();
	install_timer();
	log_file << "Keyboard mouse and timers installed!" << endl;
    //read_cfg();
    load_from_file(file);
    	log_file << "Read values from config!" << endl;
	//alleggl screen setup 
	allegro_gl_set(AGL_Z_DEPTH, get_depth_buffer_depth());
	allegro_gl_set(AGL_COLOR_DEPTH, get_screen_bpp());
	allegro_gl_set(AGL_DOUBLEBUFFER, 1);
	allegro_gl_set(AGL_SUGGEST, AGL_Z_DEPTH | AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER);
	//allegro_gl_set(AGL_RENDERMETHOD, 1);
	//allegro_gl_set(AGL_REQUIRE, AGL_RENDERMETHOD);
	allegro_gl_flip_texture(0);  
	allegro_gl_use_mipmapping(get_mipmapping());
	set_color_depth(get_screen_bpp()); 
	log_file << "AllegGL settings set" << endl;
	//set the screen mode
	int temp = 0;
	if(get_screen_fullscreen())
	{
	    temp = set_gfx_mode(GFX_OPENGL_FULLSCREEN, get_screen_width(), get_screen_height(), 0, 0);
    	}
    	else
    	{
            temp = set_gfx_mode(GFX_OPENGL_WINDOWED, get_screen_width(), get_screen_height(), 0, 0);
    	}
	if(temp)
    	{
        allegro_message("GFX problem \nERROR:%s\nWidth:%i\nHeight:%i\nBPP:%i\nFULLSCREEN:%i", allegro_error, get_screen_width(), get_screen_height(), get_screen_bpp(), get_screen_fullscreen());
        something_is_really_wrong = true;
    	}	
    	log_file << "Window made, is something wrong?" << something_is_really_wrong << endl;
	//clear it all
	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();							// Reset The Projection Matrix
	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)get_screen_width()/(GLfloat)get_screen_height(),get_near_clip(),get_far_clip());
	glMatrixMode(GL_MODELVIEW);						// Select The Modelview Matrix
	glLoadIdentity();							// Reset The Modelview Matrix
	glShadeModel(GL_SMOOTH);						// Enables Smooth Shading
	glEnable(GL_TEXTURE_2D);						// Enable Texture Mapping
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);        //clear color
	glClearDepth(1.0f);							// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);						// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);							// The Type Of Depth Test To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Really Nice Perspective Calculations
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);  
	log_file << "Open GL settings set!" << endl;
	if(get_debug_mode() == 1)
	{
	   allegro_message("Width:%i\nHeight:%i\nBPP:%i\nFULLSCREEN:%i", get_screen_width(), get_screen_height(), get_screen_bpp(), get_screen_fullscreen());
    }
    
}

int game_state::load_from_file(const char *file)
{
    push_config_state();
    set_config_file(file); 
    //screen
    set_screen_width(get_config_int("screen", "width", 640));
    set_screen_height(get_config_int("screen", "height", 480));
    set_screen_bpp(get_config_int("screen", "bpp", 16));
    set_screen_fullscreen(get_config_int("screen", "fullscreen", 1));
    if(get_screen_bpp() == -1)
    {
        set_screen_bpp(desktop_color_depth());
    }    
    //debug info
    set_debug_mode(get_config_int("debug", "debuglevel", 0));
    
    
    //OpenGL stuff
    set_depth_buffer_depth(get_config_int("opengl", "depth_buffer_depth", 32));
    set_far_clip(get_config_float("opengl", "far_clip", 500.0f));
    set_near_clip(get_config_float("opengl", "near_clip", 0.1f));
    set_mipmapping(get_config_int("opengl", "use_mipmapping", 1));
    
    //constrolls
    
    pop_config_state();
    return 0;
}

