class player
{
public:
    void draw();
    void drop_block();
    void pick_up_block();
    void do_block();
    void move_left();
    void move_right();
    void move_up();
    void do_gravity();
    player(char *ftexture);
    void set_x(float to) {x = to;};
    void set_y(float to) {y = to;};
    float get_x() {return x;};
    float get_y() {return y;};
    int check_win();
    void set_to_start();
    ~player();
private:
    void zero() { x = 0; y = 0; texture = 0; have_block=false; facing_left=true;};
    GLuint texture;
    float x, y;
    bool have_block;
    bool facing_left;
    
};    

player::~player()
{
    log_file << "Player deconstuctor" << endl;
    glDeleteTextures(1, &texture);
}    

void player::set_to_start()
{
    set_y((float)current_map->getstart_y());
    set_x((float)current_map->getstart_x());
}    

int player::check_win()
{
    return current_map->check_win((int)x, (int)y);

}            
void player::do_block()
{
    if(have_block)
    {
        drop_block();
    }
    else if(current_map->check_cord((int)x, (int)y - 1) == 0)
    {
        pick_up_block();
    }
}            

void player::do_gravity()
{
    while(current_map->check_cord((int)x, (int)y + 1)==0)
    {
        y++;
        if(have_block)
        {
            current_map->set_cord((int)x, (int)y - 1, 2);
            current_map->set_cord((int)x, (int)y - 2, 0);
        }    
    }
}        

player::player(char *ftexture)
{
    zero();
    BITMAP *temp = load_bitmap(ftexture, NULL);
    texture = allegro_gl_make_masked_texture(temp);
    if(!texture)
    {
        allegro_message("texture error");
    }    
}

void player::move_up()
{
    if(facing_left)
    {
        if(((current_map->check_cord((int)x + 1, (int)y - 1) == 0)&&(current_map->check_cord((int)x + 1, (int)y) != 0)&&(!have_block))||((current_map->check_cord((int)x + 1, (int)y - 1) == 0)&&(current_map->check_cord((int)x + 1, (int)y) != 0)&&(have_block)&&(current_map->check_cord((int)x + 1, (int)y - 2) == 0)))
        {
            x++;
            y--;
            if(have_block)
            {
                current_map->set_cord((int)x - 1, (int)y, 0);
                current_map->set_cord((int)x, (int)y - 1, 2);
            }    
        }
    }
    else
    {
        if(((current_map->check_cord((int)x - 1, (int)y - 1) == 0)&&(current_map->check_cord((int)x - 1, (int)y) != 0)&&(!have_block))||((current_map->check_cord((int)x - 1, (int)y - 1) == 0)&&(current_map->check_cord((int)x - 1, (int)y) != 0)&&(have_block)&&(current_map->check_cord((int)x - 1, (int)y - 2) == 0)))
        {
            x--;
            y--;
            if(have_block)
            {
                current_map->set_cord((int)x + 1, (int)y, 0);
                current_map->set_cord((int)x, (int)y - 1, 2);
            }  
        }
    }
}            

void player::move_left()
{
    
    facing_left = true;
    if(current_map->check_cord((int)x + 1, (int)y) == 0)
    {
        x++;
        if(have_block)
        {
            if(current_map->check_cord((int)x, (int)y - 1) != 0)
            {
                current_map->set_cord((int)x - 1, (int)y, 2);
                current_map->set_cord((int)x - 1, (int)y - 1, 0);
                have_block = false;
            }
            else
            {    
                current_map->set_cord((int)x, (int)y - 1, 2);
                current_map->set_cord((int)x - 1, (int)y - 1, 0);
            }    
        }    
    }
}

void player::move_right()       
{
    facing_left = false;
    if(current_map->check_cord((int)x - 1, (int)y) == 0)
    {
        x--;
        if(have_block)
        {
            if(current_map->check_cord((int)x, (int)y - 1) != 0)
            {
                current_map->set_cord((int)x + 1, (int)y, 2);
                current_map->set_cord((int)x + 1, (int)y - 1, 0);
                have_block = false;
            }
            else
            {    
                current_map->set_cord((int)x, (int)y - 1, 2);
                current_map->set_cord((int)x + 1, (int)y - 1, 0);
            }  
        }    
    } 
}    

void player::drop_block()
{
    if(have_block)
    {
        int curr = 0;
        if(facing_left)
        {
            if(current_map->check_cord((int)x + 1, (int)y) == 0)
            {
                while(current_map->check_cord((int)x + 1, (int)y + curr + 1) == 0)
                {
                    curr++;
                }    
                current_map->set_cord((int)x + 1, (int)y + curr, 2);
                current_map->set_cord((int)x, (int)y - 1, 0);
                have_block = false;
            }
            else if(current_map->check_cord((int)x + 1, (int)y - 1) == 0)
            {
                current_map->set_cord((int)x + 1, (int)y - 1, 2);
                current_map->set_cord((int)x, (int)y - 1, 0);
                have_block = false;
            }    
        }
        else
        {               
            if(current_map->check_cord((int)x - 1, (int)y) == 0)
            {
                while(current_map->check_cord((int)x - 1, (int)y + curr + 1) == 0)
                {
                    curr++;
                }   
                current_map->set_cord((int)x - 1, (int)y + curr, 2);
                current_map->set_cord((int)x, (int)y - 1, 0);
                have_block = false;
            }
            else if(current_map->check_cord((int)x - 1, (int)y - 1) == 0)
            {
                current_map->set_cord((int)x - 1, (int)y - 1, 2);
                current_map->set_cord((int)x, (int)y - 1, 0);
                have_block = false;
            }    
        }
    }
}            
void player::pick_up_block()
{
    if(!have_block)
    {
        if(facing_left)
        {
            if((current_map->check_cord((int)x + 1, (int)y) == 2)&&(current_map->check_cord((int)x + 1, (int)y - 1) != 2))
            {
                current_map->set_cord((int)x + 1, (int)y, 0);
                current_map->set_cord((int)x, (int)y - 1, 2);
                have_block = true;
            }
        }  
        else
        {
            if((current_map->check_cord((int)x - 1, (int)y) == 2)&&(current_map->check_cord((int)x - 1, (int)y - 1) != 2))
            {
                current_map->set_cord((int)x - 1, (int)y, 0);
                current_map->set_cord((int)x, (int)y - 1, 2);
                have_block = true;
            }
        }
    }
}                      

void player::draw()
{
    float x2, y2;
    current_map->map_to_real(x, y, &x2, &y2);
    glPushMatrix();
    glTranslatef(-x2, -y2, 0);
    //if rotation is needed addd it here
    glEnable(GL_ALPHA_TEST);
    glBindTexture(GL_TEXTURE_2D, texture);
    glBegin(GL_QUADS);
        if(!facing_left)
        {
    		// Front Face
    		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  0.0f);	// Bottom Left Of The Texture and Quad
    		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  0.0f);	// Bottom Right Of The Texture and Quad
    		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  0.0f);	// Top Right Of The Texture and Quad
    		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  0.0f);	// Top Left Of The Texture and Quad
  		}  		
  		else
  		{
 		// Front Face
    		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  0.0f);	// Bottom Left Of The Texture and Quad
    		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  0.0f);	// Bottom Right Of The Texture and Quad
    		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  0.0f);	// Top Right Of The Texture and Quad
    		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  0.0f);	// Top Left Of The Texture and Quad
 		}	  		
	glEnd();
	glDisable(GL_ALPHA_TEST);
	glPopMatrix();
	
}	



void cube::draw()
{
    glPushMatrix();
    glTranslatef(-x, -y, -z);
    //if rotation is needed addd it here
    glBindTexture(GL_TEXTURE_2D, texture);
    glBegin(GL_QUADS);
		// Front Face
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		// Back Face
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		// Top Face
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		// Bottom Face
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		// Right face
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);	// Top Left Of The Texture and Quad
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		// Left Face
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);	// Bottom Left Of The Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);	// Top Right Of The Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);	// Top Left Of The Texture and Quad
	glEnd();
	glPopMatrix();
}

void cube::set_texture(BITMAP *to)
{
    texture = allegro_gl_make_texture(to);
    if(!texture)
    {
        allegro_message("OpenGL texture not uploaded, thats not good!");
        return;
    }      	
}    

void cube::set_texture(int to)
{
    texture = to;
}

void cube::delete_texture()
{
    if(texture)
    {
        glDeleteTextures(1, &texture);
    }   
    texture = 0;
}        
