class button
{
public:
    int check_pressed();
    int update();        //run 60 times a seccond for proper timing
    int poll();
    button(int key, int wait, int rep);
private:
    int key_value;
    int pressed_for;
    int rep_wait_time;
    int rep_time;
    bool reping;
    bool waiting_to_rep;
    bool pressed_last_time;
    bool key_waiting;
};

int button::poll() //call as much as possible
{
    if(key[key_value])
    {
     //   *log_file << "Key pressed, " << key_value << endl;
        key_waiting = true;
    }
    return 0;
}        

int button::update()
{
    if((key_waiting)&&(pressed_last_time))
    {
        pressed_for++;
    }
    if((key_waiting)&&(!pressed_last_time))
    {
        pressed_for = 0;
        pressed_last_time = true;
    }
    if((!key_waiting)&&(pressed_last_time))
    {
        pressed_for = -1;
        pressed_last_time = 0;   
        waiting_to_rep = false;
        reping = false;
    }
    key_waiting = false;
    return 0;
}        

button::button(int key, int wait, int rep)
{
    key_value = key;
    rep_wait_time = wait;
    rep_time = rep;
    pressed_for = -1;
    reping = false;
    waiting_to_rep = false;
    pressed_last_time = false;
    key_waiting = false;
}

int button::check_pressed()
{
    if((reping)&&(pressed_for >= rep_time))
    {
        pressed_for = 0;
        return 1;
    }
    if((!reping)&&(pressed_for >= rep_wait_time)&&(waiting_to_rep))
    {
        reping = true;
        pressed_for = 0;
        return 1;
    }
    if((!reping)&&(pressed_for >= 0)&&(!waiting_to_rep))
    {
        waiting_to_rep = true;
        pressed_for = 0;
      //  *log_file << "Pressed recived, " << key_value << endl;
        return 1;
    }
    return 0;
}        

class input_system
{
public:
    int check_for_button();
    void update();
    void poll();
    //void multiple_button_check();
    void add_button(int key);
private:
    list<button> the_list;
    list<button>::iterator current_location;
};

void input_system::add_button(int key)
{
    the_list.push_back(button(key, 10, 2));
}    

int input_system::check_for_button()
{
    current_location = the_list.begin();
    int number = 0;
    while(current_location != the_list.end())
    {
        if(current_location->check_pressed())
        {
            return number;
        }
        number++;
        current_location++;
    }
    return -1;
}

void input_system::update()
{
    current_location = the_list.begin();
    while(current_location != the_list.end())
    {
        current_location->update();
        current_location++;
    }                
}    

void input_system::poll()
{
    current_location = the_list.begin();
    while(current_location != the_list.end())
    {
        current_location->poll();
        current_location++;
    }                
}    
