/***********************************************************************/
/* Libreria GNU que activa y desactiva la linea RTS en WIN32           */
/* Autor: Jaime Jose Gavin Sierra    Alias: JJ   Libreria: serie v1.0  */
/* Correo: jaimejj@mixmail.com                                         */
/* Web: http://www.lanzadera.com/ensamblador                           */
/* Asturias (Espaa)                                                   */
/* Opciones: ON, OFF, NULL                                             */
/* Para generarla:                                                     */
/*  gcc -c serie.c                                                     */
/*  ar rvs libserie.a serie.o                                          */
/* Y para usarla gcc programa.c libserie.a                             */
/***********************************************************************/
#include <windows.h>

HANDLE hcom;


void InicializaPuertoSerieWin(short int num_puerto);
void AccionPuertoSerieWin(short int activar);
void EliminaPuertoSerieWin();

/***************************************************/
void InicializaPuertoSerieWin(short int num_puerto){
 switch (num_puerto){
  case 1: hcom = CreateFile("COM1",GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0); break;
  case 2: hcom = CreateFile("COM2",GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0); break;
  case 3: hcom = CreateFile("COM3",GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0); break;
  case 4: hcom = CreateFile("COM4",GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0); break;
 }
}

/*****************************************************/
void AccionPuertoSerieWin(short int activar){
 if (hcom!=INVALID_HANDLE_VALUE){
  if (activar==1)
   EscapeCommFunction(hcom,SETRTS);
  else
   EscapeCommFunction(hcom,CLRRTS);
 }
}

/*****************************************************/
void EliminaPuertoSerieWin(void){
 if (hcom!=INVALID_HANDLE_VALUE)
  CloseHandle(hcom);
}
