/**************************************************************************/
/* Programa para meter efectos sonoros en emisora de radio CB o superior  */
/* Autor: Jaime Jose Gavin Sierra    Alias: JJ   Programa: PTT sound v1.1 */
/* Correo: jaimejj@mixmail.com                                            */
/* Web: http://www.lanzadera.com/ensamblador                              */
/* Asturias (Espaa)                                                      */
/* Este programa pertenece a la licencia GNU.                             */
/* Para la imagen del micro, no se ha usado una paleta de colores, para   */
/* simplificar en tamanio y velocidad. Por tanto, se ha reducido a 2      */
/* colores, de los cuales el negro es el indice 0 y el blanco el 15, es   */
/* decir, se ha preparado con un programa de dibujo.                      */
/* Se ha optado por la utilidad dat2c para generar codigo C portable de la*/
/* foto del micro, de la forma: dat2c micro.dat -h micro.h -o micro.c     */
/* Luego se puede compilar con: gcc -s -O6 ptt.c -optt.exe -lalleg -ldzcom*/
/* Pero antes hay que incluir el micro.h y micro.c                        */
/* Otra opcion seria generar codigo fuente en ensambla, con la utilidad   */
/* dat2s, de la siguiente forma: dat2s micro.pcx -h micro.h -o micro.s    */
/* Y luego se compila, de esta forma:  gcc -c micro.s                     */
/* Esto genera un modulo objeto micro.o, de tal forma que el programa PTT */
/* se compilara:  gcc -s -O6 ptt.c -o ptt.exe micro.o -ldzcom -lalmp3     */
/*                -lalmp3 -lalogg -ljgmod -lalleg                         */
/* Caracteristicas:                                                       */
/*  Solo reproduce 1 MP3 y 1 OGG a la vez para optimizar en CPU           */
/*  Permite repruduccion de multiples SAMPLES, o SAMPLES con un MP3 u OGG */
/*  Se puede elegir uno de los 4 puertos COM, para abrir o cerrar Pastilla*/
/*  Se admite la opcion de manos libres VOX                               */
/*  Mientras el ROGER BEEP este sonando, no se libera la pastilla (PTT)   */
/*  Es portable con PTT bajo DOS y WIN32. Y sin PTT (VOX) para BeOS, LINUX*/
/*  y QNX                                                                 */
/*  Los modos de video que soporta, son:                                  */
/*   VGA   --> 320 x 200 x 8 bits                                         */
/*   VGAX  --> 320 x 240 x 8 bits (modos X)                               */
/*   SVGA  --> 640 x 480 x 8 bits                                         */
/*  Por defecto usa el puerto COM2, y si no queremos usar puerto COM, se  */
/*  puede optar por la opcion NULL de parametros.                         */
/*  Si se ejecuta el PTT sin parametros,nos carga un mensaje con opciones */
/*  Para DOS, se ha usado el DJGPP.                                       */
/*  Para WIN32, el MINGW32                                                */
/*  Para LINUX, BeOS y QNX, el GCC de toda la vida                        */
/*  Para DOS y WIN32 se ha usado el compresor UPX -9 PTT.EXE y la DLL     */
/*  Bajo LINUX tambin se puede usar                                      */
/*  Soporte de MP3, OGG para DOS, WINDOWS y LINUX                         */
/*  Soporte de MOD para DOS, WINDOWS, LINUX y BeOS                        */
/*  Bajo WIN32 y DOS se ha incluido Setup, en el resto, no, ya que hay que*/
/*  recompilar algunas cosas desde las librerias de ALLEGRO               */
/*  Se ha usado la libreria DZCOM, pero la linea RTS en WIN32 no tira     */
/*  Se ha usado la funcion strcasecmp, no ANSI ni POSIX                   */
/*  Se han puerto dos formas de compilar:                                 */
/*   MODO_VIEJO  -->  DOS con acceso al puerto serie directo              */
/*   MODO_NUEVO  -->  DOS con acceso al puerto serie con DZCOMM           */
/**************************************************************************/



#include <allegro.h>
#include <almp3.h> //Soporte de MP3 para DOS, WIN32 y LINUX
#include <alogg.h>

//#define MODO_VIEJO //El tradicional
#define MODO_NUEVO

#ifdef MODO_NUEVO
 #ifdef ALLEGRO_DOS
  #define DZCOMM_SECUNDARY_INCLUDE
  #include <dzcomm.h>
  comm_port * puertoRS232;
 #endif
#endif

#include <stdio.h>
#ifdef ALLEGRO_DOS
 #include "optimiza.c"
 #define SETUP_EMBEDDED
 #define SETUP_TITLE "Configuracion PTT Sound v1.0"
 #define SETUP_CFG_FILE "allegro.cfg"
 #include "setup/setup.c"
#endif

#ifdef ALLEGRO_WINDOWS
 #define SETUP_EMBEDDED
 #define SETUP_TITLE "Configuracion PTT Sound v1.0"
 #define SETUP_CFG_FILE "allegro.cfg"
 #include "setup/setup.c"
#endif


#include "micro.h"   //Para sacar cabecera de la foto del micro y portada
#include "micro.c"   //Para sacar cabecera de la foto del micro y portada

#define max_sonidos 450
#define max_columnas 9
#define max_filas 50
#define max_sonidos_beep 49
#define max_columnas_beep 7
#define max_filas_beep 7
#define boolean char
#define inc_x 15
#define inc_y 80
#define separacion_fila 8
#define max_sonidos_dat 65
#define max_beep_dat 5

enum TPuerto {COM1=1,COM2=2,COM3=3,COM4=4,NULO=5};
enum TTipoSonido {sonido_WAV=1, sonido_MP3=2, sonido_OGG=3};
enum TModoVideo {video_vga=1, video_vgax=2, video_svga=3};

typedef struct{
 //unsigned short int numMP3; //total MP3 por ahora inactivo
 ALMP3_MP3 *sonidoMP3;
 int estaSonando; //Dice si esta sonando o no
}TlistaMP3;

typedef struct{
 //unsigned short int numOGG; //total OGG por ahora inactivo
 ALOGG_OGG *sonidoOGG;
 int estaSonando; //Dice si esta sonando o no
}TlistaOGG;


typedef struct{
 char nombreSonido[9];   //Nombre del SAMPLE en la tabla de SAMPLES
// char * nombreArchivo; //El nombre real del archivo en fichero o en DAT
 boolean memoria;        //Dice si esta en archivo DAT o no (en fichero .wav)
 enum TTipoSonido tipo;  //Dice el tipo de Sonido, MOD, XM, MP3, OGG, WAV
 SAMPLE *sonido;         //El puntero al archivo de sonido
 ALMP3_MP3 *sonidoMP3;   //El puntero al archivo MP3
 ALOGG_OGG *sonidoOGG;   //El puntero al archivo MP3
 unsigned char * punteroDatos; //El puntero a un buffer de datos
}TSonido;

TSonido listaSonidos[max_sonidos];   //Lista de efectos sonoros
TSonido listaBeep[max_sonidos_beep]; //Lista de Roger Beep


short int filaActualSonido, columnaActualSonido;
short int filaActualBeep, columnaActualBeep;
boolean tabulador=FALSE; //Si estamos en los SAMPLES o en el ROGER-BEEP
DATAFILE *sonidos_dat, *beep_dat; //Los DAT de los SAMPLES
char puerto_com = COM2;           //El COM2 por defecto
SAMPLE *beep; //Contiene el puntero al SAMPLE del roger beep
int voz_beep; //Contiene un indice a la voz del roger beep que esta sonando
int valorRaton;
int color_blanco, color_verde, color_negro, color_naranja; //Colores precalculados
boolean lineaRTS = FALSE;   //Si se ha activado la linea RTS del RS-232
boolean roger_beep = FALSE; //Si tengo activo la opcion de roger beep
boolean roger_beep_sonando = FALSE; //Si esta sonando el roger_beep
boolean raton = FALSE; //Si poseemos raton o no
short int i, volumenActual=195;
boolean parametroSetup = FALSE;
boolean parametroPortada = TRUE;
short int sonidoActual=0; //El sonido actual que suena para poder pararlo
short int totalSonidosCargados = 0;
short int repetirSAMPLE = FALSE;

TlistaMP3 listaMP3; //La lista de MP3
TlistaOGG listaOGG; //La lista de OGG

enum TModoVideo modoVideo;
short int pantallaX = 640;
short int pantallaY = 480;
short int palancaJuegos = FALSE;

volatile tiempo;

void InicializaColores(void);
void InicializaSonidos(void);
void BorraSonidos(void);
void MuestraMatrizSonidos(void);
void MuestraMatrizRogerBeep(void);
void Controla_Eventos(void);
void ControlaEventoTeclado(boolean * salir);
void ControlaEventoRaton(boolean * salir);
void ControlaEventoJoystick(boolean * salir);
void PuertoSerie(enum TPuerto numero, boolean activar);
void MuestraAyuda(void);
void CargarArchivosINI(void);
void MuestraVolumenSonido(void);
void AccionRepetirSample(void);
void inc_tiempo();
#ifdef MODO_NUEVO
 #ifdef ALLEGRO_DOS
  void InicializaPuertoSerie(enum TPuerto numero);
  void EliminarPuertoSerie(void);
 #endif
#endif

int main(int argc, char **argv){
 allegro_init();
 set_uformat(U_ASCII);

 if (argc<=1){
  MuestraAyuda();
  allegro_exit();
  return (0);
 }

 for (i=1;i<argc;i++){
  if ((strcmp(argv[i],"COM1")==0)||(strcmp(argv[i],"com1")==0)) puerto_com = COM1;
  if ((strcmp(argv[i],"COM2")==0)||(strcmp(argv[i],"com2")==0)) puerto_com = COM2;
  if ((strcmp(argv[i],"COM3")==0)||(strcmp(argv[i],"com3")==0)) puerto_com = COM3;
  if ((strcmp(argv[i],"COM4")==0)||(strcmp(argv[i],"com4")==0)) puerto_com = COM4;
  if ((strcmp(argv[i],"NULL")==0)||(strcmp(argv[i],"null")==0)) puerto_com = NULO;
  if ((strcmp(argv[i],"SETUP")==0)||(strcmp(argv[i],"setup")==0)) parametroSetup = TRUE;
  if ((strcmp(argv[i],"NO")==0)||(strcmp(argv[i],"no")==0)) parametroPortada = FALSE;
  if ((strcmp(argv[i],"VGA")==0)||(strcmp(argv[i],"vga")==0)) modoVideo = video_vga;
  if ((strcmp(argv[i],"VGAX")==0)||(strcmp(argv[i],"vgax")==0)) modoVideo = video_vgax;
  if ((strcmp(argv[i],"SVGA")==0)||(strcmp(argv[i],"svga")==0)) modoVideo = video_svga;
 }

 #ifdef MODO_NUEVO
  #ifdef ALLEGRO_DOS
   InicializaPuertoSerie(puerto_com);
  #endif
 #endif
 
 install_keyboard();      //Instalo el teclado
 install_timer();         //Para poder mostrar raton activo el timer 
 valorRaton = install_mouse(); //Instalo el raton
 if ((valorRaton==0)||(valorRaton==-1)) raton=FALSE;
 else raton = TRUE;


 
 if (install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL)==-1){
  allegro_message("Error en driver sonido\n");
  allegro_exit();
  exit(-1);
 }

 set_volume(volumenActual,volumenActual);
 set_window_title("PTT sound v1.0");

 if (install_joystick(JOY_TYPE_AUTODETECT)==0){
  if (!num_joysticks) palancaJuegos = FALSE;
  else palancaJuegos = TRUE;
 }
 else palancaJuegos = FALSE;

 switch (modoVideo){
  case video_vga: pantallaX = 320; pantallaY = 200; break;
  case video_vgax: pantallaX = 320; pantallaY = 240; break;
  case video_svga: pantallaX = 640; pantallaY = 480; break;
 }
 
 if (parametroSetup == TRUE){
  set_color_depth(8);
  if (set_gfx_mode(GFX_AUTODETECT,pantallaX,pantallaY,0,0)!=0){
   if (set_gfx_mode(GFX_SAFE,pantallaX,pantallaY,0,0)!=0){
    allegro_message("Error en MODO DE VIDEO\n");
    allegro_exit();
    exit(-1);
   }
  }

  #ifdef ALLEGRO_DOS
   return setup_main();
   allegro_exit();
   exit(0);
  #endif
  #ifdef ALLEGRO_WINDOWS
   return setup_main();
   allegro_exit();
   exit(0);  
  #endif  
 }

 if (parametroPortada == TRUE){
  set_color_depth(8);
  if (set_gfx_mode(GFX_AUTODETECT,320,200,0,0)!=0){
   if (set_gfx_mode(GFX_SAFE,320,200,0,0)!=0){
    allegro_message("Error en MODO DE VIDEO\n");
    allegro_exit();
    exit(-1);
   }
  }

  clear_to_color(screen,makecol(255,255,255));
  blit(&foto_portada,screen,0,0,45,4,foto_portada.w,foto_portada.h);//Muestro portada GNU
 }

 sonidos_dat = load_datafile("sonidos.dat");
 beep_dat = load_datafile("beep.dat");

 if (parametroPortada == TRUE){
  rest(1000);
  fade_out(1);
 }

 
 if (set_gfx_mode(GFX_AUTODETECT,pantallaX,pantallaY,0,0)!=0){
  if (set_gfx_mode(GFX_SAFE,pantallaX,pantallaY,0,0)!=0){
   allegro_message("Error en MODO DE VIDEO\n");
   allegro_exit();
   exit(-1);
  }
 }


 InicializaColores();

 if (raton==TRUE) show_mouse(screen);   //Mostrar el raton
  
 InicializaSonidos();
 MuestraMatrizSonidos();
 MuestraMatrizRogerBeep();
 MuestraVolumenSonido();
 if (raton==TRUE) show_mouse(NULL);
  if (tabulador==FALSE)
   if (pantallaX == 640)
    textout_ex(screen,font," SONIDOS ",560,0,color_blanco,color_naranja);
   else
    textout_ex(screen,font,"SONI",280,0,color_blanco,color_naranja);
  if (roger_beep==FALSE)
   if (pantallaX == 640)
    textout_ex(screen,font," BEEP OFF ",555,20,color_blanco,color_naranja);
   else
    textout_ex(screen,font,"B OF",277,20,color_blanco,color_naranja);
  if (lineaRTS==FALSE)
   if (pantallaX == 640)
    textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
   else
    textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
 if (raton==TRUE) show_mouse(screen);

 //line(screen,500,inc_y_beep+10,599,inc_y_beep+70,color_blanco);
 Controla_Eventos();

// while (!keypressed());


 set_gfx_mode(GFX_TEXT,640,480,0,0);


 if (roger_beep_sonando == TRUE){
  voice_stop(voz_beep);
  deallocate_voice(voz_beep);
 }

 if (lineaRTS==TRUE) PuertoSerie(puerto_com,FALSE);


 #ifdef MODO_NUEVO
  #ifdef ALLEGRO_DOS
   if (puerto_com != NULO)
    EliminarPuertoSerie();
  #endif
 #endif
  
 remove_sound();
 if (raton==TRUE) remove_mouse();
 remove_timer; 
 remove_keyboard();

 BorraSonidos();
 unload_datafile(sonidos_dat);
 unload_datafile(beep_dat);

 
 allegro_exit();
 

 return (0);
}
END_OF_MAIN();



/*****************************************/
void InicializaColores(void){
//Para optimizar un poco se calculan los colores para luego usar
 color_blanco = makecol(255,255,255);
 color_verde =  makecol(20,255,10);
 color_negro = makecol(0,0,0);
 color_naranja = makecol(255,128,0);
}

/*****************************/
void inc_tiempo(){
 tiempo++;
}
END_OF_FUNCTION(inc_tiempo);

/*****************************************/
void InicializaSonidos(void){
/*Inicializa la lista de efectos sonoros y de Roger Beep
  Lee los que se encuentran dentro del archivo sonidos.dat y beep.dat,y activa
  la variable memoria, ya que a la hora de borrar, no son mas que punteros,
  por lo que no tienen memoria asignada, sino que se igualan a la zona
  del DATAFILE *
  Si no se encuentra en el DAT, pone esta variable a FALSE, y pone el nombre
  del archivo en nombreArchivo.
  La forma de leerlos del DAT es bastante cutre,ya que por un lado tenemos los
  SAMPLES y en la ultima posicion el TEXTO_SONIDO que contiene los nombres que
  se van a poner en los efectos de sonido y en el rogerbeep. Asi que es mejor
  no tocarlo. El TEXTO_SONIDO se podia enconctrar con find_datafile_object,
  pero he decidido que sea el ultimo objeto en el DAT, asi que accedo
  directamente. Asi que cuidado con los cambios.
*/

 short int i,j,cont,contCad;
 char car;
 char cadena[max_sonidos_dat][9];
 unsigned char *auxPuntero;
 char cadAux[100];
 int topeCad;
 
 if (pantallaX == 640) topeCad = 8;
 else topeCad = 4;
 //Para los MP3 activos
 listaMP3.sonidoMP3 = NULL;
 listaMP3.estaSonando = FALSE;

 //Para los MP3 inactivos
 listaOGG.sonidoOGG = NULL;
 listaOGG.estaSonando = FALSE;


 for (i=0;i<max_sonidos_dat;i++)
  cadena[i][0] = '\0';
 cadAux[0] = '\0';
  
 for (i=0;i<max_sonidos;i++){
  if (pantallaX == 640) strcpy(listaSonidos[i].nombreSonido,"--------");
  else strcpy(listaSonidos[i].nombreSonido,"----");
  listaSonidos[i].memoria = FALSE;
//  listaSonidos[i].nombreArchivo = NULL;
  listaSonidos[i].tipo = sonido_WAV;
  listaSonidos[i].sonido = NULL;
  listaSonidos[i].sonidoMP3 = NULL;
  listaSonidos[i].sonidoOGG = NULL;
  listaSonidos[i].punteroDatos = NULL;
 }


 if (sonidos_dat!=NULL){
  auxPuntero = sonidos_dat[max_sonidos_dat].dat;
  j=0;
  cont=0;
  contCad=0;
  while (j<(sonidos_dat[max_sonidos_dat].size)){
   car = auxPuntero[j];
   if (car!=13){
    if (car!=10){
     cadAux[cont] = car;
     cont++;
    }
   }
   else{
    if (cont>topeCad) cadAux[topeCad] = '\0';
    else cadAux[cont] = '\0';
    cont = 0;
    strcpy(cadena[contCad],cadAux);
    contCad++;
   }
   j++;
  }
 
  for (i=0;i<max_sonidos_dat;i++){//Cargamos los del archivo DAT
   strcpy (listaSonidos[i].nombreSonido,cadena[i]);
   listaSonidos[i].memoria = TRUE;   
   listaSonidos[i].sonido = sonidos_dat[i].dat;
 //  listaSonidos[i].nombreArchivo = malloc(10);
 //  strcpy(listaSonidos[i].nombreArchivo,"");
  }
 }

 for (i=0;i<max_sonidos_beep;i++){
  if (pantallaX == 640) strcpy(listaBeep[i].nombreSonido,"--------");
  else strcpy(listaBeep[i].nombreSonido,"----");
  listaBeep[i].memoria = FALSE;
//  listaBeep[i].nombreArchivo = NULL;
  listaBeep[i].tipo = sonido_WAV;
  listaBeep[i].sonido = NULL;
  listaBeep[i].sonidoMP3 = NULL;
  listaBeep[i].sonidoOGG = NULL;
  listaBeep[i].punteroDatos = NULL;
 }

 for (i=0;i<max_beep_dat;i++)
  cadena[i][0] = '\0';
 cadAux[0] = '\0';

 if (beep_dat!=NULL){
  auxPuntero = beep_dat[max_beep_dat].dat;
  j=0;
  cont=0;
  contCad=0;
  while (j<(beep_dat[max_beep_dat].size)){
   car = auxPuntero[j];
   if (car!=13){
    if (car!=10){
     cadAux[cont] = car;
     cont++;
    }
   }
   else{
    if (cont>topeCad) cadAux[topeCad] = '\0';
    else cadAux[cont] = '\0';
    cont = 0;
    strcpy(cadena[contCad],cadAux);
    contCad++;
   }
   j++;
  }

  for (i=0;i<max_beep_dat;i++){//Cargamos los del archivo DAT
   strcpy (listaBeep[i].nombreSonido,cadena[i]);
   listaBeep[i].memoria = TRUE;
   listaBeep[i].sonido = beep_dat[i].dat;
  }
 }

 CargarArchivosINI(); //Llamo a los INI de sonidos extras
}

/*****************************************/
void BorraSonidos(void){
/* Hace lo contrario que inicializa. Se encarga de eliminar aquellos SAMPLES
   a los cuales se ha reservado memoria. Si tienen la variable memoria activa
   no se borran, ya que solo apuntan al SAMPLE del archivo DAT, y por tanto
   se borraria ese SAMPLE.
   Al igual que el anterior caso, se usan variables globales, para no pasar
   parametros por pila, ya que en este caso, son basicos
*/
 short int i;

 listaOGG.sonidoOGG = NULL;
 listaOGG.estaSonando = FALSE;
 listaMP3.sonidoMP3 = NULL;
 listaMP3.estaSonando = FALSE;
 
 for (i=0;i<max_sonidos;i++){
  if (listaSonidos[i].memoria == FALSE){
//   if (listaSonidos[i].nombreArchivo!=NULL) free(listaSonidos[i].nombreArchivo);
   if (listaSonidos[i].sonido!=NULL) destroy_sample(listaSonidos[i].sonido);
   if (listaSonidos[i].sonidoMP3!=NULL) almp3_destroy_mp3(listaSonidos[i].sonidoMP3);
   if (listaSonidos[i].sonidoOGG!=NULL) alogg_destroy_ogg(listaSonidos[i].sonidoOGG);
   if (listaSonidos[i].punteroDatos!=NULL) free(listaSonidos[i].punteroDatos);
  }
//  listaSonidos[i].nombreArchivo = NULL;
  listaSonidos[i].sonido = NULL;
  listaSonidos[i].sonidoMP3 = NULL;
  listaSonidos[i].sonidoOGG = NULL;
  listaSonidos[i].punteroDatos = NULL;
  listaSonidos[i].memoria = FALSE;
  strcpy(listaSonidos[i].nombreSonido,"--------");
 }
 
 for (i=0;i<max_sonidos_beep;i++){
  if (listaBeep[i].memoria == FALSE){
//   if (listaBeep[i].nombreArchivo!=NULL) free(listaBeep[i].nombreArchivo);
   if (listaBeep[i].sonido!=NULL) destroy_sample(listaBeep[i].sonido);
   if (listaBeep[i].sonidoMP3!=NULL) almp3_destroy_mp3(listaBeep[i].sonidoMP3);
   if (listaBeep[i].sonidoOGG!=NULL) alogg_destroy_ogg(listaBeep[i].sonidoOGG);
   if (listaBeep[i].punteroDatos!=NULL) free(listaBeep[i].punteroDatos);
  }
//  listaBeep[i].nombreArchivo = NULL;
  listaBeep[i].sonido = NULL;
  listaBeep[i].sonidoMP3 = NULL;
  listaBeep[i].sonidoOGG = NULL;
  listaBeep[i].punteroDatos = NULL;
  listaBeep[i].memoria = FALSE;
  strcpy(listaBeep[i].nombreSonido,"--------");
 }
 
}

/*****************************************/
void MuestraMatrizSonidos(void){
//Muestra todos los sample, es decir sonidos, pero de forma optimizada 640x480
//Para modificarlo, se debe de hacer una forma generica
 short int i,j,auxj,auxj2,auxX,incrementaX;
 
 if (pantallaX == 640) incrementaX = 69;
 else incrementaX = 33;
 if (raton==TRUE) show_mouse(NULL);
 for (j=0;j<max_filas;j++){
  auxj = inc_y+(j<<3); //Lo mismo que auxj = inc_y + (j*8)
  auxj2 = (j<<3)+j; //Lo mismo que auxj2 = j*9
  auxX = inc_x;
  for (i=0;i<max_columnas;i++){
   textout(screen,font,listaSonidos[auxj2+i].nombreSonido,(auxX+i),auxj,color_blanco);
   auxX = auxX + incrementaX;
  }
 }
 textout_ex(screen,font,listaSonidos[0].nombreSonido,inc_x,inc_y,color_blanco,color_verde);
 if (raton==TRUE) show_mouse(screen);
}

/*****************************************/
void MuestraMatrizRogerBeep(void){
//Para los sonidos del Roger Beep optimzado para 640x480
//Para forma generica, hay que modificar
 short int i,j,auxj,auxj2,auxX,incrementaX;

 if (pantallaX==640) incrementaX = 69;
 else incrementaX = 33;
 if (raton==TRUE) show_mouse(NULL);
 for (j=0;j<max_filas_beep;j++){
  auxj = (j<<3);    //lo mismo que auxj = j * 8
  auxj2 = (j<<2)+(j<<1)+j; //lo mismo que auxj2 = j * 7
  auxX = inc_x;
  for (i=0;i<max_columnas_beep;i++){
   textout(screen,font,listaBeep[auxj2+i].nombreSonido,(auxX+i),auxj,color_blanco);
   auxX = auxX + incrementaX;
  }
 }
 textout_ex(screen,font,listaBeep[0].nombreSonido,inc_x,0,color_blanco,color_verde);
 if (raton==TRUE) show_mouse(screen);
}

/*****************************************/
void Controla_Eventos(void){
/* Se encraga de controlar los eventos, ya sea via teclado o raton, asi como
   tomar decisiones. Se podria poner el control de joystick, pero cuidado,
   ya que no suele funcionar muy bien
*/
 boolean salir=FALSE;
 int ratonX=0,ratonY=0;    //Para los mickeys del raton
 int ratonZantes, auxFila, auxColumna, auxFilaBeep, auxColumnaBeep, aux;
 short int separacion_columna;
 short int estado;

 if (pantallaX == 640) separacion_columna = 70;
 else separacion_columna = 34;
 
 ratonZantes = mouse_z;
 auxFila = filaActualSonido;
 auxColumna = columnaActualSonido;
 auxFilaBeep = filaActualBeep;
 auxColumnaBeep = columnaActualBeep;
 while (!salir){
  if (listaMP3.estaSonando){
    estado = almp3_poll_mp3(listaMP3.sonidoMP3);
    if ((estado != ALMP3_OK) && (estado != ALMP3_POLL_FRAMECORRUPT)){
     listaMP3.estaSonando = FALSE;
     almp3_stop_mp3(listaMP3.sonidoMP3);
    }
  }

  if (listaOGG.estaSonando){
    estado = alogg_poll_ogg(listaOGG.sonidoOGG);
    if ((estado != ALOGG_OK) && (estado != ALOGG_POLL_FRAMECORRUPT)){
     listaOGG.estaSonando = FALSE;
     alogg_stop_ogg(listaOGG.sonidoOGG);
    }
  }
  
  ControlaEventoTeclado(&salir);
  ControlaEventoRaton(&salir);
  ControlaEventoJoystick(&salir);
//  ControlaEventoJoystick();
  if ((filaActualSonido!=auxFila)||(columnaActualSonido!=auxColumna)){
   if (raton==TRUE) show_mouse(NULL);
    aux = (auxFila*max_columnas)+auxColumna;
    textout_ex(screen,font,listaSonidos[aux].nombreSonido,(inc_x+(auxColumna*separacion_columna)),inc_y+(auxFila*separacion_fila),color_blanco,color_negro);
    aux = (filaActualSonido*max_columnas)+columnaActualSonido;
    textout_ex(screen,font,listaSonidos[aux].nombreSonido,(inc_x+(columnaActualSonido*separacion_columna)),inc_y+(filaActualSonido*separacion_fila),color_blanco,color_verde);
    auxFila = filaActualSonido;
    auxColumna = columnaActualSonido;
   if (raton==TRUE) show_mouse(screen);
  }

  if ((filaActualBeep!=auxFilaBeep)||(columnaActualBeep!=auxColumnaBeep)){
   if (raton==TRUE) show_mouse(NULL);
    aux = (auxFilaBeep*max_columnas_beep)+auxColumnaBeep;
    textout_ex(screen,font,listaBeep[aux].nombreSonido,(inc_x+(auxColumnaBeep*separacion_columna)),(auxFilaBeep*separacion_fila),color_blanco,color_negro);
    aux = (filaActualBeep*max_columnas_beep)+columnaActualBeep;
    textout_ex(screen,font,listaBeep[aux].nombreSonido,(inc_x+(columnaActualBeep*separacion_columna)),(filaActualBeep*separacion_fila),color_blanco,color_verde);
    auxFilaBeep = filaActualBeep;
    auxColumnaBeep = columnaActualBeep;
   if (raton==TRUE) show_mouse(screen);
  }

  if (roger_beep_sonando==TRUE){
   if (voice_get_position(voz_beep)==-1){   
    deallocate_voice(voz_beep);
    roger_beep_sonando = FALSE;
    if (raton==TRUE) show_mouse(NULL);
     if (pantallaX == 640){
      textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
      rectfill(screen,505,0,505+44,70,color_negro);
     }
     else{
      textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
      rectfill(screen,252,0,252+22,70,color_negro);
     }
    if (raton==TRUE) show_mouse(screen);
    PuertoSerie(puerto_com,FALSE); //La desactivo
    lineaRTS = FALSE;    
   }
  }
 }
}

/*****************************************/
void ControlaEventoRaton(boolean *salir){
int ratonZahora;
short int aux;
short int separacion_columna;
short int topeBeep;

if (pantallaX == 640){
 topeBeep = 500;
 separacion_columna = 70;
}
else{
 topeBeep = 250;
 separacion_columna = 34;
}
 
 if (raton){
//   get_mouse_mickeys(ratonX,ratonY);
   if (mouse_b & 1){//Activar el boton izquierdo
     if ((mouse_y>=0)&&(mouse_y<54)&&(mouse_x>=inc_x)&&(mouse_x<topeBeep)){
       filaActualBeep = (mouse_y/8);
       columnaActualBeep = ((mouse_x-inc_x)/separacion_columna);
       if (columnaActualBeep > max_columnas_beep) columnaActualBeep = max_columnas_beep;
       else
        if (columnaActualBeep<0) columnaActualBeep = 0;
       if (filaActualBeep > max_filas_beep) filaActualBeep = max_filas_beep;
        else
         if (filaActualBeep<0) filaActualBeep = 0;
     }
     if ((mouse_y>=inc_y)&&(mouse_y<pantallaY)&&(mouse_x>=inc_x)&&(mouse_x<pantallaX)){     
       filaActualSonido = (mouse_y/8)-(inc_y/8);
       columnaActualSonido = ((mouse_x-inc_x)/separacion_columna);
       if (filaActualSonido > max_filas) filaActualSonido = max_filas;
       else
        if (filaActualSonido<0) filaActualSonido = 0;
       if (columnaActualSonido > max_columnas) columnaActualSonido = max_columnas;
       else
        if (columnaActualSonido<0) columnaActualSonido = 0;
     }
   }

   if (mouse_b & 2){//Activar el boton derecho
    while (mouse_b & 2);
    aux = (filaActualSonido * max_columnas) + columnaActualSonido;
    sonidoActual = aux; //El sonido que va a sonar
    switch (listaSonidos[aux].tipo){
     case sonido_WAV: if (listaSonidos[aux].sonido != NULL)
                       play_sample(listaSonidos[aux].sonido,255,128,1000,repetirSAMPLE);
                      break;
     case sonido_MP3: if (listaMP3.estaSonando==FALSE){
                       if (listaSonidos[aux].sonidoMP3 != NULL){
                        almp3_play_ex_mp3(listaSonidos[aux].sonidoMP3,32768,255,128,1000,repetirSAMPLE);
                        listaMP3.sonidoMP3 = listaSonidos[aux].sonidoMP3;
                        listaMP3.estaSonando = TRUE;
                       }
                      }
                      break;
     case sonido_OGG: if (listaOGG.estaSonando==FALSE){
                       if (listaSonidos[aux].sonidoOGG != NULL){
                        alogg_play_ex_ogg(listaSonidos[aux].sonidoOGG,32768,255,128,1000,repetirSAMPLE);
                        listaOGG.sonidoOGG = listaSonidos[aux].sonidoOGG;
                        listaOGG.estaSonando = TRUE;
                       }
                      }
                      break;
    }
   }   
 }
   
/*     if (menuArticulosDesplegado==FALSE){
       if (menuBuscar==FALSE){
        if (*ratonY>0) ScrollArriba();
        if (*ratonY<0) ScrollAbajo();
       }
     }
     else{
      if (menuBuscar==FALSE){
        if (*ratonY>0) ScrollAbajoArticulos(&losArticulos,letras);
        if (*ratonY<0) ScrollArribaArticulos(&losArticulos,letras);
      }
     }*/
}

/*****************************************/
void ControlaEventoTeclado(boolean * salir){
//Se encarga de controlar el teclado
 int scancode;
 short int aux,i;
 if (keypressed()){
  scancode = readkey()>>8;
  switch (scancode){
   case KEY_ESC: *salir = TRUE; break;
   case KEY_RIGHT: if ((columnaActualSonido<(max_columnas-1))&&(tabulador==FALSE)) columnaActualSonido++;
                   if ((columnaActualBeep<(max_columnas_beep-1))&&(tabulador==TRUE)) columnaActualBeep++;
                   break;
   case KEY_LEFT: if ((columnaActualSonido>0)&&(tabulador==FALSE)) columnaActualSonido--;
                  if ((columnaActualBeep>0)&&(tabulador==TRUE)) columnaActualBeep--;
                  break;
   case KEY_DOWN: if ((filaActualSonido<(max_filas-1))&&(tabulador==FALSE)) filaActualSonido++;
                  if ((filaActualBeep<(max_filas_beep-1))&&(tabulador==TRUE)) filaActualBeep++;
                  break;
   case KEY_UP: if ((filaActualSonido>0)&&(tabulador==FALSE)) filaActualSonido--;
                if ((filaActualBeep>0)&&(tabulador==TRUE)) filaActualBeep--;
                break;
   case KEY_TAB: if (tabulador==TRUE){
                   tabulador = FALSE; //Para navegar por los sonidos
                   if (raton==TRUE) show_mouse(NULL);
                    if (pantallaX == 640)
                     textout_ex(screen,font," SONIDOS ",560,0,color_blanco,color_naranja);
                    else
                     textout_ex(screen,font,"SONI",280,0,color_blanco,color_naranja);
                   if (raton==TRUE) show_mouse(screen);
                 }
                 else{
                   tabulador = TRUE;  //Para navegar por el Roger beep
                   if (raton==TRUE) show_mouse(NULL);
                    if (pantallaX == 640)
                     textout_ex(screen,font," R-BEEP  ",560,0,color_blanco,color_naranja);
                    else
                     textout_ex(screen,font,"RBEP",280,0,color_blanco,color_naranja);
                   if (raton==TRUE) show_mouse(screen);
                 }
                 break;
   case KEY_ENTER: aux = (filaActualSonido * max_columnas) + columnaActualSonido;
                   sonidoActual = aux;
                   switch (listaSonidos[aux].tipo){
                    case sonido_WAV: if (listaSonidos[aux].sonido != NULL)
                                      play_sample(listaSonidos[aux].sonido,255,128,1000,repetirSAMPLE);
                                     break;
                    case sonido_MP3: if (listaMP3.estaSonando==FALSE){
                                      if (listaSonidos[aux].sonidoMP3 != NULL){
                                       almp3_play_ex_mp3(listaSonidos[aux].sonidoMP3,32768,255,128,1000,repetirSAMPLE);
                                       listaMP3.sonidoMP3 = listaSonidos[aux].sonidoMP3;
                                       listaMP3.estaSonando = TRUE;
                                      }
                                     }
                                     break;

                    case sonido_OGG: if (listaOGG.estaSonando==FALSE){
                                      if (listaSonidos[aux].sonidoOGG != NULL){
                                       alogg_play_ex_ogg(listaSonidos[aux].sonidoOGG,32768,255,128,1000,repetirSAMPLE);
                                       listaOGG.sonidoOGG = listaSonidos[aux].sonidoOGG;
                                       listaOGG.estaSonando = TRUE;
                                      }
                                     }
                                     break;                                     
                   }
                   break;
   case KEY_SPACE: if (lineaRTS == TRUE){//Esta activada
                     if (roger_beep==TRUE){//roger_beep activo
                      aux = (filaActualBeep * max_columnas_beep) + columnaActualBeep;
                      if (listaBeep[aux].sonido!=NULL){
                       if (roger_beep_sonando == FALSE){
                        voz_beep = allocate_voice (listaBeep[aux].sonido);
                        if (voz_beep!=-1){
                         voice_start(voz_beep);
                         roger_beep_sonando = TRUE; //Esta sonando el roger_beep
                        }
                        else{
                         PuertoSerie(puerto_com,FALSE); //La desactivo
                         lineaRTS = FALSE;                        
                         if (raton==TRUE) show_mouse(NULL);
                          if (pantallaX==640){
                           textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                           rectfill(screen,505,0,505+44,70,color_negro);
                          }
                          else{
                           textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                           rectfill(screen,252,0,252+22,35,color_negro);
                          }
                         if (raton==TRUE) show_mouse(screen);
                        }
                       }
                       //while (voice_get_position(voz_beep)!=-1);
                       //deallocate_voice(voz_beep);
                      }
                      else{
                       PuertoSerie(puerto_com,FALSE); //La desactivo
                       lineaRTS = FALSE;                                            
                       if (raton==TRUE) show_mouse(NULL);
                        if (pantallaX == 640){
                         textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                         rectfill(screen,505,0,505+44,70,color_negro);
                        }
                        else{
                         textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                         rectfill(screen,252,0,252+22,35,color_negro);
                        }
                       if (raton==TRUE) show_mouse(screen);
                      }
                     }//roger_beep esta desactivado
                     else{
                      if (roger_beep_sonando==FALSE){
                       PuertoSerie(puerto_com,FALSE); //La desactivo
                       lineaRTS = FALSE;                      
                       if (raton==TRUE) show_mouse(NULL);
                        if (pantallaX == 640){
                         textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                         rectfill(screen,505,0,505+44,70,color_negro);
                        }
                        else{
                         textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                         rectfill(screen,252,0,252+22,35,color_negro);
                        }
                       if (raton==TRUE) show_mouse(screen);
                      }
                     }                     
                   }
                   else{//Esta desactivada
                    if (roger_beep_sonando == FALSE){
                     PuertoSerie(puerto_com,TRUE);
                     lineaRTS = TRUE;                    
                     if (raton==TRUE) show_mouse(NULL);
                      if (pantallaX==640){
                       textout_ex(screen,font,"  RTS ON  ",555,40,color_blanco,color_naranja);
                       blit(&foto_micro,screen,0,0,505,1,foto_micro.w,foto_micro.h);
                      }
                      else{
                       textout_ex(screen,font,"R ON",277,40,color_blanco,color_naranja);
                       rotate_scaled_sprite(screen,&foto_micro,252,1,itofix(0),itofix(1)>>1);
                       //blit(&foto_micro,screen,0,0,252,1,foto_micro.w,foto_micro.h);
                      }
                     if (raton==TRUE) show_mouse(screen);
                    }
                   }
                   break;
   case KEY_R: if (raton==TRUE) show_mouse(NULL);
               if (roger_beep == TRUE){
                roger_beep = FALSE;
                if (pantallaX == 640)
                 textout_ex(screen,font," BEEP OFF ",555,20,color_blanco,color_naranja);
                else
                 textout_ex(screen,font,"B OF",277,20,color_blanco,color_naranja);
               }
               else{
                 roger_beep = TRUE;
                 if (pantallaX == 640)
                  textout_ex(screen,font," BEEP ON  ",555,20,color_blanco,color_naranja);
                 else
                  textout_ex(screen,font,"B ON",277,20,color_blanco,color_naranja);
               }
               if (raton==TRUE) show_mouse(screen);
               break;

   case KEY_PLUS_PAD: volumenActual+=10;
                      if (volumenActual>255) volumenActual = 255;
                      set_volume(volumenActual,volumenActual);
                      MuestraVolumenSonido();
                      break;
   case KEY_MINUS_PAD: volumenActual-=10;
                       if (volumenActual<0) volumenActual = 0;
                       set_volume (volumenActual,volumenActual);
                       MuestraVolumenSonido();
                       break;

   case KEY_S: switch (listaSonidos[sonidoActual].tipo){
                case sonido_WAV: if (listaSonidos[sonidoActual].sonido!=NULL)
                                  stop_sample(listaSonidos[sonidoActual].sonido);
                                 break;
                case sonido_MP3: if (listaSonidos[sonidoActual].sonidoMP3!=NULL){
                                  almp3_stop_mp3(listaSonidos[sonidoActual].sonidoMP3);
                                  almp3_rewind_mp3(listaSonidos[sonidoActual].sonidoMP3);
                                  if (listaMP3.sonidoMP3 = listaSonidos[sonidoActual].sonidoMP3){
                                   listaMP3.sonidoMP3 = NULL;
                                   listaMP3.estaSonando = FALSE;
                                  }
                                 }
                                 break;
                case sonido_OGG: if (listaSonidos[sonidoActual].sonidoOGG!=NULL){
                                  alogg_stop_ogg(listaSonidos[sonidoActual].sonidoOGG);
                                  alogg_rewind_ogg(listaSonidos[sonidoActual].sonidoOGG);
                                  if (listaOGG.sonidoOGG = listaSonidos[sonidoActual].sonidoOGG){
                                   listaOGG.sonidoOGG = NULL;
                                   listaOGG.estaSonando = FALSE;
                                  }
                                 }
                                 break;                                 
               }
               break; //Para el sample actual

   case KEY_M: for (i=0;i<=totalSonidosCargados;i++){
                switch (listaSonidos[i].tipo){
                 case sonido_WAV: if (listaSonidos[i].sonido!=NULL)
                                   stop_sample(listaSonidos[i].sonido);
                                  break;
                 case sonido_MP3: if (listaSonidos[i].sonidoMP3!=NULL){
                                   almp3_stop_mp3(listaSonidos[i].sonidoMP3);
                                   almp3_rewind_mp3(listaSonidos[i].sonidoMP3);
                                   if (listaSonidos[i].sonidoMP3 == listaMP3.sonidoMP3){
                                    listaMP3.sonidoMP3 = NULL;
                                    listaMP3.estaSonando = FALSE;
                                   }
                                  }
                                  break;
                 case sonido_OGG: if (listaSonidos[i].sonidoOGG!=NULL){
                                   alogg_stop_ogg(listaSonidos[i].sonidoOGG);
                                   alogg_rewind_ogg(listaSonidos[i].sonidoOGG);
                                   if (listaSonidos[i].sonidoOGG == listaOGG.sonidoOGG){
                                    listaOGG.sonidoOGG = NULL;
                                    listaOGG.estaSonando = FALSE;
                                   }
                                  }
                                  break;
                }
               }
               break; //Para todos los samples

   case KEY_L: AccionRepetirSample();
               break;
  }
 }
}

/*****************************************/
void  ControlaEventoJoystick(boolean * salir){
 short int numeroBotones;
 short int aux,i;
 if (palancaJuegos != FALSE){
  numeroBotones =  joy[0].num_buttons;
  poll_joystick();


  if (joy[0].stick[0].axis[0].d1){
   //Izquierda
   tiempo = 0;
   LOCK_VARIABLE(tiempo);
   LOCK_FUNCTION(inc_tiempo);
   install_int(inc_tiempo,140);
   while ((joy[0].stick[0].axis[0].d1)&&(tiempo<1))
    poll_joystick();
   remove_int(inc_tiempo);
   if ((columnaActualSonido>0)&&(tabulador==FALSE)) columnaActualSonido--;
   if ((columnaActualBeep>0)&&(tabulador==TRUE)) columnaActualBeep--;
  }
  
  if (joy[0].stick[0].axis[0].d2){
   //Derecha
   tiempo = 0;
   LOCK_VARIABLE(tiempo);
   LOCK_FUNCTION(inc_tiempo);
   install_int(inc_tiempo,140);
   while ((joy[0].stick[0].axis[0].d2)&&(tiempo<1))
    poll_joystick();
   remove_int(inc_tiempo);   
   if ((columnaActualSonido<(max_columnas-1))&&(tabulador==FALSE)) columnaActualSonido++;
   if ((columnaActualBeep<(max_columnas_beep-1))&&(tabulador==TRUE)) columnaActualBeep++;
  }

  if (joy[0].stick[0].axis[1].d1){
   //Arriba
   tiempo = 0;
   LOCK_VARIABLE(tiempo);
   LOCK_FUNCTION(inc_tiempo);
   install_int(inc_tiempo,140);
   while ((joy[0].stick[0].axis[1].d1)&&(tiempo<1))
    poll_joystick();
   if ((filaActualSonido>0)&&(tabulador==FALSE)) filaActualSonido--;
   if ((filaActualBeep>0)&&(tabulador==TRUE)) filaActualBeep--;
   remove_int(inc_tiempo);   
  }

  if (joy[0].stick[0].axis[1].d2){
   //Abajo
   tiempo = 0;
   LOCK_VARIABLE(tiempo);
   LOCK_FUNCTION(inc_tiempo);
   install_int(inc_tiempo,140);
   while ((joy[0].stick[0].axis[1].d2)&&(tiempo<1))
    poll_joystick();
   remove_int(inc_tiempo);
   if ((filaActualSonido<(max_filas-1))&&(tabulador==FALSE)) filaActualSonido++;
   if ((filaActualBeep<(max_filas_beep-1))&&(tabulador==TRUE)) filaActualBeep++;
  }

  
  
  if (joy[0].button[0].b){
   //Se ha pulsado el boton de abrir PTT
   while (joy[0].button[0].b)
    poll_joystick();
    
   if (lineaRTS == TRUE){//Esta activada
                    if (roger_beep==TRUE){//roger_beep activo
                      aux = (filaActualBeep * max_columnas_beep) + columnaActualBeep;
                      if (listaBeep[aux].sonido!=NULL){
                       if (roger_beep_sonando == FALSE){
                        voz_beep = allocate_voice (listaBeep[aux].sonido);
                        if (voz_beep!=-1){
                         voice_start(voz_beep);
                         roger_beep_sonando = TRUE; //Esta sonando el roger_beep
                        }
                        else{
                         PuertoSerie(puerto_com,FALSE); //La desactivo
                         lineaRTS = FALSE;                        
                         if (raton==TRUE) show_mouse(NULL);
                          if (pantallaX==640){
                           textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                           rectfill(screen,505,0,505+44,70,color_negro);
                          }
                          else{
                           textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                           rectfill(screen,252,0,252+22,35,color_negro);
                          }
                         if (raton==TRUE) show_mouse(screen);
                        }
                       }
                       //while (voice_get_position(voz_beep)!=-1);
                       //deallocate_voice(voz_beep);
                      }
                      else{
                       PuertoSerie(puerto_com,FALSE); //La desactivo
                       lineaRTS = FALSE;                                            
                       if (raton==TRUE) show_mouse(NULL);
                        if (pantallaX == 640){
                         textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                         rectfill(screen,505,0,505+44,70,color_negro);
                        }
                        else{
                         textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                         rectfill(screen,252,0,252+22,35,color_negro);
                        }
                       if (raton==TRUE) show_mouse(screen);
                      }
                     }//roger_beep esta desactivado
                     else{
                      if (roger_beep_sonando==FALSE){
                       PuertoSerie(puerto_com,FALSE); //La desactivo
                       lineaRTS = FALSE;                      
                       if (raton==TRUE) show_mouse(NULL);
                        if (pantallaX == 640){
                         textout_ex(screen,font,"  RTS OFF ",555,40,color_blanco,color_naranja);
                         rectfill(screen,505,0,505+44,70,color_negro);
                        }
                        else{
                         textout_ex(screen,font,"R OF",277,40,color_blanco,color_naranja);
                         rectfill(screen,252,0,252+22,35,color_negro);
                        }
                       if (raton==TRUE) show_mouse(screen);
                      }
                     }                     
                   }
                   else{//Esta desactivada
                    if (roger_beep_sonando == FALSE){
                     PuertoSerie(puerto_com,TRUE);
                     lineaRTS = TRUE;                    
                     if (raton==TRUE) show_mouse(NULL);
                      if (pantallaX==640){
                       textout_ex(screen,font,"  RTS ON  ",555,40,color_blanco,color_naranja);
                       blit(&foto_micro,screen,0,0,505,1,foto_micro.w,foto_micro.h);
                      }
                      else{
                       textout_ex(screen,font,"R ON",277,40,color_blanco,color_naranja);
                       rotate_scaled_sprite(screen,&foto_micro,252,1,itofix(0),itofix(1)>>1);
                       //blit(&foto_micro,screen,0,0,252,1,foto_micro.w,foto_micro.h);
                      }
                     if (raton==TRUE) show_mouse(screen);
                    }
                   }   
  }

  if (joy[0].button[1].b){
   //Se ha pulsado el boton 2 para reproducir SAMPLE
   while (joy[0].button[1].b)
    poll_joystick();
   aux = (filaActualSonido * max_columnas) + columnaActualSonido;
                   sonidoActual = aux;
                   switch (listaSonidos[aux].tipo){
                    case sonido_WAV: if (listaSonidos[aux].sonido != NULL)
                                      play_sample(listaSonidos[aux].sonido,255,128,1000,repetirSAMPLE);
                                     break;
                    case sonido_MP3: if (listaMP3.estaSonando==FALSE){
                                      if (listaSonidos[aux].sonidoMP3 != NULL){
                                       almp3_play_ex_mp3(listaSonidos[aux].sonidoMP3,32768,255,128,1000,repetirSAMPLE);
                                       listaMP3.sonidoMP3 = listaSonidos[aux].sonidoMP3;
                                       listaMP3.estaSonando = TRUE;
                                      }
                                     }
                                     break;

                    case sonido_OGG: if (listaOGG.estaSonando==FALSE){
                                      if (listaSonidos[aux].sonidoOGG != NULL){
                                       alogg_play_ex_ogg(listaSonidos[aux].sonidoOGG,32768,255,128,1000,repetirSAMPLE);
                                       listaOGG.sonidoOGG = listaSonidos[aux].sonidoOGG;
                                       listaOGG.estaSonando = TRUE;
                                      }
                                     }
                                     break;                                     
                   }
  }

  if (joy[0].button[2].b){
   //Se ha pulsado el boton 3 para cambiar de menu, es decir, el TAB
   while (joy[0].button[2].b)
    poll_joystick();

   if (tabulador==TRUE){
                   tabulador = FALSE; //Para navegar por los sonidos
                   if (raton==TRUE) show_mouse(NULL);
                    if (pantallaX == 640)
                     textout_ex(screen,font," SONIDOS ",560,0,color_blanco,color_naranja);
                    else
                     textout_ex(screen,font,"SONI",280,0,color_blanco,color_naranja);
                   if (raton==TRUE) show_mouse(screen);
                 }
                 else{
                   tabulador = TRUE;  //Para navegar por el Roger beep
                   if (raton==TRUE) show_mouse(NULL);
                    if (pantallaX == 640)
                     textout_ex(screen,font," R-BEEP  ",560,0,color_blanco,color_naranja);
                    else
                     textout_ex(screen,font,"RBEP",280,0,color_blanco,color_naranja);
                   if (raton==TRUE) show_mouse(screen);
                 }
  }

  if (joy[0].button[3].b){
   //Se ha pulsado el boton 4 para silenciar todos los SAMPLES
   while (joy[0].button[3].b)
    poll_joystick();
   for (i=0;i<=totalSonidosCargados;i++){
                switch (listaSonidos[i].tipo){
                 case sonido_WAV: if (listaSonidos[i].sonido!=NULL)
                                   stop_sample(listaSonidos[i].sonido);
                                  break;
                 case sonido_MP3: if (listaSonidos[i].sonidoMP3!=NULL){
                                   almp3_stop_mp3(listaSonidos[i].sonidoMP3);
                                   almp3_rewind_mp3(listaSonidos[i].sonidoMP3);
                                   if (listaSonidos[i].sonidoMP3 == listaMP3.sonidoMP3){
                                    listaMP3.sonidoMP3 = NULL;
                                    listaMP3.estaSonando = FALSE;
                                   }
                                  }
                                  break;
                 case sonido_OGG: if (listaSonidos[i].sonidoOGG!=NULL){
                                   alogg_stop_ogg(listaSonidos[i].sonidoOGG);
                                   alogg_rewind_ogg(listaSonidos[i].sonidoOGG);
                                   if (listaSonidos[i].sonidoOGG == listaOGG.sonidoOGG){
                                    listaOGG.sonidoOGG = NULL;
                                    listaOGG.estaSonando = FALSE;
                                   }
                                  }
                                  break;
                }
   }
  }
 }
}

/*****************************************/
void PuertoSerie(enum TPuerto numero, boolean activar){
//Bajo DOS activo la linea RTS directamente en cada puerto
//Bajo WIN32 llamo a un programa creado por mi que activa RTS
 if (numero != NULO){
 #ifdef ALLEGRO_WINDOWS
  if (activar==TRUE){
   switch (numero){
    case COM1: system("winrts.exe COM1 ON NULL"); break;
    case COM2: system("winrts.exe COM2 ON NULL"); break;
    case COM3: system("winrts.exe COM3 ON NULL"); break;
    case COM4: system("winrts.exe COM4 ON NULL"); break;
   };
  }
  else{
   switch (numero){
    case COM1: system("winrts.exe COM1 OFF NULL"); break;
    case COM2: system("winrts.exe COM2 OFF NULL"); break;
    case COM3: system("winrts.exe COM3 OFF NULL"); break;
    case COM4: system("winrts.exe COM4 OFF NULL"); break;
   };
  }
 #endif

 #ifdef ALLEGRO_DOS
  #ifdef MODO_VIEJO
   if (activar==TRUE){
    switch (numero){
     case COM1: outportb (0x3F8+4,0xB); break; //activar bit 2
     case COM2: outportb (0x2F8+4,0xB); break;
     case COM3: outportb (0x3E8+4,0xB); break;
     case COM4: outportb (0x2E8+4,0xB); break;
    };
   }
   else{
    switch (numero){
     case COM1: outportb (0x3F8+4,0xFF); break;
     case COM2: outportb (0x2F8+4,0xFF); break;
     case COM3: outportb (0x3E8+4,0xFF); break;
     case COM4: outportb (0x2E8+4,0xFF); break;
    };
   }
  #endif
  #ifdef MODO_NUEVO
   if (activar==TRUE)
    comm_port_set_line_status(puertoRS232,DZCOMM_RTS,1);
   else
    comm_port_set_line_status(puertoRS232,DZCOMM_RTS,0);
  #endif
 #endif
 }
}

/*****************************************/
void MuestraAyuda(void){
//Muestra las opciones en cualquier S.O.
 allegro_message("PTT Sound v1.1   Autor: JJ\n\n ptt [puerto] [setup] [NO] [vga,vgax,svga]\n\n puerto = COM1,COM2,COM3,COM4,NULL\n\n+,- --> Control volumen\nR --> Activa ROGER BEEP\nENTER --> Reproduce sonido\nBarra espaciadora --> Activa PTT\nCursores --> Selecciona sonido\nS --> Silencia el Sonido actual\nM --> Silencia todos los sonidos\nTAB --> Cambia de Roger Beep a sonidos\nRaton (click izquierdo y derecho)\n");
}

/*****************************************/
void CargarArchivosINI(void){
//Lee de los archivos sonidos.ini y beep.ini los sonidos
//Si no se ha cargado los DAT de sonidos o Roger Beep, se ponen los sonidos
//del archivo ini desde el principio, sino, a partir de los DAT cargados
 PACKFILE * ficheroMP3, * ficheroOGG;
 FILE *ficheroSonidos, *ficheroBeep;
 unsigned char *bufferDatos;
 char nombre[255];
 char archivo[255];
 char cadAux[255];
 int aux=0;
 long int tamFichero=0;
 char * cadExtension;
 short int contador = 0;
 short int topeCad;

 if (pantallaX == 640) topeCad = 8;
 else topeCad = 4;
 ficheroSonidos = fopen ("sonidos.ini","rb");
 if (ficheroSonidos != NULL){
  if (sonidos_dat != NULL) contador = max_sonidos_dat;
  totalSonidosCargados = contador;
  while (aux != EOF){
   aux = fscanf (ficheroSonidos,"%s",nombre);
   if (aux!=EOF)
    aux = fscanf (ficheroSonidos,"%s",archivo);    
   if ((aux!=EOF)&&(contador<max_sonidos)){
    if (strlen(nombre)>topeCad) nombre[topeCad] = '\0';
    strcpy (listaSonidos[contador].nombreSonido,nombre);    
    listaSonidos[contador].memoria = FALSE;  //No esta dentro de un DAT, sino en un archivo
    fix_filename_slashes(archivo);
    cadExtension = get_extension(archivo);
    if (strcasecmp(cadExtension,"WAV")==0)
     listaSonidos[contador].sonido = load_wav(archivo);
    if (strcasecmp(cadExtension,"MP3")==0){
     tamFichero = file_size(archivo);     
     bufferDatos = (unsigned char*)malloc(tamFichero*sizeof(unsigned char*));
     if (bufferDatos!=NULL){
      ficheroMP3 = pack_fopen(archivo,F_READ);
       pack_fread (bufferDatos,tamFichero,ficheroMP3);
       listaSonidos[contador].punteroDatos = bufferDatos;
       listaSonidos[contador].sonidoMP3 = almp3_create_mp3 (bufferDatos,tamFichero);
      pack_fclose(ficheroMP3);
      listaSonidos[contador].tipo = sonido_MP3;
     }
    }

    if (strcasecmp(cadExtension,"OGG")==0){
     tamFichero = file_size(archivo);     
     bufferDatos = (unsigned char*)malloc(tamFichero*sizeof(unsigned char*));
     if (bufferDatos!=NULL){
      ficheroOGG = pack_fopen(archivo,F_READ);
       pack_fread (bufferDatos,tamFichero,ficheroOGG);
       listaSonidos[contador].punteroDatos = bufferDatos;
       listaSonidos[contador].sonidoOGG = alogg_create_ogg_from_buffer (bufferDatos,tamFichero);
      pack_fclose(ficheroOGG);
      listaSonidos[contador].tipo = sonido_OGG;
     }
    }


    totalSonidosCargados = contador;
    contador ++;
   }
  }  
  fclose(ficheroSonidos);
 }

 ficheroBeep = fopen ("beep.ini","rb");
 if (ficheroBeep != NULL){
  aux = 0;
  contador = 0;
  if (beep_dat != NULL) contador = max_beep_dat;
  while (aux != EOF){
   aux = fscanf (ficheroBeep,"%s",nombre);
   if (aux!=EOF)
    aux = fscanf (ficheroBeep,"%s",archivo);
   if ((aux!=EOF)&&(contador<max_sonidos_beep)){
    if (strlen(nombre)>topeCad) nombre[topeCad] = '\0';
    strcpy (listaBeep[contador].nombreSonido,nombre);
    listaBeep[contador].memoria = FALSE;  //No esta dentro de un DAT, sino en un archivo
    fix_filename_slashes(archivo);
    listaBeep[contador].sonido = load_wav(archivo);
    contador ++;
   }
  }
  fclose(ficheroBeep);
 }
}

/*****************************************/
void MuestraVolumenSonido(void){
 //Muestra el volumen actual del sonido
 rectfill(screen,85,60,79+70,70,makecol(0,0,0));
 rectfill(screen,85,60,((volumenActual>>2)+85),70,makecol(255,200,200));
 textout(screen,font,"VOLUMEN",20,62,makecol(255,190,190));
}

/********************************************/
void AccionRepetirSample(void){
 short int posicion;
 if (pantallaX == 640)  posicion = 250;
 else posicion = 200;
 if (repetirSAMPLE==FALSE){ 
  textout(screen,font,"REPETIR SAMPLE",posicion,62,makecol(255,190,190));
  repetirSAMPLE = TRUE;
 }
 else{
  textout(screen,font,"              ",posicion,62,makecol(255,190,190));
  repetirSAMPLE = FALSE;
 }
}

/*****************************************/
#ifdef MODO_NUEVO
 #ifdef ALLEGRO_DOS
void InicializaPuertoSerie(enum TPuerto numero){
 //Aqui se leen los datos del archivo puerto.ini
 comm valor;
 short int aux = FALSE;
 
 if (dzcomm_init()==1){
  switch (numero){
   case COM1: valor = _com1; break;
   case COM2: valor = _com2; break;
   case COM3: valor = _com3; break;
   case COM4: valor = _com4; break;
   default: aux = TRUE; break;
  }
  if (aux != TRUE){
   puertoRS232 = comm_port_init(valor);
   if (puertoRS232==NULL){
    comm_port_uninstall(puertoRS232);
    dzcomm_closedown();
    allegro_message("Error en inicializacion del puerto\n");
    allegro_exit();
    exit(-1);
   }
 //  comm_port_load_settings(puertoRS232,"puerto.ini");
   comm_port_install_handler(puertoRS232);
   comm_port_set_line_status(puertoRS232,DZCOMM_RTS,0);
  }
 }
}

/****************************************/
void EliminarPuertoSerie(void){
 comm_port_uninstall(puertoRS232);
 dzcomm_closedown();
}
 #endif
#endif

/*****************************************/
/* if (install_sound_input(DIGI_AUTODETECT,MIDI_NONE)==-1){
  allegro_message("Error en driver de grabacion\n"); allegro_exit(); exit(-1);
 }

 if (set_sound_input_source(SOUND_INPUT_MIC)==-1){
  allegro_message("Error en entrada\n"); allegro_exit(); exit(-1);
 }

 printf ("Bits: %d\n",get_sound_input_cap_bits());
 printf ("Estereo: %d\n",get_sound_input_cap_stereo());
 printf ("Frecuencia maxima: %d\n",get_sound_input_cap_rate(8,FALSE));
 printf ("Full Duplex: %d\n",get_sound_input_cap_parm(45454,8,FALSE));

 valor = start_sound_input(45454,8,FALSE);
 printf ("Bytes buffer: %d\n",valor);
 
 while (!keypressed()){
  read_sound_input(buffer);
 }
 stop_sound_input(); 
 remove_sound_input();*/
