#ifndef LEVEL_H
#define LEVEL_H

#include <cmath>
#include <fstream>
#include <allegro.h>
#include <alleggl.h>
#include <gl/glu.h>
#include "ball.h"
#include "cube.h"
#include "camera.h"
#include "globals.h"

using namespace std;

#define RAND(min, max) ((min) + ((max)-(min))*(float)rand()/RAND_MAX)

const int HoleRes = 8;

typedef void (__stdcall *TessFunc)();

struct Hole
{
    float X, Z;
    double Data[HoleRes][3];
};

class Level
{
    public:
        Level(string Filename);
        ~Level();
        void Clear();
        void UpdateLogic();
        void DrawPreview();
        void UpdateGraphics();
        void DrawLevel();
        void DrawEdges();
        bool PlayerAlive() {return TheBall->Y > -50.0;} 
        bool LevelFinished();
        int GetPlayerTime() {return PlayerTime;}       
        bool MouseControl;
        
    private:     
        Cube **Objects;
        Hole **Holes;
        int ObjectCount, HoleCount;
        Ball *TheBall;
        Camera *Cam;
        float xRot, zRot;
        float StartX, StartZ, FinishX, FinishZ;
        float LevelW, LevelH;  
        unsigned int List, WoodTex;
        double PlaneData[4][3];
        GLUtesselator *Tess;
        FONT *Font;
        int PlayerTime, StartTime;
};

#endif
