#include "highscore.h"

//------------------------------------------------------------------------------


//Konstruktor
HighscoreManager::HighscoreManager(int _EntryCount, bool _Reversed)
{
    //Antal namn som listan innehller
    EntryCount = _EntryCount;
    //Om listan r omvnd hamnar sm vrden frst
    Reversed = _Reversed;
    //Fyll med tomma poster
    for (int i = 0; i < EntryCount; ++i)
    {
        HighscoreEntry TempEntry;
        TempEntry.Name = "None";
        if (Reversed)
            TempEntry.Score = 500;
        else
            TempEntry.Score = 0;
        TempEntry.Reversed = Reversed;
        Entries.push_back(TempEntry);
    }
}
//------------------------------------------------------------------------------


//Destruktor
HighscoreManager::~HighscoreManager()
{
}
//------------------------------------------------------------------------------


//Lgg till ett nytt vrde
void HighscoreManager::AddEntry(string Name, int Score)
{
    if (IsOnList(Score))
    {
        HighscoreEntry TempEntry;
        TempEntry.Name = Name;
        TempEntry.Score = Score;
        TempEntry.Reversed = Reversed;
        Entries.pop_back();
        Entries.push_back(TempEntry);
        Entries.sort();
    }
}
//------------------------------------------------------------------------------


//Kryptera och skriv ut till fil
bool HighscoreManager::PrintToFile(string Filename)
{
    //Skriv en tillfllig fil   
    ofstream Fout("Tempout.txt");
    if (!Fout)
        return false;
    list<HighscoreEntry>::iterator it = Entries.begin();    
    
    while (it != Entries.end())
    {
        Fout << it->Name << " " << it->Score << "\n";
        ++it;
    }
    Fout.close();
    
    //Kryptera
    Fout.open((char*)Filename.c_str(), ios::out |ios::binary);
    ifstream Fin("Tempout.txt", ios::in | ios::binary);
    char Cchar;
    while(Fin.get(Cchar))
        Fout.put((char)~Cchar);
    Fout.close();
    Fin.close();
        
    remove("Tempout.txt");
    
    return true;
}
//------------------------------------------------------------------------------


//Ls in frn fil och dekryptera
bool HighscoreManager::ReadFromFile(string Filename)
{
    //Skapa en temporr dekrypterad fil
    ifstream Fin((char*)Filename.c_str(), ios::in | ios::binary);
    ofstream Fout("Tempin.txt", ios::out | ios::binary);
    char Cchar;
    while(Fin.get(Cchar))
        Fout.put((char)~Cchar);
    Fin.close();
    Fout.close();
    
    //Ls in den dekrypterade filen
    ifstream Fin2("Tempin.txt");
    if (!Fin2)
        return false;
    list<HighscoreEntry>::iterator it = Entries.begin();  
    string TempName;
    int TempScore; 
    
    while (it != Entries.end())
    {
        Fin2 >> it->Name >> it->Score;
        ++it;
    }
    Fin2.close();
    
    remove("Tempin.txt");
    
    return true;
}
//------------------------------------------------------------------------------


//Kolla om ett namn skall vara med p listan
bool HighscoreManager::IsOnList(int Score)
{
    if (Reversed)
        return Score < Entries.back().Score;
    else
        return Score > Entries.back().Score;
}
//------------------------------------------------------------------------------


//Antalet namn som finns med p listan
unsigned int HighscoreManager::Size()
{
    int Count = 0;
    list<HighscoreEntry>::iterator it;
    for (it = Entries.begin(); it != Entries.end(); ++it)
        Count++;
    return Count;
}
//------------------------------------------------------------------------------


//Returnera ett visst namn p listan
HighscoreEntry HighscoreManager::GetEntry(int Index)
{
    list<HighscoreEntry>::iterator it = Entries.begin();
    int i = 0;
    while (i < Index)
    {
        ++i;
        ++it;
    }
    return *it;
}
//------------------------------------------------------------------------------


//Jmfrelseoperator fr sortering
bool operator < (const HighscoreEntry &n1, const HighscoreEntry &n2)
{
    if (n1.Reversed)
        return n1.Score < n2.Score;
    else
        return n1.Score > n2.Score;
}
//------------------------------------------------------------------------------
