#include "cube.h"

//------------------------------------------------------------------------------



//Konstruktor
Cube::Cube (float x, float y, float z, float sx, float sy, float sz)
{
    X = x;
    Y = y;
    Z = z;
    SizeX = sx;
    SizeY = sy;
    SizeZ = sz;
}
//------------------------------------------------------------------------------



//Rendera
void Cube::Render()
{
    glPushMatrix();
    glTranslatef(X, Y, Z);
    glBegin(GL_QUADS);       
        //Framsida
        glNormal3f(0.0, 0.0, 1.0);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-SizeX/2, SizeY/2, SizeZ/2);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(SizeX/2, SizeY/2, SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(SizeX/2, -SizeY/2, SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-SizeX/2, -SizeY/2, SizeZ/2);
        //Baksida
        glNormal3f(0.0, 0.0, -1.0);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-SizeX/2, SizeY/2, -SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-SizeX/2, -SizeY/2, -SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(SizeX/2, -SizeY/2, -SizeZ/2);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(SizeX/2, SizeY/2, -SizeZ/2);
        //Vnster
        glNormal3f(-1.0, 0.0, 0.0);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(-SizeX/2, SizeY/2, SizeZ/2);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-SizeX/2, -SizeY/2, SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-SizeX/2, -SizeY/2, -SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(-SizeX/2, SizeY/2, -SizeZ/2);
        //Hger
        glNormal3f(1.0, 0.0, 0.0);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(SizeX/2, SizeY/2, SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(SizeX/2, SizeY/2, -SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(SizeX/2, -SizeY/2, -SizeZ/2);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(SizeX/2, -SizeY/2, SizeZ/2);
        //vre
        glNormal3f(0.0, 1.0, 0.0);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-SizeX/2, SizeY/2, SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-SizeX/2, SizeY/2, -SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(SizeX/2, SizeY/2, -SizeZ/2);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(SizeX/2, SizeY/2, SizeZ/2);
        //Undre
        glNormal3f(0.0, -1.0, 0.0);
        glTexCoord2f(0.0, 1.0);
        glVertex3f(-SizeX/2, -SizeY/2, SizeZ/2);
        glTexCoord2f(1.0, 1.0);
        glVertex3f(SizeX/2, -SizeY/2, SizeZ/2);
        glTexCoord2f(1.0, 0.0);
        glVertex3f(SizeX/2, -SizeY/2, -SizeZ/2);
        glTexCoord2f(0.0, 0.0);
        glVertex3f(-SizeX/2, -SizeY/2, -SizeZ/2);
    glEnd();
    glPopMatrix();
}
//------------------------------------------------------------------------------



//Ls in frn fil
istream &operator >> (istream &Stream, Cube &Obj)
{
    Stream >> Obj.X >> Obj.Y >> Obj.Z >> Obj.SizeX >> Obj.SizeY >> Obj.SizeZ;
    return Stream;
}
//------------------------------------------------------------------------------
