#include "level.h"
#include "menu.h"

//------------------------------------------------------------------------------
TextRotator *MenuHandler::LevelStrings;
//------------------------------------------------------------------------------


//Konstruktor
MenuHandler::MenuHandler()
{
    MenuFont = allegro_gl_load_system_font_ex("Courier New", AGL_FONT_TYPE_OUTLINE, 0, 10, 10, 0.5, 32, 256);
    
    //Ladda banor
    LevelStrings = new TextRotator(MenuFont, makecol(100, 100, 100), makecol(255, 255, 255));
    for_each_file("Levels/*lev", FA_ARCH, FileCallback, 0);
    
    PreviewLevels = new Level*[LevelStrings->Strings.size()];
    for (unsigned int i = 0; i < LevelStrings->Strings.size(); ++i)
        PreviewLevels[i] = new Level((char*)LevelStrings->Strings[i].c_str());
        
    //Ls in bakgrundsbild
    BITMAP *Bmp = load_bitmap("Data/Textures/bg.bmp", NULL);
    if (!Bmp)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture 'bg.bmp'");
        exit(1);
    }
    BgTex = allegro_gl_make_texture(Bmp);
    destroy_bitmap(Bmp);
    
    BgRotate = 0.0;
    
    //Ladda ljud
    Applause = load_sample("Data/Audio/applause.wav");
    if (!Applause)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load sound file applause.wav.");
        exit(1);
    }
}
//------------------------------------------------------------------------------



//Destruktor
MenuHandler::~MenuHandler()
{
    for (unsigned int i = 0; i < LevelStrings->Strings.size(); ++i)
        delete PreviewLevels[i];
    delete []PreviewLevels;
    allegro_gl_destroy_font(MenuFont);
    delete LevelStrings;
    destroy_sample(Applause);
}
//------------------------------------------------------------------------------



//Visa intro
void MenuHandler::ShowIntro()
{
    //Kub
    Cube *TexCube = new Cube(0.0, 0.0, 0.0, 1.2, 1.2, 1.2);
    float xRot = 0.0, yRot = 0.0, zDist = -22.0;
    int Texture;
    BITMAP *Bmp = load_bitmap("Data/Textures/Logo.bmp", NULL);
    if (!Bmp)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture 'logo.bmp'");
        exit(1);
    }
    Texture = allegro_gl_make_texture(Bmp);
    destroy_bitmap(Bmp);
    glDisable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, Texture);
    
    //Fr att vnta efter att den r framme
    int WaitCounter = -1;
    bool Quit = false;
    
    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC] && !Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            if (zDist < -4.0)
            {
                zDist+=0.1;
                xRot+=2;
                yRot+=2;
            }
            else if (WaitCounter < 0)
                WaitCounter = 100;
            if (WaitCounter > 0)
                WaitCounter--;
            if (WaitCounter == 0)
                Quit = true;    
            Globals::SpeedCounter--;
        }
        PrepareRender();

        glPushMatrix();
            glTranslatef(0.0, 0.0, zDist);
            glRotatef(xRot, 1.0, 0.0, 0.0);
            glRotatef(yRot, 0.0, 1.0, 0.0);
            glColor3f(1.0, 1.0, 1.0);
            TexCube->Render();
        glPopMatrix();

        allegro_gl_flip();
    }
    glEnable(GL_CULL_FACE);
    delete TexCube;
}
//------------------------------------------------------------------------------



//Visa huvudmenyn och returnera det man valt
MenuVal MenuHandler::MainMenu()
{
    //Diverse
    clear_keybuf();
    while(key[KEY_ENTER]);
    MenuVal Choice = mvRunGame;
    bool Quit = false, KeyDown = false;
    float TextRotate = 0;
    glEnable(GL_FOG);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    //Textstrngar   
    TextRotator *Text = new TextRotator(MenuFont, makecol(100, 100, 100), makecol(255, 255, 255));    
    Text->AddString("New Game");
    Text->AddString("Options");
    Text->AddString("Credits");
    Text->AddString("Exit"); 

    Globals::SpeedCounter = 0;
    while (!Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            Text->Update();
            if (key[KEY_Q])
            {
                Choice = mvExit;
                Quit = true;
            }
        
            if (key[KEY_ENTER])
            {
                Choice = (MenuVal)Text->GetSelect();
                Quit = true;
            }
                
            if (!KeyDown)
            {
                KeyDown = true;
                if (key[KEY_UP])
                    Text->Upwards();
                if (key[KEY_DOWN])
                    Text->Downwards();
            }
            KeyDown = (key[KEY_UP] || key[KEY_DOWN]);
            TextRotate+=0.05;
            BgRotate+=0.1;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Bakgrund
        if (Globals::Texturing)
           DrawBackground();
               
        //Rita ut textstrngar
        glPushMatrix();
            glTranslatef(0.0, 0.0, -30.0);
            Text->RenderText();
        glPopMatrix();
        
        DrawTitle("Labyrinth", TextRotate);
        
        allegro_gl_flip();
    }
    glDisable(GL_FOG);
    
    delete Text;
    return Choice;
}
//------------------------------------------------------------------------------



//Vlj en bana att spela
string MenuHandler::PickLevel()
{
    //Diverse
    while(key[KEY_ENTER]);
    bool Quit = false, KeyDown = false;
    glEnable(GL_FOG);
    string Choice;
    float LevelRot = 0.0, TextRotate = 0.0;
    if (LevelStrings->Strings.empty())
        return "Quit";

    Globals::SpeedCounter = 0;
    while (!Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            LevelStrings->Update();
            LevelRot += 0.5;
        
            if (key[KEY_ENTER])
            {
                Choice = LevelStrings->GetSelectString();
                Quit = true;
            }
            if (key[KEY_ESC])
            {
                Choice = "Quit";
                Quit = true;
            }
                
            if (!KeyDown)
            {
                KeyDown = true;
                if (key[KEY_UP])
                    LevelStrings->Upwards();
                if (key[KEY_DOWN])
                    LevelStrings->Downwards();
            }
            KeyDown = (key[KEY_UP] || key[KEY_DOWN]);
            TextRotate += 0.05;
            BgRotate += 0.1;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Bakgrund
        if (Globals::Texturing)
            DrawBackground();
        
        //Rita ut textstrngar
        glPushMatrix();
            glTranslatef(0.0, 0.0, -30.0);
            LevelStrings->RenderText();
        glPopMatrix();
        
        DrawTitle("Pick a level", TextRotate);
        
        //Rita ut den valda banan
        glPushMatrix();
            glTranslatef(0.0, -2.0, -10.0);
            glRotatef(15.0, 1.0, 0.0, 0.0);
            glRotatef(LevelRot, 0.0, 1.0, 0.0);
            glScalef(0.1, 0.1, 0.1);
            PreviewLevels[LevelStrings->Select]->DrawPreview();
        glPopMatrix();
        
        allegro_gl_flip();
    }
    glDisable(GL_FOG);
    
    return Choice;
}
//------------------------------------------------------------------------------

//Frga om man vill spela igen
bool MenuHandler::PlayAgainMenu()
{
    //Diverse
    clear_keybuf();
    while(key[KEY_ENTER]);
    bool Choice = false;
    bool Quit = false, KeyDown = false;
    float TextRotate = 0;
    glEnable(GL_FOG);

    //Textstrngar   
    TextRotator *Text = new TextRotator(MenuFont, makecol(100, 100, 100), makecol(255, 255, 255));    
    Text->AddString("Yes");
    Text->AddString("No");

    Globals::SpeedCounter = 0;
    while (!Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            Text->Update();
            if (key[KEY_Q])
            {
                Choice = false;
                Quit = true;
            }
        
            if (key[KEY_ENTER])
            {
                Choice = ((MenuVal)Text->GetSelect() == 0);       
                Quit = true;
            }
                
            if (!KeyDown)
            {
                KeyDown = true;
                if (key[KEY_UP])
                    Text->Upwards();
                if (key[KEY_DOWN])
                    Text->Downwards();
            }
            KeyDown = (key[KEY_UP] || key[KEY_DOWN]);
            TextRotate+=0.05;
            BgRotate+=0.1;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Bakgrund
        if (Globals::Texturing)
           DrawBackground();
               
        //Rita ut textstrngar
        glPushMatrix();
            glTranslatef(0.0, 0.0, -30.0);
            Text->RenderText();
        glPopMatrix();
        
        DrawTitle("Play again?", TextRotate);
        
        allegro_gl_flip();
    }
    glDisable(GL_FOG);
    
    delete Text;
    return Choice;
}
//------------------------------------------------------------------------------


//Visa alternativmenyn
void MenuHandler::OptionsMenu()
{
    clear_keybuf();
    while(key[KEY_ENTER]);
    bool Quit = false, KeyDown = false;
    float TextRotate = 0.0;
    glEnable(GL_FOG);

    //Textstrngar   
    TextRotator *Text = new TextRotator(MenuFont, makecol(100, 100, 100), makecol(255, 255, 255));    
    Text->AddStringEx("Control: %s", Globals::MouseControl?"Mouse" : "Keyboard");
    Text->AddStringEx("Texturing: %s", Globals::Texturing?"On":"Off");
    Text->AddStringEx("Fullscreen: %s", Globals::Fullscreen?"Yes":"No");
    Text->AddStringEx("Resolution: %dx%d", Globals::ScreenWidth, Globals::ScreenHeight);
    Text->AddStringEx("Sound: %s", Globals::SoundOn?"On":"Off");
    Text->AddStringEx("Control sensitivity: %d", Globals::MouseSens);
    Text->AddString("Back"); 

    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC] && !Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            Text->Update();
            if (key[KEY_Q])
                Quit = true;

            if (!KeyDown)
            {
                KeyDown = true;
                if (key[KEY_UP])
                    Text->Upwards();
                if (key[KEY_DOWN])
                    Text->Downwards();
                //Kolla val
                if (key[KEY_ENTER])
                {
                    switch (Text->GetSelect())
                    {
                        case 0: //Kontroll
                            Globals::MouseControl = !Globals::MouseControl;
                            break;
                        case 1: //Texturering
                            Globals::Texturing = !Globals::Texturing;
                            break;
                        case 2: //Fullscreen
                            Globals::Fullscreen = !Globals::Fullscreen;
                            break;
                        case 3: //Upplsning
                            switch(Globals::ScreenWidth)
                            {
                                case 640:
                                    Globals::ScreenWidth = 800;
                                    Globals::ScreenHeight = 600;
                                    break;
                                case 800:
                                    Globals::ScreenWidth = 1024;
                                    Globals::ScreenHeight = 768;
                                    break;
                                default:
                                    Globals::ScreenWidth = 640;
                                    Globals::ScreenHeight = 480;
                            }
                            break;
                        case 4: //Ljud
                            Globals::SoundOn = !Globals::SoundOn;
                            break;
                        case 5: //Knslighet
                            Globals::MouseSens++;
                            if (Globals::MouseSens > 10)
                                Globals::MouseSens = 1;
                            break;
                        case 6: //Avsluta
                            Quit = true;
                            break;
                    }  
                    //Uppdatera text
                    Text->Strings.clear();  
                    Text->AddStringEx("Control: %s", Globals::MouseControl?"Mouse" : "Keyboard");
                    Text->AddStringEx("Texturing: %s", Globals::Texturing?"On":"Off");
                    Text->AddStringEx("Fullscreen: %s", Globals::Fullscreen?"Yes":"No");
                    Text->AddStringEx("Resolution: %dx%d", Globals::ScreenWidth, Globals::ScreenHeight);
                    Text->AddStringEx("Sound: %s", Globals::SoundOn?"On":"Off");
                    Text->AddStringEx("Control sensitivity: %d", Globals::MouseSens);
                    Text->AddString("Back");   
                }
            }
            KeyDown = (key[KEY_UP] || key[KEY_DOWN] || key[KEY_ENTER]);
            TextRotate += 0.05;
            BgRotate += 0.1;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Bakgrund
        if (Globals::Texturing)
            DrawBackground();
        
        //Rita ut textstrngar
        glPushMatrix();
            glTranslatef(0.0, 0.0, -30.0);
            Text->RenderText();
        glPopMatrix();
        
        DrawTitle("Options", TextRotate);
        
        allegro_gl_flip();
    }
    glDisable(GL_FOG);
}
//------------------------------------------------------------------------------



//Visa credits
void MenuHandler::CreditsMenu()
{    
    clear_keybuf();
    while(key[KEY_ENTER]);
    bool Quit = false, KeyDown = false;
    float TextRotate = 0.0;
    glEnable(GL_FOG);
    
    int StrCount = 6, StrIndex = 0;
    float TextPos = 3.0;
    string Strings[] = {"Labyrinth v 1.1","Programming: Hannes Jensen",
                        "Graphics: Hannes Jensen","Game Idea: Hannes Jensen", 
                        "http://orangecamel.cjb.net",""};

    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC])
    {
        while (Globals::SpeedCounter > 0)
        {
            //Flytta text
            TextPos -= 0.02;
            if (TextPos <= -3)
            {
                TextPos = 3.0;
                StrIndex++;
                if (StrIndex == StrCount)
                    StrIndex = 0;
            }
            TextRotate += 0.05;
            BgRotate += 0.1;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Bakgrund
        if (Globals::Texturing)
            DrawBackground();
        
        DrawTitle("Credits", TextRotate);
        
        allegro_gl_printf(MenuFont, pow(TextPos,3)-TextLength(Strings[StrIndex])/2, 0.0, -30.0, 
                    makecol(255, 255, 255), (char*)Strings[StrIndex].c_str());
        
        allegro_gl_flip();
    }
    glDisable(GL_FOG);
}
//------------------------------------------------------------------------------



//Visa meddelande efter att man har spelat
void MenuHandler::FinishMessage(int Time, string LevelName)
{
    if (Time < 0)
        return;

    while(key[KEY_ENTER]);
    while(key[KEY_ESC]);

    //Ls in texture
    GLuint Texture;
    BITMAP *Tex;
    Tex = load_bitmap("Data/Textures/finish.bmp", NULL);
    
    if (!Tex)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture: 'finish.bmp'.");
        exit(1);
    }
    Texture = allegro_gl_make_texture(Tex);
    destroy_bitmap(Tex);
    glBindTexture(GL_TEXTURE_2D, Texture);
    glEnable(GL_TEXTURE_2D);
    glDisable(GL_LIGHTING);
    
    //Textens position o.dyl.
    float TextZ = -50.0, TextRot = 0.0, TextSpeed = 0.7;
    float TextH = 1.0, TextW = 6;
    bool Quit = false;
    int WaitCounter = 150;

    //Rita ut texten
    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC] && !key[KEY_ENTER] && !Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
                TextZ += TextSpeed;
                TextRot += 10.0;
            WaitCounter--;
            if (WaitCounter <= 0)
                Quit = true;
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        //Rita fyrkant med text
        glPushMatrix();
        glTranslatef(0.0, 0.0, TextZ);
        glRotatef(TextRot, 0.0, 0.0, 1.0);
        glBegin(GL_QUADS);
            glTexCoord2f(0.0, 1.0); glVertex3f(-TextW/2, TextH/2, 0);
            glTexCoord2f(1.0, 1.0); glVertex3f(TextW/2, TextH/2, 0);   
            glTexCoord2f(1.0, 0.0); glVertex3f(TextW/2, -TextH/2, 0);  
            glTexCoord2f(0.0, 0.0); glVertex3f(-TextW/2, -TextH/2, 0);            
        glEnd();
        glPopMatrix();
        
        allegro_gl_flip();
    }
    //ShowHighscores(Time, LevelName);
    glEnable(GL_LIGHTING);
}
//------------------------------------------------------------------------------



//Visa topplista och ls eventuellt in ett nytt namn
void MenuHandler::ShowHighscores(int Time, string LevelName)
{
    //Ls in topplista
    HighscoreManager *Highscore = new HighscoreManager(10, true);
    string FileName = "Levels/Highscores/";
    FileName += LevelName;
    FileName += ".hsc";
    Highscore->ReadFromFile(FileName);
    
    //Stll om till ortografisk projektion
    glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    glOrtho(-50.0, 50.0, -50.0, 50.0, 1.0, -100.0);
    glMatrixMode(GL_MODELVIEW);
    glFrontFace(GL_CW);
    glLoadIdentity();
    
    //Ls eventuellt in nytt namn
    if (Highscore->IsOnList(Time) && Time > 0)
        Highscore->AddEntry(GetName(), Time);
    while(key[KEY_ENTER]);
    while(key[KEY_ESC]);
    
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    
    //Ladda fonter
    FONT *AllegFont = (FONT*)Globals::FontDat[COURIER24].dat;
    FONT *Font =  allegro_gl_convert_allegro_font(AllegFont, AGL_FONT_TYPE_TEXTURED, text_height(AllegFont)/5);
    glEnable(GL_TEXTURE_2D);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    string Text;     
    
    //Fyrverkerier
    int RocketCount = 3;
    Rocket *Rockets[RocketCount];
    for (int i = 0; i < RocketCount; ++i)
        Rockets[i] = new Rocket(150);
    
    //Rita ut texten
    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC] && !key[KEY_ENTER])
    {
        while (Globals::SpeedCounter > 0)
        {
            if (Globals::Texturing)
            {
                for (int i = 0; i < RocketCount; ++i)
                    Rockets[i]->Update();
            }
            Globals::SpeedCounter--;
        }
        PrepareRender();
        
        Text = LevelName + " - Highscores";
        allegro_gl_printf(Font, -(text_length(AllegFont, Text.c_str())*0.145)/2, 45.0, 0, makecol(255, 255, 255), (char*)Text.c_str());
        
        for (int i = 0; i < Highscore->Size(); ++i)
        {
            char PlaceStrn[10], ScoreStrn[10];
            Text = itoa(i+1, PlaceStrn, 10) + (string)". " + Highscore->GetEntry(i).Name + " " + itoa(Highscore->GetEntry(i).Score, ScoreStrn, 10);
            allegro_gl_printf(Font, -(text_length(AllegFont, Text.c_str())*0.145)/2, 20.0-i*6, 0, makecol(255, 255, 255), (char*)Text.c_str());
        }

        //Rita fyrverkerier
        if (Globals::Texturing)
        {
            glPushMatrix();
            glBlendFunc(GL_SRC_ALPHA, GL_ONE);
            glEnable(GL_BLEND);
            for (int i = 0; i < RocketCount; ++i)
                Rockets[i]->Render();
            glDisable(GL_BLEND);   
            glPopMatrix();
        }

        allegro_gl_flip();
    }
    
    //Stll om till perpektiv
    glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    gluPerspective(30.0, (float)SCREEN_W/(float)SCREEN_H, 1.0, 100.0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    glEnable(GL_DEPTH_TEST); 
    glEnable(GL_LIGHTING);
    
    Highscore->PrintToFile(FileName);
    delete Highscore;
    allegro_gl_destroy_font(Font);
    for (int i = 0; i < RocketCount; ++i)
        delete Rockets[i];
}
//------------------------------------------------------------------------------


//Frbered utritning
void MenuHandler::PrepareRender()
{
    GLfloat LightPos[] = {10.0, 40.0, 50.0, 1.0};
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLightfv(GL_LIGHT0, GL_POSITION, LightPos);
}
//------------------------------------------------------------------------------


//Rita en roterad titel
void MenuHandler::DrawTitle(string Text, float Rot)
{
    //Rita en ltt roterande text
    glPushMatrix();
        glTranslatef(0.0, 0.0, -10.0);
        glTranslatef(-TextLength(Text)/4, 0.0, 0.0);
        glRotatef(2*sin(Rot), 1.0, 0.0, 1.0);
        glRotatef(2*cos(Rot), 0.0, 1.0, 0.0);
        allegro_gl_printf(MenuFont, -TextLength(Text)/4, 1.9, 0.0, makecol(255, 255, 255), (char*)Text.c_str());
    glPopMatrix();
}
//------------------------------------------------------------------------------


//Rita bakgrunden
void MenuHandler::DrawBackground()
{
    glPushMatrix();

    glEnable(GL_TEXTURE_2D);
    glFrontFace(GL_CCW);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glDisable(GL_FOG);
    glBindTexture(GL_TEXTURE_2D, BgTex);

    glRotatef(BgRotate, 0.0, 0.0, 1.0);
    glBegin(GL_QUADS);
        glColor3f(1.0, 1.0, 1.0);
        glTexCoord2f(0.0, 1.0); glVertex3f(-40.0, 40.0, -80.0+10*sin(BgRotate/10));
        glTexCoord2f(0.0, 0.0); glVertex3f(-40.0, -40.0, -80.0+10*sin(BgRotate/10));
        glTexCoord2f(1.0, 0.0);  glVertex3f(40.0, -40.0, -80.0+10*sin(BgRotate/10));
        glTexCoord2f(1.0, 1.0); glVertex3f(40.0, 40.0, -80.0+10*sin(BgRotate/10));  
    glEnd();
    glEnable(GL_FOG);
    
    glPopMatrix();
}
//------------------------------------------------------------------------------


//Ls in ett namn fr topplistan
string MenuHandler::GetName()
{
    if (Globals::SoundOn)
        play_sample(Applause, 200, 128, 1000, false);

    while(key[KEY_ENTER]);
    while(key[KEY_ESC]);

    //Ladda font
    FONT *AllegFont = (FONT*)Globals::FontDat[COURIER24].dat;
    FONT *Font =  allegro_gl_convert_allegro_font(AllegFont, AGL_FONT_TYPE_TEXTURED, text_height(AllegFont)/5);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    string Name = "None";
    
    bool Quit = false;   
    clear_keybuf();

    Globals::SpeedCounter = 0;
    while (!key[KEY_ESC] && !Quit)
    {
        while (Globals::SpeedCounter > 0)
        {
            //Ls in text
            if (keypressed())
            {
                int Key = readkey();
                if (key[KEY_ENTER])
                {
                    Quit = true;
                    break;
                }
                if (Key >> 8 == KEY_BACKSPACE && !Name.empty())
                    Name.erase(Name.size()-1, 1);
                else if (Name.size() < 10 && scancode_to_ascii(Key >> 8) != 0)
                {
                    if (Key >> 8 != KEY_BACKSPACE && Key >> 8 != KEY_SPACE)
                        Name += Key;
                }
            }
            Globals::SpeedCounter--;
        }
        PrepareRender();

        allegro_gl_printf(Font, -(text_length(AllegFont, "NEW HIGHSCORE!")*0.145)/2, 30.0, 0, makecol(255, 255, 255), "NEW HIGHSCORE!");
        allegro_gl_printf(Font, -(text_length(AllegFont, "Enter your name:")*0.145)/2, 20.0, 0, makecol(255, 255, 255), "Enter your name:");
        allegro_gl_printf(Font, -(text_length(AllegFont, Name.c_str())*0.145)/2, 10.0, 0, makecol(255, 255, 255), (char*)Name.c_str());
        
        allegro_gl_flip();
    }
    allegro_gl_destroy_font(Font);
    return Name;
}
//------------------------------------------------------------------------------


//Lgg till en textstrng till LevelStrings
void FileCallback(const char *filename, int attrib, int param)
{
    //Ta bort "/Levels" och ".lev" frn filnamnet
    string File(filename);
    File = File.substr(7, File.size()-11);
    
    MenuHandler::LevelStrings->AddString(File);
}
//------------------------------------------------------------------------------
