#ifndef HIGHSCORE_H
#define HIGHSCORE_H

#include <fstream>
#include <string>
#include <list>
#include "globals.h"
using namespace std;

struct HighscoreEntry
{
    string Name;
    int Score;
    bool Reversed;
};

class HighscoreManager
{
    public:
        HighscoreManager(int _EntryCount, bool _Reversed);
        ~HighscoreManager();
        void AddEntry(string Name, int Score);
        bool PrintToFile(string Filename);
        bool ReadFromFile(string Filename);
        bool IsOnList(int Score);
        unsigned int Size();
        HighscoreEntry GetEntry(int Index);
    private:
        int EntryCount;
        bool Reversed;
        list<HighscoreEntry> Entries;
};
bool operator < (const HighscoreEntry &n1, const HighscoreEntry &n2);


#endif
