#include "ball.h"

//------------------------------------------------------------------------------

//Konstruktor
Ball::Ball(float x, float z)
{
    Radius = 0.1;
    X = x;
    Z = z;
    Y = Radius;
    aX = 0.0;
    aZ = 0.0;
    aY = 0.0;
    vX = 0.0;
    vZ = 0.0;
    vY = 0.0;
    xRoll = 0.0;
    zRoll = 0.0;
    
    Elasticity = Globals::BallElasticity;
    Falling = false;
    
    //Texture
    BITMAP *Tex = load_bitmap("Data/Textures/Metal.bmp", NULL);
    if (!Tex)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture 'metal.bmp'");
        exit(1);
    }
    Texture = allegro_gl_make_texture(Tex);
    destroy_bitmap(Tex);
    
    //Ljud
    Colliding = load_sample("Data/Audio/collision.wav");
    GameOver = load_sample("Data/Audio/scream.wav");
    if (!Colliding || !GameOver)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load sound file.");
        exit(1);
    }
}
//------------------------------------------------------------------------------



//Destruktor
Ball::~Ball()
{
    stop_sample(Colliding);
    stop_sample(GameOver);

    destroy_sample(Colliding);
    destroy_sample(GameOver);
}
//------------------------------------------------------------------------------



//Rendera
void Ball::Render()
{
    glPushMatrix();
        glEnable(GL_CULL_FACE);
        glTranslatef(X, Y, Z);   
        glColor3f(0.8, 0.8, 0.8);
        GLUquadric *Quad = gluNewQuadric();
        gluQuadricNormals(Quad, GLU_SMOOTH);    
        gluQuadricTexture(Quad, GL_TRUE);
        if (Globals::Texturing)
        {
            glEnable(GL_TEXTURE_2D);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
            glBindTexture(GL_TEXTURE_2D, Texture);
        }
        glRotatef(90, 1.0, 0.0, 0.0);
        //glRotatef(xRoll, 1.0, 0.0, 0.0);
        //glRotatef(zRoll, 0.0, 0.0, 1.0);
        gluSphere(Quad, Radius, 13, 13);    
        glDisable(GL_TEXTURE_2D);
        gluDeleteQuadric(Quad);
    glPopMatrix();
    
}
//------------------------------------------------------------------------------



//Uppdatera
void Ball::Update(float xR, float zR, float SizeX, float SizeZ)
{
    float xRot = DEG_TO_RAD(xR);
    float zRot = -DEG_TO_RAD(zR);

    //X-led
    if (!Falling)
        aX = tan(zRot)*Globals::G;
    else
        aX = 0.0;
    vX += aX/(Globals::GameSpeed*6);

    //Z-led
    if (!Falling)
        aZ = tan(xRot)*Globals::G;
    else
        aZ = 0.0;
    vZ += aZ/(Globals::GameSpeed*6);

    //Y-led
    vY += aY/(Globals::GameSpeed*25);

    //Flytta
    if (vX > Radius)
        vX = Radius;
    if (vX < -Radius)
        vX = -Radius;
    if (vZ > Radius)
        vZ = Radius;
    if (vZ < -Radius)
        vZ = -Radius;
    X += vX;
    Z += vZ;
    Y += vY;
    
    //Rulla
    xRoll -= vZ/(Globals::Pi*Radius*2)*360;
    zRoll -= vX/(Globals::Pi*Radius*2)*360;

    //Studsa mot kanterna
    if ((X-Radius <= -SizeX/2 && vX < 0) || (X+Radius >= SizeX/2 && vX > 0))
    {
        if (Globals::SoundOn)
            play_sample(Colliding, (int)(fabs(vX)/Radius*255)-20, 128, 1000, false);
        vX = -vX*Elasticity;
        aX = 0.0;
    }
    if (X-Radius < -SizeX/2)
        X = -SizeX/2+Radius;
    if (X+Radius > SizeX/2)
        X = SizeX/2-Radius;

    if ((Z-Radius <= -SizeZ/2 && vZ < 0) || (Z+Radius >= SizeZ/2 && vZ > 0))
    {
        if (Globals::SoundOn)
            play_sample(Colliding, (int)(fabs(vZ)/Radius*255)-20, 128, 1000, false);
        vZ = -vZ*Elasticity;
        aZ = 0.0;
    }
    if (Z-Radius < -SizeZ/2)
        Z = -SizeZ/2+Radius;
    if (Z+Radius > SizeZ/2)
        Z = SizeZ/2-Radius;
}
//------------------------------------------------------------------------------



//Kolla kollision med en kub och studsa
void Ball::CheckCollision(Cube *C)
{
    if (X+Radius >= C->X-C->SizeX/2 && X-Radius <= C->X+C->SizeX/2)
    {
        if (Z+Radius >= C->Z-C->SizeZ/2 && Z-Radius <= C->Z+C->SizeZ/2)
        {
            //Kollision - kolla i vilket led
            float TestX = X - vX;
            if (TestX+Radius <= C->X-C->SizeX/2 || TestX-Radius >= C->X+C->SizeX/2)
            {
                if (Globals::SoundOn)
                    play_sample(Colliding, (int)(fabs(vX)/Radius*255)-20, 128, 1000, false);
                X -= vX;
                vX = -vX*Elasticity;
                aX = 0.0;
            }
            else
            {
                if (Globals::SoundOn)
                    play_sample(Colliding, (int)(fabs(vZ)/Radius*255)-20, 128, 1000, false);
                Z -= vZ;
                vZ = -vZ*Elasticity;
                aZ = 0.0;
            }
        }
    }
}
//------------------------------------------------------------------------------



//Kolla "kollision" med ett hl
void Ball::CheckCollision(float HoleX, float HoleZ)
{
    float Dist = sqrt(pow(HoleX-X, 2) + pow(HoleZ-Z, 2));
    //Rulla mot hlet
    if (Dist < Globals::HoleRadius && !Falling)
    {
        if (X < HoleX)
            vX+=0.0030;
        else
            vX-=0.0030;
        if (Z < HoleZ)
            vZ+=0.0030;
        else
            vZ-=0.0030;
    }
    //Rulla ned i hlet
    if (Dist < Globals::HoleRadius-Radius/2)
    {
        aY -= Globals::G;
        if (Globals::SoundOn && !Falling)
            play_sample(GameOver, 200, 128, 1000, false);
        Falling = true;
    }
}
//------------------------------------------------------------------------------




//Skriv ut info
void Ball::PrintInfo(FONT *Fnt)
{
    glPushMatrix();
    glScalef(0.5, 0.5, 0.5);
    allegro_gl_printf(Fnt, X, Y, Z, makecol(255, 255, 255), "vX: %.2f, vZ: %.2f, aX: %.2f, aZ: %.2f", vX, vZ, aX, aX);
    glPopMatrix();
}
//------------------------------------------------------------------------------
