#include "text.h"

//------------------------------------------------------------------------------



//Konstruktor
TextRotator::TextRotator(FONT *F, int C, int sC)
{
    Font = F;
    Col = C;
    SelCol = sC;
    Select = 0;
    AngOffset = 0;
    DestOffset = 0;
}
//------------------------------------------------------------------------------



//Rita ut text
void TextRotator::RenderText()
{
    float Radius = 3.0, Angle = 0.0;

    for (unsigned int i = 0; i < Strings.size(); ++i)
    {
        glPushMatrix();
            Angle = (AngOffset+(float)i/(float)Strings.size()*360)/360*2*Globals::Pi;
            glTranslatef(0, sin(Angle)*Radius, cos(Angle)*Radius);
            glScalef(1.2, 1.2, 2.0);
            allegro_gl_printf(Font, -TextLength(Strings[i])/2, 0, 0, i == Select?SelCol : Col, (char*)Strings[i].c_str());    
        glPopMatrix();
    }
}
//------------------------------------------------------------------------------



//Snurra texten
void TextRotator::Update()
{
    if (AngOffset < DestOffset-2)
        AngOffset+=3;
    else if (AngOffset > DestOffset+2)
        AngOffset-=3;
}
//------------------------------------------------------------------------------


//Snurra uppt
void TextRotator::Upwards()
{
    if (Select >= Strings.size()-1)
        Select = 0;
    else
        Select++;
    DestOffset -= 360.0 / (float)Strings.size();
}
//------------------------------------------------------------------------------



//Snurra nedt
void TextRotator::Downwards()
{
    if (Select <= 0)
        Select = Strings.size()-1;
    else
        Select--;
    DestOffset += 360.0 / (float)Strings.size();
}
//------------------------------------------------------------------------------



//Lgg till en textstrng
void TextRotator::AddString(string Strn)
{
    Strings.push_back(Strn);
}
//------------------------------------------------------------------------------



//Lgg till en textstrng med godtyckligt antal variabler i
void TextRotator::AddStringEx(char *Fmt, ...)
{
    va_list  Vlist;
	char Buff[256];

	va_start(Vlist, Fmt);
	vsprintf(Buff, Fmt, Vlist);
    va_end(Vlist);
    
    Strings.push_back(Buff);
}
//------------------------------------------------------------------------------


//Gr ett frsk att berkna lngden p en textstrng
/*float TextRotator::TextLength(string Strn)
{
    return Strn.size()*0.48;
}*/
//------------------------------------------------------------------------------
