#include "rocket.h"

const GLfloat Speed = 1.1;
//------------------------------------------------------------------------------


//Konstruktor
Rocket::Rocket(int Count)
{
    //Ladda bild
    BITMAP *Spark = load_bitmap("Data/Textures/spark.bmp", NULL);
    if (!Spark)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture 'spark.bmp'");
        exit(1);
    }
    Texture = allegro_gl_make_masked_texture(Spark);
    destroy_bitmap(Spark);
    
    //Skapa partikelsystem
    TrailCount = 15;
    ParticleCount = Count;
    Particles = new Particle[ParticleCount];
    Trail = new Particle[TrailCount];
    Reset();
    
    //Fr att alla inte skall brja p samma gng
    Y = Rand(-150, -50);
}
//------------------------------------------------------------------------------


//Destruktor
Rocket::~Rocket()
{
    delete []Particles;
    delete []Trail;
}
//------------------------------------------------------------------------------


//Uppdatera
void Rocket::Update()
{
    //Uppdatera explosion
    if (Exploding)
    {
        for (int i = 0; i < ParticleCount; ++i)
        {
            Particles[i].X += Particles[i].dX;
            Particles[i].Y += Particles[i].dY;
            Particles[i].dX *=0.98;
            Particles[i].dY *=0.98;
            Particles[i].dY -= 0.01;
            Particles[i].Life -= 0.01;
        }
        
        if (Particles[0].Life <= 0) //Kolla en partikels liv
            Reset();
    }
    
    //k uppt
    else
    {
        X += dX;
        Y += Speed;
        
        Trail[0].X = X;
        Trail[0].Y = Y;
        Trail[0].Life = 1.0;
        for (int i = 1; i < TrailCount; ++i)
        {
            float A = Rand(0, 10);
            Trail[i].X = X-dX*A;
            Trail[i].Y = Y-Speed*A;
            Trail[i].Life = 1-A/10;
        }
        if (Y >= DestHeight)
        {
            //Stll in fr explosion
            Exploding = true;            
            for (int i = 0; i < ParticleCount; ++i)
            {
                Particles[i].X = X;
                Particles[i].Y = Y;
                Particles[i].dX = Rand(ExplosionRingMin, ExplosionRingMax)*1.5*sin((float)i+Rand(0, 1))+dX*1.5;
                Particles[i].dY = Rand(ExplosionRingMin, ExplosionRingMax)*1.5*cos((float)i+Rand(0, 1))+Speed;
                Particles[i].Life = 1.0;
                switch (Col)
                {
                    case 0: //Rd
                        Particles[i].R = Rand(0.5, 1.0); Particles[i].G = Rand(0.0, 0.3); Particles[i].B = Rand(0.0, 0.3);
                        break;
                    case 1: //Grn
                        Particles[i].R = Rand(0.0, 0.3); Particles[i].G = Rand(0.5, 1.0); Particles[i].B = Rand(0.0, 0.3);
                        break;
                    case 2: //Gul
                        Particles[i].R = Rand(0.5, 1.0); Particles[i].G = Rand(0.5, 1.0); Particles[i].B = Rand(0.0, 0.3);
                        break;
                    case 3: //Bl
                        Particles[i].R = Rand(0.0, 0.3); Particles[i].G = Rand(0.0, 0.3); Particles[i].B = Rand(0.5, 1.0);
                        break;
                    default : //Blandat
                        Particles[i].R = Rand(0.3, 1.0); Particles[i].G = Rand(0.3, 1.0); Particles[i].B = Rand(0.3, 1.0);
                }
            }
        }
    }
}
//------------------------------------------------------------------------------


//Rita ut alla partiklar
void Rocket::Render()
{
    //Rita explosion
    if (Exploding)
    {
        glBindTexture(GL_TEXTURE_2D, Texture);
        glBegin(GL_QUADS);
        for (int i = 0; i < ParticleCount; ++i)
        {
            glColor4f(Particles[i].R, Particles[i].G, Particles[i].B, Particles[i].Life);
            glTexCoord2f(0.0, 1.0); glVertex2f(Particles[i].X-1.6, Particles[i].Y+1.6);
            glTexCoord2f(1.0, 1.0); glVertex2f(Particles[i].X+1.6, Particles[i].Y+1.6);
            glTexCoord2f(1.0, 0.0); glVertex2f(Particles[i].X+1.6, Particles[i].Y-1.6);
            glTexCoord2f(0.0, 0.0); glVertex2f(Particles[i].X-1.6, Particles[i].Y-1.6);
        }
        glEnd();
    }
    
    //Rita raket
    else
    {
        glBindTexture(GL_TEXTURE_2D, Texture);
        glBegin(GL_QUADS);
        for (int i = 0; i < TrailCount; ++i)
        {
            glColor4f(Trail[i].R, Trail[i].G, Trail[i].B, Trail[i].Life);
            glTexCoord2f(0.0, 1.0); glVertex2f(Trail[i].X-0.5, Trail[i].Y+0.5);
            glTexCoord2f(1.0, 1.0); glVertex2f(Trail[i].X+0.5, Trail[i].Y+0.5);
            glTexCoord2f(1.0, 0.0); glVertex2f(Trail[i].X+0.5, Trail[i].Y-0.5);
            glTexCoord2f(0.0, 0.0); glVertex2f(Trail[i].X-0.5, Trail[i].Y-0.5); 
        }
        glEnd();
    }
}       
//------------------------------------------------------------------------------


//Generera ett slumptal
float Rocket::Rand(float Min, float Max)
{
    return Min + ((float)rand()/(float)RAND_MAX)*(Max-Min);
}
//------------------------------------------------------------------------------


//Nollstll alla partiklar och slumpa fram en ny position
void Rocket::Reset()
{
    Exploding = false;

    //Slumpa fram ett stlle att explodera p och en startposition
    dX = Rand(-Speed/2, Speed/2), DestHeight = Rand(-20.0, 30.0);
    X = Rand(-10.0, 10.0);
    Y = -50.0;
    
    //Hur ringformad den skall vara
    ExplosionRingMin = Rand(0.01, 0.05);
    ExplosionRingMax = Rand(ExplosionRingMin, 0.6);
    
    //Slumpa frg:
    //0 - Rd  1 - Grn  2 - Gul  3 - Bl 4 - Blandat
    Col = rand()%5;
    
    //Svansen
    for (int i = 0; i < TrailCount; ++i)
    {
        Trail[i].X = X;
        Trail[i].Y = Y;
        Trail[i].Life = 1.0;
        Trail[i].R = Rand(0.7, 1.0); 
        Trail[i].G = Rand(0.7, 1.0); 
        Trail[i].B = Rand(0.7, 1.0);
    }
}
//------------------------------------------------------------------------------

