#include <fstream>
#include <cstdlib>
#include <ctime>
#include <allegro.h>
#include <alleggl.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "cube.h"
#include "ball.h"
#include "level.h"
#include "globals.h"
#include "camera.h"
#include "menu.h"

using namespace std;


//------------------------------------------------------------------------------



//Variabler fr hastighetskontroll
volatile int Frames = 0, FPS = 0;

//------------------------------------------------------------------------------



//Hastighetskontroll
void SpeedHandler()
{
    Globals::SpeedCounter++;
}
END_OF_FUNCTION(SpeedHandler);

//------------------------------------------------------------------------------



//Rkna FPS
void FPSHandler()
{
    Globals::Seconds++;
    FPS = Frames;
    Frames = 0;
}
END_OF_FUNCTION(FPSHandler);

//------------------------------------------------------------------------------



//Kr ett spel, returnera tiden
int RunGame(string Filename)
{
    //Variabler
    GLfloat LightPos[] = {0.0, 1.0, 0.0, 0.0};
    SAMPLE *FinishSample = load_sample("Data/Audio/finished.wav");
    if (!FinishSample)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load sound files.");
        exit(1);
    }
    
    //Ladda frn fil
    Level *CurrentLevel = new Level(Filename); 
    text_mode(1); 
    FONT *StatusFont = 
    allegro_gl_convert_allegro_font((FONT*)Globals::FontDat[COURIER10].dat, AGL_FONT_TYPE_TEXTURED, 16.0);

    //Undvik att banan r lutad redan frn brjan
    int TempMickeyX, TempMickeyY;
    get_mouse_mickeys(&TempMickeyX, &TempMickeyY);

    //Nollstll och starta spel
    Globals::SpeedCounter = FPS = Frames = 0;

    while (!key[KEY_ESC] && CurrentLevel->PlayerAlive() && !CurrentLevel->LevelFinished())
    {
        while (Globals::SpeedCounter > 0)
        {
            //Uppdatera logiskt
            CurrentLevel->UpdateLogic();
            Globals::SpeedCounter--;
        }
        //Uppdatera grafiskt
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        glLightfv(GL_LIGHT0, GL_POSITION, LightPos);
        
        //Rita ut banan
        glPushMatrix();
            CurrentLevel->UpdateGraphics();
        glPopMatrix();
        
        //FPS
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_LIGHTING);
        glEnable(GL_TEXTURE_2D);
        glEnable(GL_BLEND);
        glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
        allegro_gl_printf(StatusFont,-15.6,11.9,-45, makecol(255, 255, 255), "FPS: %d  Time: %d", FPS, CurrentLevel->GetPlayerTime());
        glDisable(GL_BLEND);
        glEnable(GL_LIGHTING);
        glEnable(GL_DEPTH_TEST);

        allegro_gl_flip();
        Frames++;
    }
    
    //Avsluta
    int Time = CurrentLevel->GetPlayerTime();
    if (!CurrentLevel->LevelFinished())
        Time = -1;
    else
    {
        play_sample(FinishSample, 200, 128, 1000, false);
        rest(1000);
    }
    rest(500);
    destroy_sample(FinishSample);
    delete CurrentLevel;
    allegro_gl_destroy_font(StatusFont);
    return Time;
}
//------------------------------------------------------------------------------



int main()
{
    LoadValues();

    ofstream fout("Log.txt");

    //Initiera allting
    fout << "Installing Allegro...";
    allegro_init();
    install_allegro_gl();
    install_keyboard();
    install_timer();
    install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
    fout << " Done. "<< endl << "Installing AllegroGL...";
    allegro_gl_clear_settings();
    allegro_gl_set (AGL_COLOR_DEPTH, 16);
    allegro_gl_set (AGL_Z_DEPTH, 16);
    allegro_gl_set (AGL_FULLSCREEN, Globals::Fullscreen);
    allegro_gl_set (AGL_DOUBLEBUFFER, 1);
    allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_FULLSCREEN);
    set_color_depth (32);
    fout << " Done." << endl << "Setting screen mode " << Globals::ScreenWidth << "x" << Globals::ScreenHeight;
    if (Globals::Fullscreen)
        fout << " fullscreen...";
    else
        fout << " windowed...";
    if (set_gfx_mode(GFX_OPENGL, Globals::ScreenWidth, Globals::ScreenHeight, 0, 0))
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to set graphics mode.");
        exit(1);
    }
    set_window_title("Loading...");
    install_mouse();
    fout << " Done."<<endl<<"Setting up timer...";
    LOCK_VARIABLE(Globals::SpeedCounter);
    LOCK_VARIABLE(Frames);
    LOCK_VARIABLE(FPS);
    LOCK_FUNCTION(SpeedHandler);
    LOCK_FUNCTION(FPSHandler);
    srand(time(0));
    fout << " Done" << endl<<"Setting up OpenGL...";


    //Stll in OpenGL
    GLfloat AmbientLight[] = {0.3, 0.3, 0.3, 1.0};
    GLfloat DiffuseLight[] = {0.7, 0.7, 0.7, 1.0};
    GLfloat FogColor[] = {0.0, 0.0, 0.0, 1.0};
    glLightfv(GL_LIGHT0, GL_AMBIENT, AmbientLight);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, DiffuseLight);
    glClearColor(0.0, 0.0, 0.0, 1.0);
    glFogfv(GL_FOG_COLOR, FogColor);
    glFogi(GL_FOG_MODE, GL_LINEAR);
    glFogf(GL_FOG_START, 30.0);
    glFogf(GL_FOG_END, 32.0);
    glEnable(GL_LIGHT0);
    glEnable(GL_LIGHTING);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
    glEnable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);
    allegro_gl_use_mipmapping(false);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    //Stll in renderingsinstllningar
    GLfloat fAspect;
    glViewport(0, 0, SCREEN_W, SCREEN_H);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    fAspect = (float)SCREEN_W/(float)SCREEN_H;
    gluPerspective(30.0, fAspect, 1.0, 100.0);
    fout << " Done." << endl << "Creating level:\nTexturing: ";
    if (Globals::Texturing)
        fout << "on." << endl <<"Control: ";
    else  
        fout << "off." << endl <<"Control ";
    if (Globals::MouseControl)
        fout << "mouse.... ";
    else
        fout << "keyboard... ";
    
    fout << "Done." << endl << "Loading fonts... ";
    Globals::FontDat = load_datafile("Data/Fonts/font.dat");
    fout << "Done." << endl << "Loading data... ";
    
    //Skapa menyhanterare
    MenuHandler *MHandler = new MenuHandler;
    string FileName;
    
    fout << "Done." << endl << "Running game... ";
    
    //Starta menyer och spel
    install_int_ex(SpeedHandler, BPS_TO_TIMER(Globals::GameSpeed));
    install_int_ex(FPSHandler, SECS_TO_TIMER(1));
    
    //Visa intro
    set_window_title("Labyrinth");
    MHandler->ShowIntro();
    
    //Starta menysystem
    MenuVal Choice = mvRunGame;
    int PlayerTime;
    
    while (Choice != mvExit)
    {
        Choice = MHandler->MainMenu();
        switch (Choice)
        {
            case mvRunGame:
                FileName = MHandler->PickLevel();
                if (FileName != "Quit")
                {
                    do {
                    PlayerTime = RunGame(FileName);                     
                    MHandler->FinishMessage(PlayerTime, FileName);      
                    if (PlayerTime > 0)                                 
                        MHandler->ShowHighscores(PlayerTime, FileName); 
                    } while (MHandler->PlayAgainMenu());
                    if (PlayerTime < 0)
                        MHandler->ShowHighscores(PlayerTime, FileName);
                }
                break;
            case mvOptions:
                MHandler->OptionsMenu();
                break;
            case mvCredits:
                MHandler->CreditsMenu();
                break;
            default:
                break;
        }        
    }
    
    remove_int(SpeedHandler);
    remove_int(FPSHandler);
    
    fout << " Done." << endl << "Deleting level...";

    unload_datafile(Globals::FontDat);
    SaveValues();
    delete MHandler;
    fout << " Done." << endl <<"Shutting down.";
	return 0;
}
END_OF_MAIN();
//------------------------------------------------------------------------------
