#include "camera.h"

//------------------------------------------------------------------------------



//Konstruktor
Camera::Camera(float pX, float pY, float pZ, float dX, float dY, float dZ)
{
    PosX = pX;
    PosY = pY;
    PosZ = pZ;
    DistX = dX;
    DistY = dY;
    DistZ = dZ;
}
//------------------------------------------------------------------------------ 



//Flytta kameran mot destinationspunkterna        
void Camera::Move(float DestX, float DestY, float DestZ)
{      
    PosX = DestX;
    PosZ = DestZ;
}
//------------------------------------------------------------------------------  



//Stll in kameran      
void Camera::LookAtTarget()
{
    gluLookAt(PosX+DistX, PosY+DistY, PosZ+DistZ, PosX, PosY, PosZ, 0.0, 1.0, 0.0);
}
//------------------------------------------------------------------------------

//Zooma in
void Camera::ZoomIn()
{
    if (DistZ > 0 && DistY > 0)
    {
        DistZ -= Globals::CameraSpeed;
        DistY -= Globals::CameraSpeed;
    }
}
//------------------------------------------------------------------------------


void Camera::ZoomOut()
{
    DistZ += Globals::CameraSpeed;
    DistY += Globals::CameraSpeed;
}
//------------------------------------------------------------------------------
