#ifndef BALL_H
#define BALL_H

#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include <gl/glu.h>
#include "cube.h"


#define DEG_TO_RAD(Deg) ((Deg)/180*3.141592654)

class Ball
{
    public:
        Ball(float x, float z);
        ~Ball();
        void Render();
        void Update(float xRot, float zRot, float SizeX, float SizeZ);
        void CheckCollision(Cube *C);
        void CheckCollision(float HoleX, float HoleZ);
        void PrintInfo(FONT *Fnt);

        float X, Z, Y;
    private:
        float aX, aZ, aY;
        float vX, vZ, vY;
        float xRoll, zRoll;
        float Radius;
        float Elasticity;
        bool Falling;
        unsigned int Texture;
        SAMPLE *Colliding, *GameOver;
};

#endif
