#ifndef MENU_H
#define MENU_H

#include <cmath>
#include <vector>
#include <string>
#include <fstream>
#include <alleggl.h>
#include <allegro.h>
#include <gl/glu.h>
#include "globals.h"
#include "text.h"
#include "cube.h"
#include "highscore.h"
#include "rocket.h"

using namespace std;

enum MenuVal {mvRunGame, mvOptions, mvCredits, mvExit};

void FileCallback(const char *filename, int attrib, int param);

class MenuHandler
{
    public:
        friend void FileCallback(const char *, int, int);
        MenuHandler();
        ~MenuHandler();
        void ShowIntro();
        MenuVal MainMenu();
        string PickLevel();
        bool PlayAgainMenu();
        void OptionsMenu();
        void CreditsMenu();   
        void FinishMessage(int Time, string LevelName); 
        void ShowHighscores(int Time, string LevelName);
        string GetName();
    private:
        void PrepareRender();
        void DrawTitle(string Text, float Rot);
        void DrawBackground();
        static TextRotator *LevelStrings; 
        FONT *MenuFont;
        Level **PreviewLevels;
        int BgTex;
        float BgRotate;
        SAMPLE *Applause;
};

#endif
