#include "level.h"

//------------------------------------------------------------------------------



//Konstruktor. Ls in frn fil.
Level::Level(string Filename)
{
    //Skapa fullstndigt filnamn
    string File = "Levels/";
    File += Filename;
    File += ".lev";

    //ppna fil
    ifstream Fin((char*)File.c_str());

    //Nollstll
    xRot = zRot = 0.0;

    //Dimensioner p banan
    Fin >> LevelW >> LevelH;

    //Koordinater fr hrnen
    PlaneData[0][0] = -LevelW/2; PlaneData[0][1] = 0.0; PlaneData[0][2] = LevelH/2;
    PlaneData[1][0] = LevelW/2; PlaneData[1][1] = 0.0; PlaneData[1][2] = LevelH/2;
    PlaneData[2][0] = LevelW/2; PlaneData[2][1] = 0.0; PlaneData[2][2] = -LevelH/2;
    PlaneData[3][0] = -LevelW/2; PlaneData[3][1] = 0.0; PlaneData[3][2] = -LevelH/2;

    //Objekt och hl p banan
    Fin >> ObjectCount >> HoleCount;
    Objects = new Cube *[ObjectCount];
    Holes = new Hole *[HoleCount];

    //Ls in objekt
    Cube TempObj(0, 0, 0, 0, 0, 0);
    for (int i = 0; i < ObjectCount; ++i)
    {
        Fin >> TempObj;
        Objects[i] = new Cube(TempObj);
    }

    //Hl p banan
    for (int i = 0; i < HoleCount; ++i)
    {
        volatile int tmp = i;
        Holes[0-i+tmp*2] = new Hole;
        Fin >> Holes[i]->X;
        Fin >> Holes[i]->Z;
        for (int j = 0; j < HoleRes; ++j)
        {
            Holes[i]->Data[j][0] = Holes[i]->X+cos(2*Globals::Pi*(float)j/(float)HoleRes)*Globals::HoleRadius;
            Holes[i]->Data[j][1] = 0.0;
            Holes[i]->Data[j][2] = Holes[i]->Z+sin(2*Globals::Pi*(float)j/(float)HoleRes)*Globals::HoleRadius;
        }
    }

    //Startposition
    Fin >> StartX >> StartZ >> FinishX >> FinishZ;

    Fin.close();

    //Textures
    BITMAP *Wood =  load_bitmap("Data/Textures/Wood.bmp", NULL);
    if (!Wood)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Unable to load texture 'wood.bmp'");
        exit(1);
    }
    WoodTex = allegro_gl_make_texture(Wood);
    destroy_bitmap(Wood);

    //Genereringsinstllningar fr koordinater
    float sVec[]= {1/LevelW, 0, 0, 0.5};     
    glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);   
    glTexGenfv(GL_S, GL_OBJECT_PLANE, sVec);  
    float tVec[] = {0, 0, 1/LevelH, 0.5}; 
    glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);   
    glTexGenfv(GL_T, GL_OBJECT_PLANE, tVec); 

    //Kulan
    TheBall = new Ball(StartX, StartZ);
    
    //Kamera
    Cam = new Camera(TheBall->X, TheBall->Y, TheBall->Z, 0.0, 5.0, 10.0);

    //Generera en lista
    List = glGenLists(1);
    glNewList(List, GL_COMPILE);
        DrawLevel();
    glEndList();
    
    //Testtext
    Font = allegro_gl_load_system_font_ex("Courier New", AGL_FONT_TYPE_OUTLINE, 0, 1, 1, 0.1, 32, 256);
    
    //Spelarens tid
    PlayerTime = 0;
    StartTime = Globals::Seconds;
}
//------------------------------------------------------------------------------



//Destruktor
Level::~Level()
{
    Clear();
}
//------------------------------------------------------------------------------



//Rensa banan
void Level::Clear()
{
    allegro_gl_destroy_font(Font);
    for (int i = 0; i < ObjectCount; ++i)
            delete Objects[i];
    for (int i = 0; i != HoleCount; ++i)
            delete Holes[i];
    delete []Objects;
    delete []Holes;
    delete TheBall;
    delete Cam;
    glDeleteLists(List, 1);
}
//------------------------------------------------------------------------------



//Uppdatera det logiska
void Level::UpdateLogic()
{
    //Uppdatera tiden
    PlayerTime = Globals::Seconds-StartTime;

    //Uppdatera kamera
    Cam->Move(TheBall->X, TheBall->Y, TheBall->Z);
    if (key[KEY_A])
        Cam->ZoomOut();
    if (key[KEY_Z]) 
        Cam->ZoomIn();

    //Luta planet
    if (Globals::MouseControl)
    {
        int MickeyX, MickeyY;
        get_mouse_mickeys(&MickeyX, &MickeyY);
        zRot -= (float)MickeyX*0.005*Globals::MouseSens;
        xRot += (float)MickeyY*0.005*Globals::MouseSens;
        if (xRot < -5.0)
            xRot = -5.0;
        if (xRot > 5.0)
            xRot = 5.0;
        if (zRot < -5.0)
            zRot = -5.0;
        if (zRot > 5.0)
            zRot = 5.0;
    }
    else
    {
        if (key[KEY_UP] && xRot > -5.0)
            xRot-=0.08*Globals::MouseSens;
        if (key[KEY_DOWN] && xRot < 5.0)
            xRot+=0.08*Globals::MouseSens;
        if (key[KEY_LEFT] && zRot < 5.0)
            zRot+=0.08*Globals::MouseSens;
        if (key[KEY_RIGHT] && zRot > -5.0)
            zRot-=0.08*Globals::MouseSens;
    }
    //Uppdatera kulan
    TheBall->Update(xRot, zRot, LevelW, LevelH);
    //Kolla kollision
    for (int i = 0; i < ObjectCount; ++i)
        TheBall->CheckCollision(Objects[i]);
    for (int i = 0; i < HoleCount; ++i)
        TheBall->CheckCollision(Holes[i]->X, Holes[i]->Z);
}
//------------------------------------------------------------------------------



//Rita ut en liten bana utan kanter
void Level::DrawPreview()
{
    glPushMatrix();
        //Rita sjlva banan
        float sVec[]= {1/LevelW, 0, 0, 0.5};     
        glTexGenfv(GL_S, GL_OBJECT_PLANE, sVec);  
        float tVec[] = {0, 0, 1/LevelH, 0.5}; 
        glTexGenfv(GL_T, GL_OBJECT_PLANE, tVec); 
        glCallList(List);
        //Rita hinder
        if (Globals::Texturing)
        {
            glEnable(GL_TEXTURE_2D);
            glBindTexture(GL_TEXTURE_2D, WoodTex);
        }
        else
            glDisable(GL_TEXTURE_2D);
        glColor3f(0.9, 0.6, 0.2);
        glFrontFace(GL_CW);
        for (int i = 0; i < ObjectCount; ++i)
            Objects[i]->Render();
        glDisable(GL_TEXTURE_2D);
    glPopMatrix();
}
//------------------------------------------------------------------------------



//Uppdatera det grafiska
void Level::UpdateGraphics()
{
    Cam->LookAtTarget();

    glPushMatrix();
        glRotatef(xRot, 1.0, 0.0, 0.0);
        glRotatef(zRot, 0.0, 0.0, 1.0);
        //Rita sjlva banan
        glCallList(List);
        //Rita hinder
        if (Globals::Texturing)
        {
            glEnable(GL_TEXTURE_2D);
            glBindTexture(GL_TEXTURE_2D, WoodTex);
        }
        else
            glDisable(GL_TEXTURE_2D);
        glColor3f(0.9, 0.6, 0.2);
        glFrontFace(GL_CW);
        for (int i = 0; i < ObjectCount; ++i)
        {
            if (Objects[i]->X > Cam->PosX-7 && Objects[i]->X < Cam->PosX+7)
                Objects[i]->Render();
        }
        //Rita bollen
        TheBall->Render();
    glPopMatrix();
    //Rita kanter
    DrawEdges();
}
//------------------------------------------------------------------------------



//Rita ut banan
void Level::DrawLevel()
{
    //Rita ett plan
    Tess = gluNewTess();
    gluTessCallback(Tess, GLU_BEGIN, (TessFunc)glBegin);
    gluTessCallback(Tess, GLU_VERTEX, (TessFunc)glVertex3dv);
    gluTessCallback(Tess, GLU_END, glEnd);
    glColor3f(1.0, 0.75, 0.35);
    glNormal3f(0.0, 1.0, 0.0);
    glFrontFace(GL_CCW);
    if (Globals::Texturing)
    {
        glEnable(GL_TEXTURE_2D);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
        glBindTexture(GL_TEXTURE_2D, WoodTex);
        glEnable(GL_TEXTURE_GEN_S);   
        glEnable(GL_TEXTURE_GEN_T); 
    }
    else
    {
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_TEXTURE_GEN_S);
        glDisable(GL_TEXTURE_GEN_T);
    }
    gluTessBeginPolygon(Tess, (GLvoid *)0);
    gluTessBeginContour(Tess);
    for (int i = 0; i < 4; ++i)
        gluTessVertex(Tess, (GLdouble*)PlaneData[i], (GLdouble*)PlaneData[i]);
    gluTessEndContour(Tess);
    //Hl
    for (int i = 0; i < HoleCount; ++i)
    {
        gluTessBeginContour(Tess);
        for (int j = 0; j < HoleRes; ++j)
            gluTessVertex(Tess, (GLdouble*)Holes[i]->Data[j], (GLdouble*)Holes[i]->Data[j]);
        gluTessEndContour(Tess);
    }
    gluTessEndPolygon(Tess);
    gluDeleteTess(Tess);
    glDisable(GL_TEXTURE_GEN_S);
    glDisable(GL_TEXTURE_GEN_T);
    //Rita ut mlet
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_CULL_FACE);
    glPushMatrix();
        glColor3f(0.4, 0.4, 1.0);
        GLUquadric *Quad = gluNewQuadric();
        gluQuadricNormals(Quad, GLU_SMOOTH);
        glTranslatef(FinishX, 0.0, FinishZ);
        glRotatef(-90.0, 1.0, 0.0, 0.0);
        gluCylinder(Quad, Globals::HoleRadius, Globals::HoleRadius, 0.1, 10, 1);
        gluDeleteQuadric(Quad);
    glPopMatrix();
}
//------------------------------------------------------------------------------



//Rita ut kanter runt banan
void Level::DrawEdges()
{
    if (Globals::Texturing)
    {
        glEnable(GL_TEXTURE_2D);
        glBindTexture(GL_TEXTURE_2D, WoodTex);
    }
    else
        glDisable(GL_TEXTURE_2D);
    glDisable(GL_CULL_FACE);
    glBegin(GL_QUADS);
        glColor3f(1.0, 0.75, 0.35);
        //Vnster
        glNormal3f(-1.0, 0.0, 0.0);
        glTexCoord2f(1.0, 1.0);  glVertex3f(-LevelW/2, 1.0, LevelH/2); 
        glTexCoord2f(1.0, 0.0);  glVertex3f(-LevelW/2, 1.0, -LevelH/2);
        glTexCoord2f(0.0, 0.0);  glVertex3f(-LevelW/2, -1.5, -LevelH/2); 
        glTexCoord2f(0.0, 1.0);  glVertex3f(-LevelW/2, -1.5, LevelH/2);
        //Hger
        glNormal3f(1.0, 0.0, 0.0);
        glTexCoord2f(1.0, 1.0);  glVertex3f(LevelW/2, 1.0, LevelH/2); 
        glTexCoord2f(1.0, 0.0); glVertex3f(LevelW/2, 1.0, -LevelH/2);
        glTexCoord2f(0.0, 0.0);  glVertex3f(LevelW/2, -1.5, -LevelH/2); 
        glTexCoord2f(0.0, 1.0);  glVertex3f(LevelW/2, -1.5, LevelH/2);
        //Bakre
        glNormal3f(0.0, 0.0, -1.0);
        glTexCoord2f(0.0, 1.0);  glVertex3f(-LevelW/2, 1.0, -LevelH/2); 
        glTexCoord2f(1.0, 1.0);  glVertex3f(LevelW/2, 1.0, -LevelH/2);
        glTexCoord2f(1.0, 0.0);  glVertex3f(LevelW/2, -1.5, -LevelH/2); 
        glTexCoord2f(0.0, 0.0);  glVertex3f(-LevelW/2, -1.5, -LevelH/2);
    glEnd();
    glEnable(GL_CULL_FACE);
}
//------------------------------------------------------------------------------



//Kolla om man har klarat banan
bool Level::LevelFinished()
{
    float Dist = sqrt( pow(TheBall->X-FinishX,2) + pow(TheBall->Z-FinishZ, 2) );
    return Dist < Globals::HoleRadius;
}
//------------------------------------------------------------------------------
