#ifndef PSYSTEM_H
#define PSYSTEM_H

#include <alleggl.h>
#include <allegro.h>
#include <gl/glu.h>
#include <cstdlib>
#include <cmath>
using namespace std;

struct Particle
{
    //Position
    GLfloat X, Y;
    //Frflyttning
    GLfloat dX, dY;
    //Frg och alfa
    GLfloat R, G, B, Life;
};

class Rocket
{
    public:
        Rocket(int Count);
        ~Rocket();
        void Update();
        void Render();
    private:
        void Reset();
        float Rand(float Min, float Max);
        
        //Postion, frflyttning och plats fr explostion
        GLfloat X, Y, dX, DestHeight;
        //Om den exploderar eller inte
        bool Exploding;
        //Frg
        int Col;
        //Anvnds fr att hlla koll p hur ringformad explosionen r
        GLfloat ExplosionRingMin, ExplosionRingMax;
        
        //Olika partikelsystem
        Particle *Particles;
        Particle *Trail;
        GLsizei ParticleCount;
        GLsizei TrailCount;
        
        //Texture
        GLuint Texture;
};

#endif
