/* -*- ObjC -*- */
#ifndef __included_weapon_h
#define __included_weapon_h

#include <objc/Object.h>

@protocol PulseWeapon
- (id) setWaveDelay:(int)t;
- (id) setShotDelay:(int)t1 WaveDelay:(int)t2;
- (id) setShotsPerWave:(int)n;
- (int) currentShot;
@end

/*------------------------------------------------------------*/

@interface Weapon: Object
{
    Class projectile;
    int fire_tics;		/* Tics until next shot. */
    int shot_delay;		/* Tics between shots. */
}
- (id) setProjectile:(Class)c;
- (id) setShotDelay:(int)t;
- (id) setFireTics:(int)t;
- (int) fireTics;
- (BOOL) fireFromX:(double)x Y:(double)y;
- (BOOL) fireFromX:(double)x Y:(double)y angle:(double)theta;
@end

@interface PulseWeapon: Weapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

/*------------------------------------------------------------*/

@interface OffcentreWeapon: Weapon
{
    int xd, yd;			/* x/y displacement. */
}
- (id) setXDisplacement:(double)x YDisplacement:(double)y;
@end

@interface OffcentrePulseWeapon: OffcentreWeapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

/*------------------------------------------------------------*/

@interface DualWeapon: OffcentreWeapon <PulseWeapon>
{
    int wave_delay;
    int shots_per_wave, current_shot_num;
}
@end

/*------------------------------------------------------------*/

@interface RingWeapon: Weapon
{
    double step_size;
    int num_steps;
}
- (id) setStepSize:(double)ss;
- (id) setNumSteps:(int)steps;
@end

#endif
