/* viking.m,
 *
 * A sonic-wave turret with two viking horns.  Can be nasty.
 */

#include "common.h"
#include "debris/turret.h"
#include "projectiles/shockwave.h"
#include "seborrhea/container-animation.h"
#include "units/viking.h"


static SebFile *viking_sebum;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface VikingBaseDebri: Debri
@end

@interface VikingTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Viking
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Shockwave); }

+ (BOOL) loadData
{
    viking_sebum = [SebFile new];
    if (not [viking_sebum loadSebumDirectory:"data/viking"])
	return NO;

    fire_anim = (SebAnimation *)[viking_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(viking_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 8;

    sprite = [viking_sebum getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[Weapon new]
	       setProjectile:[Shockwave class]]
	      setShotDelay:60];

    base_debri    = [VikingBaseDebri class];
    turret_debri  = [VikingTurretDebri class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if (gun && [gun fireFromX:x Y:y angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];
}
@end

/*------------------------------------------------------------*/

@implementation VikingBaseDebri
- init
{
    [super init];
    sprite = [viking_sebum getSebumByName:"debri"];
    return self;
}
@end

@implementation VikingTurretDebri
- init
{
    [super init];
    health = max_health = 80;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
