/* tripe.m,
 *
 * Triple barreled turret.
 */

#include "common.h"
#include "debris/turret.h"
#include "projectiles/plasma.h"
#include "seborrhea/container-animation.h"
#include "sound.h"
#include "units/tripe.h"


static SebFile *tripe_sebum;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface TripeBaseDebri: Debri
@end

@interface TripeTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Tripe
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Plasma); }

+ (BOOL) loadData
{
    tripe_sebum = [SebFile new];
    if (not [tripe_sebum loadSebumDirectory:"data/tripe"])
	return NO;

    fire_anim = (SebAnimation *)[tripe_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(tripe_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 14;

    sprite = [tripe_sebum getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    /* Guns. */
    gun = [[[[[OffcentreWeapon new]
		 setProjectile:[Plasma class]]
		setShotDelay:60] setFireTics:0]
	      setXDisplacement:15 YDisplacement:0];
    lgun = [[[[[OffcentreWeapon new]
		  setProjectile:[Plasma class]]
		 setShotDelay:60] setFireTics:10]
	       setXDisplacement:15 YDisplacement:-8];
    rgun = [[[[[OffcentreWeapon new]
		  setProjectile:[Plasma class]]
		 setShotDelay:60] setFireTics:20]
	       setXDisplacement:15 YDisplacement:8];

    base_debri    = [TripeBaseDebri class];
    turret_debri  = [TripeTurretDebri class];
    chunk_colours = CHUNK_SARDAUKAR;
    return self;
}

- (void) fire
{
    if ([gun fireFromX:x Y:y angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];

    [lgun fireFromX:x Y:y angle:angle];
    [rgun fireFromX:x Y:y angle:angle];
}
@end

/*------------------------------------------------------------*/

@implementation TripeBaseDebri
- init
{
    [super init];
    sprite = [tripe_sebum getSebumByName:"debri"];
    return self;
}
@end

@implementation TripeTurretDebri
- init
{
    [super init];
    health = max_health = 90;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
