/* stumpy.m,
 *
 * Ships that can change their direction of movement halfway (just
 * once).  Good for making cool looking formations.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "map.h"
#include "projectiles/fireball.h"
#include "seborrhea/container-animation.h"
#include "unit-mapextras.h"
#include "units/stumpy.h"


static SebFile *stumpy_sebum;
static SebAnimation *fire_anim;


@implementation Stumpy
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    stumpy_sebum = [SebFile new];
    if (not [stumpy_sebum loadSebumDirectory:"data/stumpy"])
	return NO;

    fire_anim = (SebAnimation *)[stumpy_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(stumpy_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 4;
    speed = 1.1;

    sprite = [[SebAnimator new] setAnimation:fire_anim];
    shadow = [stumpy_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[[DualWeapon new]
		 setProjectile:[Fireball class]]
		setShotDelay:-40 WaveDelay:80]
	       setShotsPerWave:2]
	      setXDisplacement:13 YDisplacement:12];
    
    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) enableMovement
{
    /* For Stumpy, activate_y means where to reach before starting to
       move in the direction of the specified angle.  Otherwise move
       down the screen. */
    if (y + [sprite height]/2 + activate_y >= offsetY)
        flags |= FLAG_MOVING_ENABLED;
    else
	y += speed;
}

- (void) move
{
    if (travel_range <= 0)
	angle = -M_PI_2;
    else
	travel_range -= speed;

    [super move];
}

- (void) fireProjectiles
{
    if ([gun fireFromX:x Y:y])
	sprite = [(SebAnimator *)sprite setAnimation:fire_anim];
}

	/* Load/Save.  Format: travel_range;activate_y;x;y;a[;flags] */
- (void) importUnitProperties:(char *)str
{
    char str2[1024];
    double a, b;

    sscanf(str, "%lf;%lf;%s", &a, &b, str2);
    [super importUnitProperties:str2];
    travel_range = a;
    activate_y = b;
}

- (char *) exportUnitProperties:(char *)str
{
    char str2[1024] = "\0";

    [super exportUnitProperties:str2];
    snprintf(str, sizeof(str2), "%g;%d;%s", travel_range, activate_y, str2);
    return str;
}

	/* For use in map editor only! */
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
    draw_travel_range(dest, x, y, angle, travel_range);
}

	/* Protocol stuff. */
- derive_setActivationLine;
- derive_setTravelRange(travel_range);
@end
