/* stubby.m,
 *
 * Stumpies with more health, and auto-aiming rocket launcher.
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "map.h"
#include "projectiles/rocket.h"
#include "rotate.h"
#include "seborrhea/seborrhea.h"
#include "unit-seeking.h"
#include "units/stubby.h"


static SebFile *stubby_sebum;


@implementation Stubby
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Rocket); }
+ derive_loadData(stubby_sebum, "data/stubby");
+ derive_shutdown(stubby_sebum);

- init
{
    [super init];

    health = 6;
    speed = 1.0;

    sprite = [stubby_sebum getSebumByName:"stubby"];
    turret = [stubby_sebum getSebumByName:"turret"];
    shadow = [stubby_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[PulseWeapon new]
		setProjectile:[Rocket class]]
	       setShotDelay:10 WaveDelay:65]
	      setShotsPerWave:2];
    turret_angle = -M_PI_2;

    return self;
}

- (void) draw:(BITMAP *)dest
{
    [super draw:dest];

    if (turret)
	[turret drawTo:dest X:x-offsetX Y:y-offsetY-8 Angle:turret_angle];
}

- (int) update
{
    desired_turret_angle = ANGLE_TO_CLOSEST_ALLY(x, y);
    limited_rotate(&turret_angle, desired_turret_angle, deg2rad(1.5));
    simplify_angle(&turret_angle);
    return [super update];
}

- (void) fireProjectiles { [gun fireFromX:x Y:y-8 angle:turret_angle]; }
@end
