/* strumble.m,
 *
 * STRUMBLE (strum' bul) n.:
 *	That invisible object you always pretend made you trip, when
 *	it was actually your own stupid clumsiness.
 *		-- Rich Hall, "Sniglets"
 */

#include <allegro.h>
#include <math.h>
#include "common.h"
#include "debris/speed-shadow.h"
#include "seborrhea/container-animation.h"
#include "unit-mapextras.h"
#include "units/strumble.h"


static SebFile *strumble_sebum;
static SebAnimation *move_anim, *thrust_anim;

/*------------------------------------------------------------*/

@interface StrumbleSpeedShadow: SpeedShadow
@end

/*------------------------------------------------------------*/

@implementation Strumble
+ (BOOL) loadData
{
    strumble_sebum = [SebFile new];
    if (not [strumble_sebum loadSebumDirectory:"data/strumble"])
	return NO;

    move_anim = (SebAnimation *)[strumble_sebum getSebumByName:"move-anim"];
    thrust_anim = (SebAnimation *)[strumble_sebum getSebumByName:"thrust"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(strumble_sebum);
    move_anim = nil;
    thrust_anim = nil;
}

- init
{
    [super init];

    health = 3;
    speed = 4.0;
    angle = M_PI_2;
    activate_y = -screen_h;

    sprite = [[SebAnimator new] setAnimation:move_anim];
    shadow = [strumble_sebum getSebumByName:"shadow"];
    w = [sprite width];
    h = [sprite height] - 4;

    chunk_colours = CHUNK_COFFEE;
    return self;
}

- (void) move
{
    [super move];

    if (move_phase == 0) {
	if (speed > 3.0)
	    speed -= 0.01;
	else {
	    move_phase = 1;
	    sprite = [(SebAnimator *)sprite setAnimation:thrust_anim];
	}
    }
    else {
	if (++move_phase == 3) {
	    move_phase = 1;
	    spawn_debris([StrumbleSpeedShadow class], x, y, MEDIUM_LAYER);
	}
	speed += 0.08;
    }
}

	/* For use in map editor only! */
- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}

- derive_fixedAngle;
@end

/*------------------------------------------------------------*/

@implementation StrumbleSpeedShadow
- init
{
    [super init];

    health = max_health = 8;
    speed = 0.5;
    angle = M_PI_2;

    sprite = [strumble_sebum getSebumByName:"speedy"];

    return self;
}
@end
