/* stone.m,
 *
 * Light-ish turrets that scatter lots of fireballs.
 */

#include "common.h"
#include "debris/turret.h"
#include "projectiles/fireball.h"
#include "seborrhea/container-animation.h"
#include "units/stone.h"


static SebFile *stone_sebum;
static SebAnimation *fire_anim;

/*------------------------------------------------------------*/

@interface StoneBaseDebri: Debri
@end

@interface StoneTurretDebri: TurretDebri
@end

/*------------------------------------------------------------*/

@implementation Stone
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(Fireball); }

+ (BOOL) loadData
{
    stone_sebum = [SebFile new];
    if (not [stone_sebum loadSebumDirectory:"data/stone"])
	return NO;

    fire_anim = (SebAnimation *)[stone_sebum getSebumByName:"fire-anim"];
    return YES;
}

+ (void) shutdown
{
    FREE_SEBFILE(stone_sebum);
    fire_anim = nil;
}

- init
{
    [super init];

    health = 5;

    sprite = [stone_sebum getSebumByName:"stand"];
    turret = [[SebAnimator new] setAnimation:fire_anim];
    w = [sprite width];
    h = [sprite height];

    gun = [[[[PulseWeapon new]
		setProjectile:[Fireball class]]
	       setShotDelay:5 WaveDelay:50]
	      setShotsPerWave:4];

    base_debri    = [StoneBaseDebri class];
    turret_debri  = [StoneTurretDebri class];
    chunk_colours = CHUNK_RED;
    return self;
}

- (void) fire
{
    if (gun && [gun fireFromX:x Y:y angle:angle])
	[(SebAnimator *)turret setAnimation:fire_anim];
}
@end

/*------------------------------------------------------------*/

@implementation StoneBaseDebri
- init
{
    [super init];
    sprite = [stone_sebum getSebumByName:"debri"];
    return self;
}
@end

@implementation StoneTurretDebri
- init
{
    [super init];
    health = max_health = 75;
    sprite = [fire_anim getFrame:-1];
    return self;
}
@end
