/* sea-urchin.m,
 *
 * A submarine.
 */

#include <math.h>
#include "common.h"
#include "debris/ripple.h"
#include "map.h"
#include "projectiles/evil-vulcan.h"
//#include "seborrhea/seborrhea.h"
#include "unit-mapextras.h"
#include "units/sea-urchin.h"


static SebFile *urchin_sebum;


@implementation SeaUrchin
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(EvilVulcan); }
+ derive_loadData(urchin_sebum, "data/sea-urchin");
+ derive_shutdown(urchin_sebum);

- init
{
    [super init];

    health = 5;
    speed = 0.5;

    sprite = [urchin_sebum getSebumByName:"body"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    chunk_colours = CHUNK_BLUE;
    return self;
}

- (void) move
{
    if (flags & FLAG_MOVING_ENABLED) {
	if (SQ(x - last_ripple_x) + SQ(y - last_ripple_y) >= SQ(6.0)) {
	    double deltax, deltay;

	    last_ripple_x = x;
	    last_ripple_y = y;

	    deltax = 9*sin(angle) - 24*sin(angle+M_PI_2);
	    deltay = 9*cos(angle) - 24*cos(angle+M_PI_2);
	    spawn_debris([Ripple class], x+deltax, y+deltay, FLOOR_LAYER);

	    deltax = -9*sin(angle) - 24*sin(angle+M_PI_2);
	    deltay = -9*cos(angle) - 24*cos(angle+M_PI_2);
	    spawn_debris([Ripple class], x+deltax, y+deltay, FLOOR_LAYER);
	}

	[super move];
    }
}

- (void) draw:(BITMAP *)dest
{
    if (y + activate_y >= offsetY) {
	[super draw:dest];
    }
    else {
	int alpha;

	if (y + activate_y + 60 <= offsetY)
	    alpha = 0xe0;
	else {
	    alpha = 0xe0 * (y + activate_y - offsetY)/(-60);
	    alpha = MID(0x00, alpha, 0xe0);
	}

	[sprite drawTo:dest X:x-offsetX Y:y-offsetY Tint:0x00:0x20:0x40:alpha Angle:angle];
    }
}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_activation_line(dest, x, y, activate_y);
}

- (int) collisionLists
{
    if (not (flags & FLAG_MOVING_ENABLED))
	return 0;
    else
	return COLLIDES_WITH_PROJECTILES_AND_NUKES;
}

- derive_setActivationLine;
- derive_importUnitPropertiesWithVariableActivationLine;
- derive_exportUnitPropertiesWithVariableActivationLine;
@end
