/* sea-dog.m,
 */

#include <math.h>
#include "common.h"
#include "debris/ripple.h"
#include "projectiles/pulse-laser.h"
#include "seborrhea/seborrhea.h"
#include "unit-mapextras.h"
#include "units/all-units.h"
#include "units/sea-dog.h"


static SebFile *dog_sebum;


@implementation SeaDog
+ (BOOL) loadPrerequisites { return LOAD_PROJECTILE_DATA_FOR(PulseLaser); }

+ (BOOL) loadData
{
    if (dog_sebum)		/* Don't load twice. */
	return YES;

    dog_sebum = [SebFile new];
    return [dog_sebum loadSebumDirectory:"data/sea-dog"];
}

+ derive_shutdown(dog_sebum);

- init
{
    [super init];

    health = 4;
    speed = 3.0;
    the_way = (SebSpline *)[dog_sebum getSebumByName:"path"];
    activate_y = -480;

    sprite = [dog_sebum getSebumByName:"body"];
    w = [sprite width];
    h = [sprite height];
    rotatable_unit = YES;

    left_gun = [[[[OffcentreWeapon new]
		     setProjectile:[PulseLaser class]]
		    setShotDelay:30]
		   setXDisplacement:15 YDisplacement:-10];
    right_gun = [[[[OffcentreWeapon new]
		      setProjectile:[PulseLaser class]]
		     setShotDelay:30]
		    setXDisplacement:15 YDisplacement:10];

    flags |= FLAG_FIRING_ENABLED;
    chunk_colours = CHUNK_BLUE;
    return self;
}

- free
{
    if (left_gun)
	left_gun =  [left_gun  free];
    if (right_gun)
	right_gun = [right_gun free];
    return [super free];
}

- (void) move
{
    if (SQ(x - last_ripple_x) + SQ(y - last_ripple_y) >= SQ(6.0)) {
	double deltax, deltay;

	last_ripple_x = x;
	last_ripple_y = y;

 	deltax = 8*sin(angle) - 20*sin(angle+M_PI_2);
	deltay = 8*cos(angle) - 20*cos(angle+M_PI_2);
	spawn_debris([Ripple class], x+deltax, y+deltay, FLOOR_LAYER);

 	deltax = -8*sin(angle) - 20*sin(angle+M_PI_2);
	deltay = -8*cos(angle) - 20*cos(angle+M_PI_2);
	spawn_debris([Ripple class], x+deltax, y+deltay, FLOOR_LAYER);
    }

    [super move];
}

- (void) fire
{
    [left_gun  fireFromX:x Y:y angle:angle-deg2rad(1.2)];
    [right_gun fireFromX:x Y:y angle:angle+deg2rad(1.2)];
}

- (void) drawMapEditorExtras:(BITMAP *)dest
{
    [super drawMapEditorExtras:dest];
    draw_fixed_activation_line(dest, x, y, activate_y);
}
@end

/*------------------------------------------------------------*/

@implementation SeaDogSweeper
- init
{
    [super init];
    the_way = (SebSpline *)[dog_sebum getSebumByName:"path-across"];
    activate_y = -200;
    return self;
}

- (id) setX:(double)x_ Y:(double)y_
{
    [super setX:x_ Y:y_];

    /* This is really just to look good in the map editor. */
    if (x < screen_w / 2)
	angle = 0;
    else
	angle = M_PI;

    return self;
}

	/* Data sharing tweaks. */
+ (BOOL) loadData { return LOAD_UNIT_DATA_FOR(SeaDog, NO); }
+ (void) shutdown { /* Do nothing. */ }
@end
